/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Enumeration;
import java.util.Iterator;
import java8.util.Objects;
import java8.util.PrimitiveIterator;
import java8.util.function.Consumer;
import java8.util.function.DoubleConsumer;
import java8.util.function.IntConsumer;
import java8.util.function.LongConsumer;

public final class Iterators {
    public static <E> void forEachRemaining(Iterator<E> it, Consumer<? super E> action) {
        Objects.requireNonNull(it);
        Objects.requireNonNull(action);
        while (it.hasNext()) {
            action.accept(it.next());
        }
    }

    public static void forEachRemaining(PrimitiveIterator.OfInt it, IntConsumer action) {
        Objects.requireNonNull(it);
        Objects.requireNonNull(action);
        while (it.hasNext()) {
            action.accept((Integer)it.next());
        }
    }

    public static void forEachRemaining(PrimitiveIterator.OfLong it, LongConsumer action) {
        Objects.requireNonNull(it);
        Objects.requireNonNull(action);
        while (it.hasNext()) {
            action.accept((Long)it.next());
        }
    }

    public static void forEachRemaining(PrimitiveIterator.OfDouble it, DoubleConsumer action) {
        Objects.requireNonNull(it);
        Objects.requireNonNull(action);
        while (it.hasNext()) {
            action.accept((Double)it.next());
        }
    }

    public static <E> Iterator<E> asIterator(final Enumeration<E> en) {
        Objects.requireNonNull(en);
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public E next() {
                return en.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private Iterators() {
    }
}

