/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Comparator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.ReentrantLock;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.UnsafeAccess;
import java8.util.function.Consumer;
import sun.misc.Unsafe;

final class LBDSpliterator<E>
implements Spliterator<E> {
    private static final int MAX_BATCH = 0x2000000;
    private final LinkedBlockingDeque<E> queue;
    private final ReentrantLock queueLock;
    private Object current;
    private int batch;
    private boolean exhausted;
    private long est;
    private static final Unsafe UNSAFE;
    private static final long FIRST_OFF;
    private static final long LOCK_OFF;
    private static final long NODE_ITEM_OFF;
    private static final long NODE_NEXT_OFF;

    private LBDSpliterator(LinkedBlockingDeque<E> queue) {
        this.queue = queue;
        this.est = queue.size();
        this.queueLock = LBDSpliterator.getQueueLock(queue);
    }

    static <T> Spliterator<T> spliterator(LinkedBlockingDeque<T> queue) {
        return new LBDSpliterator<T>(queue);
    }

    @Override
    public int characteristics() {
        return 4368;
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        LinkedBlockingDeque<E> q = this.queue;
        ReentrantLock lock = this.queueLock;
        if (!this.exhausted) {
            this.exhausted = true;
            Object p = this.current;
            do {
                Object e = null;
                lock.lock();
                try {
                    if (p == null) {
                        p = LBDSpliterator.getQueueFirst(q);
                    }
                    while (p != null) {
                        e = LBDSpliterator.getNodeItem(p);
                        p = LBDSpliterator.getNextNode(p);
                        if (e == null) continue;
                        break;
                    }
                }
                finally {
                    lock.unlock();
                }
                if (e == null) continue;
                action.accept(e);
            } while (p != null);
        }
    }

    @Override
    public Comparator<? super E> getComparator() {
        return Spliterators.getComparator(this);
    }

    @Override
    public long getExactSizeIfKnown() {
        return Spliterators.getExactSizeIfKnown(this);
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return Spliterators.hasCharacteristics(this, characteristics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        LinkedBlockingDeque<E> q = this.queue;
        ReentrantLock lock = this.queueLock;
        if (!this.exhausted) {
            Object e = null;
            lock.lock();
            try {
                if (this.current == null) {
                    this.current = LBDSpliterator.getQueueFirst(q);
                }
                while (this.current != null) {
                    e = LBDSpliterator.getNodeItem(this.current);
                    this.current = LBDSpliterator.getNextNode(this.current);
                    if (e == null) continue;
                    break;
                }
            }
            finally {
                lock.unlock();
            }
            if (this.current == null) {
                this.exhausted = true;
            }
            if (e != null) {
                action.accept(e);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<E> trySplit() {
        Object h;
        int n;
        LinkedBlockingDeque<E> q = this.queue;
        int b = this.batch;
        int n2 = b <= 0 ? 1 : (n = b >= 0x2000000 ? 0x2000000 : b + 1);
        if (!(this.exhausted || (h = this.current) == null && (h = LBDSpliterator.getQueueFirst(q)) == null || LBDSpliterator.getNextNode(h) == null)) {
            Object[] a = new Object[n];
            ReentrantLock lock = this.queueLock;
            int i = 0;
            Object p = this.current;
            lock.lock();
            try {
                if (p != null || (p = LBDSpliterator.getQueueFirst(q)) != null) {
                    do {
                        if ((a[i] = LBDSpliterator.getNodeItem(p)) == null) continue;
                        ++i;
                    } while ((p = LBDSpliterator.getNextNode(p)) != null && i < n);
                }
            }
            finally {
                lock.unlock();
            }
            this.current = p;
            if (this.current == null) {
                this.est = 0L;
                this.exhausted = true;
            } else if ((this.est -= (long)i) < 0L) {
                this.est = 0L;
            }
            if (i > 0) {
                this.batch = i;
                return Spliterators.spliterator(a, 0, i, 4368);
            }
        }
        return null;
    }

    private static ReentrantLock getQueueLock(LinkedBlockingDeque<?> queue) {
        return (ReentrantLock)UNSAFE.getObject(queue, LOCK_OFF);
    }

    private static Object getQueueFirst(LinkedBlockingDeque<?> queue) {
        return UNSAFE.getObject(queue, FIRST_OFF);
    }

    private static Object getNextNode(Object node) {
        return UNSAFE.getObject(node, NODE_NEXT_OFF);
    }

    private static <T> T getNodeItem(Object node) {
        return (T)UNSAFE.getObject(node, NODE_ITEM_OFF);
    }

    static {
        try {
            UNSAFE = UnsafeAccess.unsafe;
            Class<LinkedBlockingDeque> lbdc = LinkedBlockingDeque.class;
            Class<?> nc = Class.forName("java.util.concurrent.LinkedBlockingDeque$Node");
            FIRST_OFF = UNSAFE.objectFieldOffset(lbdc.getDeclaredField("first"));
            LOCK_OFF = UNSAFE.objectFieldOffset(lbdc.getDeclaredField("lock"));
            NODE_ITEM_OFF = UNSAFE.objectFieldOffset(nc.getDeclaredField("item"));
            NODE_NEXT_OFF = UNSAFE.objectFieldOffset(nc.getDeclaredField("next"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

