/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Comparator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.UnsafeAccess;
import java8.util.function.Consumer;
import sun.misc.Unsafe;

final class LBQSpliterator<E>
implements Spliterator<E> {
    private static final int MAX_BATCH = 0x2000000;
    private final LinkedBlockingQueue<E> queue;
    private final ReentrantLock putLock;
    private final ReentrantLock takeLock;
    private Object current;
    private int batch;
    private boolean exhausted;
    private long est;
    private static final Unsafe UNSAFE;
    private static final long HEAD_OFF;
    private static final long NODE_ITEM_OFF;
    private static final long NODE_NEXT_OFF;
    private static final long PUT_LOCK_OFF;
    private static final long TAKE_LOCK_OFF;

    private LBQSpliterator(LinkedBlockingQueue<E> queue) {
        this.queue = queue;
        this.est = queue.size();
        this.putLock = LBQSpliterator.getPutLock(queue);
        this.takeLock = LBQSpliterator.getTakeLock(queue);
    }

    static <T> Spliterator<T> spliterator(LinkedBlockingQueue<T> queue) {
        return new LBQSpliterator<T>(queue);
    }

    @Override
    public int characteristics() {
        return 4368;
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        LinkedBlockingQueue<E> q = this.queue;
        if (!this.exhausted) {
            this.exhausted = true;
            Object p = this.current;
            do {
                Object e = null;
                this.fullyLock();
                try {
                    if (p == null) {
                        p = LBQSpliterator.getHeadNext(q);
                    }
                    while (p != null) {
                        e = LBQSpliterator.getNodeItem(p);
                        p = LBQSpliterator.getNextNode(p);
                        if (e == null) continue;
                        break;
                    }
                }
                finally {
                    this.fullyUnlock();
                }
                if (e == null) continue;
                action.accept(e);
            } while (p != null);
        }
    }

    @Override
    public Comparator<? super E> getComparator() {
        return Spliterators.getComparator(this);
    }

    @Override
    public long getExactSizeIfKnown() {
        return Spliterators.getExactSizeIfKnown(this);
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return Spliterators.hasCharacteristics(this, characteristics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        LinkedBlockingQueue<E> q = this.queue;
        if (!this.exhausted) {
            Object e = null;
            this.fullyLock();
            try {
                if (this.current == null) {
                    this.current = LBQSpliterator.getHeadNext(q);
                }
                while (this.current != null) {
                    e = LBQSpliterator.getNodeItem(this.current);
                    this.current = LBQSpliterator.getNextNode(this.current);
                    if (e == null) continue;
                    break;
                }
            }
            finally {
                this.fullyUnlock();
            }
            if (this.current == null) {
                this.exhausted = true;
            }
            if (e != null) {
                action.accept(e);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<E> trySplit() {
        Object h;
        int n;
        LinkedBlockingQueue<E> q = this.queue;
        int b = this.batch;
        int n2 = b <= 0 ? 1 : (n = b >= 0x2000000 ? 0x2000000 : b + 1);
        if (!(this.exhausted || (h = this.current) == null && (h = LBQSpliterator.getHeadNext(q)) == null || LBQSpliterator.getNextNode(h) == null)) {
            Object[] a = new Object[n];
            int i = 0;
            Object p = this.current;
            this.fullyLock();
            try {
                if (p != null || (p = LBQSpliterator.getHeadNext(q)) != null) {
                    do {
                        if ((a[i] = LBQSpliterator.getNodeItem(p)) == null) continue;
                        ++i;
                    } while ((p = LBQSpliterator.getNextNode(p)) != null && i < n);
                }
            }
            finally {
                this.fullyUnlock();
            }
            this.current = p;
            if (this.current == null) {
                this.est = 0L;
                this.exhausted = true;
            } else if ((this.est -= (long)i) < 0L) {
                this.est = 0L;
            }
            if (i > 0) {
                this.batch = i;
                return Spliterators.spliterator(a, 0, i, 4368);
            }
        }
        return null;
    }

    private void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    private void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    private static ReentrantLock getPutLock(LinkedBlockingQueue<?> queue) {
        return (ReentrantLock)UNSAFE.getObject(queue, PUT_LOCK_OFF);
    }

    private static ReentrantLock getTakeLock(LinkedBlockingQueue<?> queue) {
        return (ReentrantLock)UNSAFE.getObject(queue, TAKE_LOCK_OFF);
    }

    private static <T> Object getHeadNext(LinkedBlockingQueue<T> queue) {
        return LBQSpliterator.getNextNode(UNSAFE.getObject(queue, HEAD_OFF));
    }

    private static Object getNextNode(Object node) {
        return UNSAFE.getObject(node, NODE_NEXT_OFF);
    }

    private static <T> T getNodeItem(Object node) {
        return (T)UNSAFE.getObject(node, NODE_ITEM_OFF);
    }

    static {
        try {
            UNSAFE = UnsafeAccess.unsafe;
            Class<LinkedBlockingQueue> lbqc = LinkedBlockingQueue.class;
            Class<?> nc = Class.forName("java.util.concurrent.LinkedBlockingQueue$Node");
            HEAD_OFF = UNSAFE.objectFieldOffset(lbqc.getDeclaredField("head"));
            NODE_ITEM_OFF = UNSAFE.objectFieldOffset(nc.getDeclaredField("item"));
            NODE_NEXT_OFF = UNSAFE.objectFieldOffset(nc.getDeclaredField("next"));
            PUT_LOCK_OFF = UNSAFE.objectFieldOffset(lbqc.getDeclaredField("putLock"));
            TAKE_LOCK_OFF = UNSAFE.objectFieldOffset(lbqc.getDeclaredField("takeLock"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

