/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java8.util.Maps$$Lambda$1;
import java8.util.Maps$Entry$$Lambda$1;
import java8.util.Maps$Entry$$Lambda$2;
import java8.util.Maps$Entry$$Lambda$3;
import java8.util.Maps$Entry$$Lambda$4;
import java8.util.Objects;
import java8.util.function.BiConsumer;
import java8.util.function.BiFunction;
import java8.util.function.Function;

public final class Maps {
    public static <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        Objects.requireNonNull(map);
        V v = map.get(key);
        if (v == null) {
            v = map.put(key, value);
        }
        return v;
    }

    public static <K, V> V mergeConcurrent(ConcurrentMap<K, V> map, K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        Object oldValue = map.get(key);
        while (true) {
            if (oldValue != null) {
                V newValue = remappingFunction.apply(oldValue, value);
                if (newValue != null) {
                    if (map.replace(key, oldValue, newValue)) {
                        return newValue;
                    }
                } else if (map.remove(key, oldValue)) {
                    return null;
                }
                oldValue = map.get(key);
                continue;
            }
            oldValue = map.putIfAbsent(key, value);
            if (oldValue == null) break;
        }
        return value;
    }

    public static <K, V> V computeIfAbsentConcurrent(ConcurrentMap<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(map);
        Objects.requireNonNull(mappingFunction);
        Object v = map.get(key);
        return v == null && (newValue = mappingFunction.apply(key)) != null && (v = map.putIfAbsent(key, newValue)) == null ? newValue : v;
    }

    public static <K, V> void replaceAllConcurrent(ConcurrentMap<K, V> map, BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(function);
        Maps.forEachConcurrent(map, Maps$$Lambda$1.lambdaFactory$(map, function));
    }

    public static <K, V> V getOrDefaultConcurrent(ConcurrentMap<K, V> map, Object key, V defaultValue) {
        Objects.requireNonNull(map);
        Object v = map.get(key);
        return v != null ? v : defaultValue;
    }

    public static <K, V> V getOrDefault(Map<K, V> map, Object key, V defaultValue) {
        Objects.requireNonNull(map);
        V v = map.get(key);
        return v != null || map.containsKey(key) ? v : defaultValue;
    }

    public static <K, V> void forEachConcurrent(ConcurrentMap<K, V> map, BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(action);
        for (Map.Entry entry : map.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            action.accept(k, v);
        }
    }

    public static <K, V> void forEach(Map<K, V> map, BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(action);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            action.accept(k, v);
        }
    }

    public static <K, V> V merge(Map<K, V> map, K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Objects.requireNonNull(map);
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        V oldValue = map.get(key);
        V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        if (newValue == null) {
            map.remove(key);
        } else {
            map.put(key, newValue);
        }
        return newValue;
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(map);
        Objects.requireNonNull(mappingFunction);
        V v = map.get(key);
        if (v == null && (newValue = mappingFunction.apply(key)) != null) {
            map.put(key, newValue);
            return newValue;
        }
        return v;
    }

    public static <K, V> boolean replace(Map<K, V> map, K key, V oldValue, V newValue) {
        Objects.requireNonNull(map);
        V curValue = map.get(key);
        if (!Objects.equals(curValue, oldValue) || curValue == null && !map.containsKey(key)) {
            return false;
        }
        map.put(key, newValue);
        return true;
    }

    public static <K, V> V replace(Map<K, V> map, K key, V value) {
        Objects.requireNonNull(map);
        V curValue = map.get(key);
        if (curValue != null || map.containsKey(key)) {
            curValue = map.put(key, value);
        }
        return curValue;
    }

    public static <K, V> void replaceAll(Map<K, V> map, BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(function);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                ConcurrentModificationException cmex = new ConcurrentModificationException();
                cmex.initCause(ise);
                throw cmex;
            }
            v = function.apply(k, v);
            try {
                entry.setValue(v);
            }
            catch (IllegalStateException ise) {
                ConcurrentModificationException cmex = new ConcurrentModificationException();
                cmex.initCause(ise);
                throw cmex;
            }
        }
    }

    public static <K, V> V compute(Map<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(remappingFunction);
        V oldValue = map.get(key);
        V newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            if (oldValue != null || map.containsKey(key)) {
                map.remove(key);
                return null;
            }
            return null;
        }
        map.put(key, newValue);
        return newValue;
    }

    public static <K, V> V computeIfPresent(Map<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(remappingFunction);
        V oldValue = map.get(key);
        if (oldValue != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                map.put(key, newValue);
                return newValue;
            }
            map.remove(key);
            return null;
        }
        return null;
    }

    public static <K, V> boolean remove(Map<K, V> map, Object key, Object value) {
        Objects.requireNonNull(map);
        V curValue = map.get(key);
        if (!Objects.equals(curValue, value) || curValue == null && !map.containsKey(key)) {
            return false;
        }
        map.remove(key);
        return true;
    }

    private Maps() {
    }

    private static /* synthetic */ void lambda$replaceAllConcurrent$158(ConcurrentMap concurrentMap, BiFunction biFunction, Object k, Object v) {
        while (!concurrentMap.replace(k, v, biFunction.apply(k, v)) && (v = concurrentMap.get(k)) != null) {
        }
    }

    static /* synthetic */ void access$lambda$0(ConcurrentMap concurrentMap, BiFunction biFunction, Object object, Object object2) {
        Maps.lambda$replaceAllConcurrent$158(concurrentMap, biFunction, object, object2);
    }

    public static final class Entry {
        public static <K extends Comparable<? super K>, V> Comparator<Map.Entry<K, V>> comparingByKey() {
            return (Comparator)((Object)((Serializable)((Object)Maps$Entry$$Lambda$1.lambdaFactory$())));
        }

        public static <K, V extends Comparable<? super V>> Comparator<Map.Entry<K, V>> comparingByValue() {
            return (Comparator)((Object)((Serializable)((Object)Maps$Entry$$Lambda$2.lambdaFactory$())));
        }

        public static <K, V> Comparator<Map.Entry<K, V>> comparingByKey(Comparator<? super K> cmp) {
            Objects.requireNonNull(cmp);
            return (Comparator)((Object)((Serializable)((Object)Maps$Entry$$Lambda$3.lambdaFactory$(cmp))));
        }

        public static <K, V> Comparator<Map.Entry<K, V>> comparingByValue(Comparator<? super V> cmp) {
            Objects.requireNonNull(cmp);
            return (Comparator)((Object)((Serializable)((Object)Maps$Entry$$Lambda$4.lambdaFactory$(cmp))));
        }

        private Entry() {
        }

        private static /* synthetic */ int lambda$comparingByValue$1065357e$1(Map.Entry c1, Map.Entry c2) {
            return ((Comparable)c1.getValue()).compareTo(c2.getValue());
        }

        private static /* synthetic */ int lambda$comparingByKey$bbdbfea9$1(Map.Entry c1, Map.Entry c2) {
            return ((Comparable)c1.getKey()).compareTo(c2.getKey());
        }

        static /* synthetic */ int access$lambda$0(Map.Entry entry, Map.Entry entry2) {
            return Entry.lambda$comparingByKey$bbdbfea9$1(entry, entry2);
        }

        static /* synthetic */ int access$lambda$1(Map.Entry entry, Map.Entry entry2) {
            return Entry.lambda$comparingByValue$1065357e$1(entry, entry2);
        }

        static /* synthetic */ int access$lambda$2(Comparator comparator, Map.Entry entry, Map.Entry entry2) {
            return comparator.compare(entry.getKey(), entry2.getKey());
        }

        static /* synthetic */ int access$lambda$3(Comparator comparator, Map.Entry entry, Map.Entry entry2) {
            return comparator.compare(entry.getValue(), entry2.getValue());
        }
    }
}

