/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.NoSuchElementException;
import java8.lang.Doubles;
import java8.util.function.DoubleConsumer;
import java8.util.function.DoubleSupplier;
import java8.util.function.Supplier;
import java8.util.stream.DoubleStream;
import java8.util.stream.DoubleStreams;

public final class OptionalDouble {
    private static final OptionalDouble EMPTY = new OptionalDouble();
    private final boolean isPresent;
    private final double value;

    private OptionalDouble() {
        this.isPresent = false;
        this.value = Double.NaN;
    }

    public static OptionalDouble empty() {
        return EMPTY;
    }

    private OptionalDouble(double value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalDouble of(double value) {
        return new OptionalDouble(value);
    }

    public double getAsDouble() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(DoubleConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(DoubleConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public DoubleStream stream() {
        if (this.isPresent) {
            return DoubleStreams.of(this.value);
        }
        return DoubleStreams.empty();
    }

    public double orElse(double other) {
        return this.isPresent ? this.value : other;
    }

    public double orElseGet(DoubleSupplier other) {
        return this.isPresent ? this.value : other.getAsDouble();
    }

    public <X extends Throwable> double orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalDouble)) {
            return false;
        }
        OptionalDouble other = (OptionalDouble)obj;
        return this.isPresent && other.isPresent ? Double.compare(this.value, other.value) == 0 : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? Doubles.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalDouble[%s]", this.value) : "OptionalDouble.empty";
    }
}

