/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.PriorityQueue;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.UnsafeAccess;
import java8.util.function.Consumer;
import sun.misc.Unsafe;

final class PriorityQueueSpliterator<E>
implements Spliterator<E> {
    private final PriorityQueue<E> pq;
    private int index;
    private int fence;
    private int expectedModCount;
    private static final Unsafe UNSAFE;
    private static final long SIZE_OFF;
    private static final long MODCOUNT_OFF;
    private static final long QUEUE_OFF;
    private static final boolean IS_ANDROID;

    private PriorityQueueSpliterator(PriorityQueue<E> pq, int origin, int fence, int expectedModCount) {
        this.pq = pq;
        this.index = origin;
        this.fence = fence;
        this.expectedModCount = expectedModCount;
    }

    static <T> Spliterator<T> spliterator(PriorityQueue<T> pq) {
        return new PriorityQueueSpliterator<T>(pq, 0, -1, 0);
    }

    private int getFence() {
        int hi = this.fence;
        if (hi < 0) {
            this.expectedModCount = PriorityQueueSpliterator.getModCount(this.pq);
            hi = this.fence = PriorityQueueSpliterator.getSize(this.pq);
        }
        return hi;
    }

    @Override
    public PriorityQueueSpliterator<E> trySplit() {
        PriorityQueueSpliterator<E> priorityQueueSpliterator;
        int lo = this.index;
        int hi = this.getFence();
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            priorityQueueSpliterator = null;
        } else {
            this.index = mid;
            PriorityQueueSpliterator<E> priorityQueueSpliterator2 = new PriorityQueueSpliterator<E>(this.pq, lo, this.index, this.expectedModCount);
            priorityQueueSpliterator = priorityQueueSpliterator2;
        }
        return priorityQueueSpliterator;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Object[] a;
        Objects.requireNonNull(action);
        PriorityQueue<E> q = this.pq;
        if (q != null && (a = PriorityQueueSpliterator.getQueue(q)) != null) {
            int mc;
            int hi = this.fence;
            if (hi < 0) {
                mc = PriorityQueueSpliterator.getModCount(q);
                hi = PriorityQueueSpliterator.getSize(q);
            } else {
                mc = this.expectedModCount;
            }
            int i = this.index;
            if (i >= 0 && (this.index = hi) <= a.length) {
                while (true) {
                    Object e;
                    if (i < hi) {
                        e = a[i];
                        if (e == null) break;
                    } else {
                        if (mc != PriorityQueueSpliterator.getModCount(q)) break;
                        return;
                    }
                    action.accept(e);
                    ++i;
                }
            }
        }
        throw new ConcurrentModificationException();
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int hi = this.getFence();
        int lo = this.index;
        if (lo >= 0 && lo < hi) {
            this.index = lo + 1;
            Object e = PriorityQueueSpliterator.getQueue(this.pq)[lo];
            if (e == null) {
                throw new ConcurrentModificationException();
            }
            action.accept(e);
            if (this.expectedModCount != PriorityQueueSpliterator.getModCount(this.pq)) {
                throw new ConcurrentModificationException();
            }
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.getFence() - this.index;
    }

    @Override
    public int characteristics() {
        return 16704;
    }

    @Override
    public Comparator<? super E> getComparator() {
        return Spliterators.getComparator(this);
    }

    @Override
    public long getExactSizeIfKnown() {
        return Spliterators.getExactSizeIfKnown(this);
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return Spliterators.hasCharacteristics(this, characteristics);
    }

    private static <T> int getSize(PriorityQueue<T> pq) {
        return UNSAFE.getInt(pq, SIZE_OFF);
    }

    private static <T> int getModCount(PriorityQueue<T> pq) {
        if (IS_ANDROID) {
            return 0;
        }
        return UNSAFE.getInt(pq, MODCOUNT_OFF);
    }

    private static <T> Object[] getQueue(PriorityQueue<T> pq) {
        return (Object[])UNSAFE.getObject(pq, QUEUE_OFF);
    }

    static {
        try {
            IS_ANDROID = Spliterators.IS_ANDROID;
            UNSAFE = UnsafeAccess.unsafe;
            Class<PriorityQueue> pq = PriorityQueue.class;
            SIZE_OFF = UNSAFE.objectFieldOffset(pq.getDeclaredField("size"));
            MODCOUNT_OFF = !IS_ANDROID ? UNSAFE.objectFieldOffset(pq.getDeclaredField("modCount")) : 0L;
            String queueFieldName = IS_ANDROID ? "elements" : "queue";
            QUEUE_OFF = UNSAFE.objectFieldOffset(pq.getDeclaredField(queueFieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

