/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.AbstractList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Vector;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.UnsafeAccess;
import java8.util.function.Consumer;
import sun.misc.Unsafe;

final class VectorSpliterator<E>
implements Spliterator<E> {
    private final Vector<E> list;
    private Object[] array;
    private int index;
    private int fence;
    private int expectedModCount;
    private static final Unsafe UNSAFE;
    private static final long SIZE_OFF;
    private static final long MODCOUNT_OFF;
    private static final long DATA_OFF;

    private VectorSpliterator(Vector<E> list, Object[] array, int origin, int fence, int expectedModCount) {
        this.list = list;
        this.array = array;
        this.index = origin;
        this.fence = fence;
        this.expectedModCount = expectedModCount;
    }

    static <T> Spliterator<T> spliterator(Vector<T> vec) {
        return new VectorSpliterator<T>(vec, null, 0, -1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFence() {
        int hi = this.fence;
        if (hi < 0) {
            Vector<E> vector = this.list;
            synchronized (vector) {
                this.array = VectorSpliterator.getData(this.list);
                this.expectedModCount = VectorSpliterator.getModCount(this.list);
                hi = this.fence = VectorSpliterator.getSize(this.list);
            }
        }
        return hi;
    }

    @Override
    public Spliterator<E> trySplit() {
        VectorSpliterator<E> vectorSpliterator;
        int lo = this.index;
        int hi = this.getFence();
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            vectorSpliterator = null;
        } else {
            this.index = mid;
            VectorSpliterator<E> vectorSpliterator2 = new VectorSpliterator<E>(this.list, this.array, lo, this.index, this.expectedModCount);
            vectorSpliterator = vectorSpliterator2;
        }
        return vectorSpliterator;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int i = this.index;
        if (this.getFence() > i) {
            this.index = i + 1;
            action.accept(this.array[i]);
            if (this.expectedModCount != VectorSpliterator.getModCount(this.list)) {
                throw new ConcurrentModificationException();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        Vector<E> lst = this.list;
        if (lst != null) {
            int i;
            Object[] a;
            int hi = this.fence;
            if (hi < 0) {
                Vector<E> vector = lst;
                synchronized (vector) {
                    this.expectedModCount = VectorSpliterator.getModCount(lst);
                    a = this.array = VectorSpliterator.getData(lst);
                    hi = this.fence = VectorSpliterator.getSize(lst);
                }
            } else {
                a = this.array;
            }
            if (a != null && (i = this.index) >= 0 && (this.index = hi) <= a.length) {
                while (i < hi) {
                    action.accept(a[i++]);
                }
                if (this.expectedModCount == VectorSpliterator.getModCount(lst)) {
                    return;
                }
            }
        }
        throw new ConcurrentModificationException();
    }

    @Override
    public long estimateSize() {
        return this.getFence() - this.index;
    }

    @Override
    public int characteristics() {
        return 16464;
    }

    @Override
    public Comparator<? super E> getComparator() {
        return Spliterators.getComparator(this);
    }

    @Override
    public long getExactSizeIfKnown() {
        return Spliterators.getExactSizeIfKnown(this);
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return Spliterators.hasCharacteristics(this, characteristics);
    }

    private static <T> int getSize(Vector<T> lst) {
        return UNSAFE.getInt(lst, SIZE_OFF);
    }

    private static <T> int getModCount(Vector<T> lst) {
        return UNSAFE.getInt(lst, MODCOUNT_OFF);
    }

    private static <T> Object[] getData(Vector<T> lst) {
        return (Object[])UNSAFE.getObject(lst, DATA_OFF);
    }

    static {
        try {
            UNSAFE = UnsafeAccess.unsafe;
            MODCOUNT_OFF = UNSAFE.objectFieldOffset(AbstractList.class.getDeclaredField("modCount"));
            Class<Vector> vc = Vector.class;
            SIZE_OFF = UNSAFE.objectFieldOffset(vc.getDeclaredField("elementCount"));
            DATA_OFF = UNSAFE.objectFieldOffset(vc.getDeclaredField("elementData"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

