/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Comparator;
import java.util.Random;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.concurrent.TLRandom;
import java8.util.function.Consumer;
import java8.util.function.DoubleConsumer;
import java8.util.function.IntConsumer;
import java8.util.function.LongConsumer;
import java8.util.stream.DoubleStream;
import java8.util.stream.IntStream;
import java8.util.stream.LongStream;
import java8.util.stream.StreamSupport;

public class ThreadLocalRandom
extends Random {
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private static final ThreadLocal<Double> nextLocalGaussian = new ThreadLocal();
    private boolean initialized = true;
    private static final ThreadLocalRandom instance = new ThreadLocalRandom();
    private static final String BadBound = "bound must be positive";
    private static final String BadRange = "bound must be greater than origin";
    private static final String BadSize = "size must be non-negative";
    private static final long serialVersionUID = 9123313859120073139L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rnd", Long.TYPE), new ObjectStreamField("initialized", Boolean.TYPE)};

    private static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    private static int mix32(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        return (int)((z ^ z >>> 33) * -4265267296055464877L >>> 32);
    }

    private ThreadLocalRandom() {
    }

    public static ThreadLocalRandom current() {
        if (TLRandom.getThreadLocalRandomProbe() == 0) {
            TLRandom.localInit();
        }
        return instance;
    }

    @Override
    public void setSeed(long seed) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
    }

    private final long nextSeed() {
        return TLRandom.nextSeed();
    }

    private final long internalNextLong(long origin, long bound) {
        long r = ThreadLocalRandom.mix64(this.nextSeed());
        if (origin < bound) {
            long n = bound - origin;
            long m = n - 1L;
            if ((n & m) == 0L) {
                r = (r & m) + origin;
            } else if (n > 0L) {
                long u = r >>> 1;
                while (u + m - (r = u % n) < 0L) {
                    u = ThreadLocalRandom.mix64(this.nextSeed()) >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = ThreadLocalRandom.mix64(this.nextSeed());
                }
            }
        }
        return r;
    }

    private final int internalNextInt(int origin, int bound) {
        int r = ThreadLocalRandom.mix32(this.nextSeed());
        if (origin < bound) {
            int n = bound - origin;
            int m = n - 1;
            if ((n & m) == 0) {
                r = (r & m) + origin;
            } else if (n > 0) {
                int u = r >>> 1;
                while (u + m - (r = u % n) < 0) {
                    u = ThreadLocalRandom.mix32(this.nextSeed()) >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = ThreadLocalRandom.mix32(this.nextSeed());
                }
            }
        }
        return r;
    }

    private final double internalNextDouble(double origin, double bound) {
        double r = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
        if (origin < bound && (r = r * (bound - origin) + origin) >= bound) {
            r = Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
        }
        return r;
    }

    @Override
    public int nextInt() {
        return ThreadLocalRandom.mix32(this.nextSeed());
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int r = ThreadLocalRandom.mix32(this.nextSeed());
        int m = bound - 1;
        if ((bound & m) == 0) {
            r &= m;
        } else {
            int u = r >>> 1;
            while (u + m - (r = u % bound) < 0) {
                u = ThreadLocalRandom.mix32(this.nextSeed()) >>> 1;
            }
        }
        return r;
    }

    @Override
    public int nextInt(int origin, int bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextInt(origin, bound);
    }

    @Override
    public long nextLong() {
        return ThreadLocalRandom.mix64(this.nextSeed());
    }

    @Override
    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException(BadBound);
        }
        long r = ThreadLocalRandom.mix64(this.nextSeed());
        long m = bound - 1L;
        if ((bound & m) == 0L) {
            r &= m;
        } else {
            long u = r >>> 1;
            while (u + m - (r = u % bound) < 0L) {
                u = ThreadLocalRandom.mix64(this.nextSeed()) >>> 1;
            }
        }
        return r;
    }

    @Override
    public long nextLong(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextLong(origin, bound);
    }

    @Override
    public double nextDouble() {
        return (double)(ThreadLocalRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextDouble(double bound) {
        if (!(bound > 0.0)) {
            throw new IllegalArgumentException(BadBound);
        }
        double result = (double)(ThreadLocalRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f * bound;
        return result < bound ? result : Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
    }

    @Override
    public double nextDouble(double origin, double bound) {
        if (!(origin < bound)) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextDouble(origin, bound);
    }

    @Override
    public boolean nextBoolean() {
        return ThreadLocalRandom.mix32(this.nextSeed()) < 0;
    }

    @Override
    public float nextFloat() {
        return (float)(ThreadLocalRandom.mix32(this.nextSeed()) >>> 8) * 5.9604645E-8f;
    }

    @Override
    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        Double d = nextLocalGaussian.get();
        if (d != null) {
            nextLocalGaussian.set(null);
            return d;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        nextLocalGaussian.set(new Double(v2 * multiplier));
        return v1 * multiplier;
    }

    public IntStream ints(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, streamSize, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints() {
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    public LongStream longs(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, streamSize, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs() {
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    public DoubleStream doubles(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, streamSize, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles() {
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (!(randomNumberOrigin < randomNumberBound)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        if (!(randomNumberOrigin < randomNumberBound)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("rnd", TLRandom.getThreadLocalRandomSeed());
        fields.put("initialized", true);
        s.writeFields();
    }

    private Object readResolve() {
        return ThreadLocalRandom.current();
    }

    private static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(long index, long fence, double origin, double bound) {
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long i = this.index;
            long m = i + this.fence >>> 1;
            if (m <= i) {
                randomDoublesSpliterator = null;
            } else {
                this.index = m;
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(i, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Double> getComparator() {
            return Spliterators.getComparator(this);
        }

        @Override
        public boolean tryAdvance(DoubleConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(ThreadLocalRandom.current().internalNextDouble(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Double> action) {
            return Spliterators.OfDouble.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(DoubleConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                double o = this.origin;
                double b = this.bound;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                do {
                    consumer.accept(rng.internalNextDouble(o, b));
                } while (++i < f);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Double> action) {
            Spliterators.OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
        }
    }

    private static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(long index, long fence, long origin, long bound) {
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long i = this.index;
            long m = i + this.fence >>> 1;
            if (m <= i) {
                randomLongsSpliterator = null;
            } else {
                this.index = m;
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(i, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Long> getComparator() {
            return Spliterators.getComparator(this);
        }

        @Override
        public boolean tryAdvance(LongConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(ThreadLocalRandom.current().internalNextLong(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            return Spliterators.OfLong.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(LongConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                long o = this.origin;
                long b = this.bound;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                do {
                    consumer.accept(rng.internalNextLong(o, b));
                } while (++i < f);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            Spliterators.OfLong.forEachRemaining((Spliterator.OfLong)this, action);
        }
    }

    private static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(long index, long fence, int origin, int bound) {
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long i = this.index;
            long m = i + this.fence >>> 1;
            if (m <= i) {
                randomIntsSpliterator = null;
            } else {
                this.index = m;
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(i, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return Spliterators.getComparator(this);
        }

        @Override
        public boolean tryAdvance(IntConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(ThreadLocalRandom.current().internalNextInt(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Integer> action) {
            return Spliterators.OfInt.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(IntConsumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                int o = this.origin;
                int b = this.bound;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                do {
                    consumer.accept(rng.internalNextInt(o, b));
                } while (++i < f);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> action) {
            Spliterators.OfInt.forEachRemaining((Spliterator.OfInt)this, action);
        }
    }
}

