/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent.atomic;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java8.util.concurrent.atomic.Striped64;
import java8.util.function.DoubleBinaryOperator;

public class DoubleAccumulator
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;
    private final DoubleBinaryOperator function;
    private final long identity;

    public DoubleAccumulator(DoubleBinaryOperator accumulatorFunction, double identity) {
        this.function = accumulatorFunction;
        this.base = this.identity = Double.doubleToRawLongBits(identity);
    }

    public void accumulate(double x) {
        long b;
        long r;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || (r = Double.doubleToRawLongBits(this.function.applyAsDouble(Double.longBitsToDouble(b = this.base), x))) != b && !this.casBase(b, r)) {
            long v;
            Striped64.Cell a;
            int m;
            boolean uncontended = true;
            if (as == null || (m = as.length - 1) < 0 || (a = as[DoubleAccumulator.getProbe() & m]) == null || !(uncontended = (r = Double.doubleToRawLongBits(this.function.applyAsDouble(Double.longBitsToDouble(v = a.value), x))) == v || a.cas(v, r))) {
                this.doubleAccumulate(x, this.function, uncontended);
            }
        }
    }

    public double get() {
        Striped64.Cell[] as = this.cells;
        double result = Double.longBitsToDouble(this.base);
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                Striped64.Cell a = as[i];
                if (a == null) continue;
                result = this.function.applyAsDouble(result, Double.longBitsToDouble(a.value));
            }
        }
        return result;
    }

    public void reset() {
        Striped64.Cell[] as = this.cells;
        this.base = this.identity;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                Striped64.Cell a = as[i];
                if (a == null) continue;
                a.value = this.identity;
            }
        }
    }

    public double getThenReset() {
        Striped64.Cell[] as = this.cells;
        double result = Double.longBitsToDouble(this.base);
        this.base = this.identity;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                Striped64.Cell a = as[i];
                if (a == null) continue;
                double v = Double.longBitsToDouble(a.value);
                a.value = this.identity;
                result = this.function.applyAsDouble(result, v);
            }
        }
        return result;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final double value;
        private final DoubleBinaryOperator function;
        private final long identity;

        SerializationProxy(DoubleAccumulator a) {
            this.function = a.function;
            this.identity = a.identity;
            this.value = a.get();
        }

        private Object readResolve() {
            double d = Double.longBitsToDouble(this.identity);
            DoubleAccumulator a = new DoubleAccumulator(this.function, d);
            a.base = Double.doubleToRawLongBits(this.value);
            return a;
        }
    }
}

