/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent.atomic;

import java.lang.reflect.Method;
import java8.util.concurrent.atomic.UnsafeAccess;
import java8.util.function.DoubleBinaryOperator;
import java8.util.function.LongBinaryOperator;
import sun.misc.Unsafe;

abstract class Striped64
extends Number {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Cell[] cells;
    volatile transient long base;
    volatile transient int cellsBusy;
    private static final Unsafe UNSAFE;
    private static final long BASE;
    private static final long CELLSBUSY;
    private static final Method GET_PROBE_METHOD;
    private static final Method GET_INIT_PROBE_METHOD;
    private static final Method SET_PROBE_METHOD;

    Striped64() {
    }

    final boolean casBase(long cmp, long val) {
        return UNSAFE.compareAndSwapLong(this, BASE, cmp, val);
    }

    final boolean casCellsBusy() {
        return UNSAFE.compareAndSwapInt(this, CELLSBUSY, 0, 1);
    }

    static final int getProbe() {
        try {
            return (Integer)GET_PROBE_METHOD.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static final int getInitializedProbe(Integer uncontended) {
        try {
            return (Integer)GET_INIT_PROBE_METHOD.invoke(null, uncontended);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static void setProbe(int probe) {
        try {
            SET_PROBE_METHOD.invoke(null, probe);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        Striped64.setProbe(probe);
        return probe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void longAccumulate(long x, LongBinaryOperator fn, boolean wasUncontended) {
        Integer uncontended = new Integer(0);
        int h = Striped64.getInitializedProbe(uncontended);
        if (uncontended == 1) {
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            Cell[] as = this.cells;
            if (this.cells != null && (n = as.length) > 0) {
                Cell a = as[n - 1 & h];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        Cell r = new Cell(x);
                        if (this.cellsBusy == 0 && this.casCellsBusy()) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                Cell[] rs = this.cells;
                                if (this.cells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (a.cas(v, fn == null ? v + x : fn.applyAsLong(v, x))) return;
                    if (n >= NCPU || this.cells != as) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && this.casCellsBusy()) {
                        try {
                            if (this.cells == as) {
                                Cell[] rs = new Cell[n << 1];
                                for (int i = 0; i < n; ++i) {
                                    rs[i] = as[i];
                                }
                                this.cells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h = Striped64.advanceProbe(h);
                continue;
            }
            if (this.cellsBusy == 0 && this.cells == as && this.casCellsBusy()) {
                boolean init = false;
                try {
                    if (this.cells == as) {
                        Cell[] rs = new Cell[2];
                        rs[h & 1] = new Cell(x);
                        this.cells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v = this.base;
            if (this.casBase(v, fn == null ? v + x : fn.applyAsLong(v, x))) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void doubleAccumulate(double x, DoubleBinaryOperator fn, boolean wasUncontended) {
        Integer uncontended = new Integer(0);
        int h = Striped64.getInitializedProbe(uncontended);
        if (uncontended == 1) {
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            Cell[] as = this.cells;
            if (this.cells != null && (n = as.length) > 0) {
                Cell a = as[n - 1 & h];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        Cell r = new Cell(Double.doubleToRawLongBits(x));
                        if (this.cellsBusy == 0 && this.casCellsBusy()) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                Cell[] rs = this.cells;
                                if (this.cells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (a.cas(v, fn == null ? Double.doubleToRawLongBits(Double.longBitsToDouble(v) + x) : Double.doubleToRawLongBits(fn.applyAsDouble(Double.longBitsToDouble(v), x)))) return;
                    if (n >= NCPU || this.cells != as) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && this.casCellsBusy()) {
                        try {
                            if (this.cells == as) {
                                Cell[] rs = new Cell[n << 1];
                                for (int i = 0; i < n; ++i) {
                                    rs[i] = as[i];
                                }
                                this.cells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h = Striped64.advanceProbe(h);
                continue;
            }
            if (this.cellsBusy == 0 && this.cells == as && this.casCellsBusy()) {
                boolean init = false;
                try {
                    if (this.cells == as) {
                        Cell[] rs = new Cell[2];
                        rs[h & 1] = new Cell(Double.doubleToRawLongBits(x));
                        this.cells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v = this.base;
            if (this.casBase(v, fn == null ? Double.doubleToRawLongBits(Double.longBitsToDouble(v) + x) : Double.doubleToRawLongBits(fn.applyAsDouble(Double.longBitsToDouble(v), x)))) return;
        }
    }

    static {
        try {
            UNSAFE = UnsafeAccess.unsafe;
            Class<Striped64> sk = Striped64.class;
            BASE = UNSAFE.objectFieldOffset(sk.getDeclaredField("base"));
            CELLSBUSY = UNSAFE.objectFieldOffset(sk.getDeclaredField("cellsBusy"));
            Class<?> tlrk = Class.forName("java8.util.concurrent.TLRandom");
            Method getProbe = tlrk.getDeclaredMethod("getThreadLocalRandomProbe", new Class[0]);
            getProbe.setAccessible(true);
            Method getInitProbe = tlrk.getDeclaredMethod("getInitializedProbe", Integer.class);
            getInitProbe.setAccessible(true);
            Method setProbe = tlrk.getDeclaredMethod("setThreadLocalRandomProbe", Integer.TYPE);
            setProbe.setAccessible(true);
            GET_PROBE_METHOD = getProbe;
            GET_INIT_PROBE_METHOD = getInitProbe;
            SET_PROBE_METHOD = setProbe;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class Cell {
        volatile long value;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;

        Cell(long x) {
            this.value = x;
        }

        final boolean cas(long cmp, long val) {
            return UNSAFE.compareAndSwapLong(this, valueOffset, cmp, val);
        }

        static {
            try {
                UNSAFE = UnsafeAccess.unsafe;
                Class<Cell> ak = Cell.class;
                valueOffset = UNSAFE.objectFieldOffset(ak.getDeclaredField("value"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

