/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.function.IntFunction;
import java8.util.stream.AbstractPipeline;
import java8.util.stream.DistinctOps$1$$Lambda$1;
import java8.util.stream.DistinctOps$1$$Lambda$2;
import java8.util.stream.DistinctOps$1$$Lambda$3;
import java8.util.stream.DistinctOps$1$$Lambda$4;
import java8.util.stream.ForEachOps;
import java8.util.stream.Node;
import java8.util.stream.Nodes;
import java8.util.stream.PipelineHelper;
import java8.util.stream.ReduceOps;
import java8.util.stream.ReferencePipeline;
import java8.util.stream.Sink;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamShape;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.TerminalOp;

final class DistinctOps {
    private DistinctOps() {
    }

    static <T> ReferencePipeline<T, T> makeRef(AbstractPipeline<?, T, ?> upstream) {
        return new ReferencePipeline.StatefulOp<T, T>(upstream, StreamShape.REFERENCE, StreamOpFlag.IS_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            <P_IN> Node<T> reduce(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                TerminalOp reduceOp = ReduceOps.makeRef(DistinctOps$1$$Lambda$1.lambdaFactory$(), DistinctOps$1$$Lambda$2.lambdaFactory$(), DistinctOps$1$$Lambda$3.lambdaFactory$());
                return Nodes.node((Collection)reduceOp.evaluateParallel(helper, spliterator));
            }

            @Override
            <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator, IntFunction<T[]> generator) {
                if (StreamOpFlag.DISTINCT.isKnown(helper.getStreamAndOpFlags())) {
                    return helper.evaluate(spliterator, false, generator);
                }
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.reduce(helper, spliterator);
                }
                AtomicBoolean seenNull = new AtomicBoolean(false);
                ConcurrentHashMap map = new ConcurrentHashMap();
                TerminalOp forEachOp = ForEachOps.makeRef(DistinctOps$1$$Lambda$4.lambdaFactory$(seenNull, map), false);
                forEachOp.evaluateParallel(helper, spliterator);
                Set keys = map.keySet();
                if (seenNull.get()) {
                    keys = new HashSet(keys);
                    keys.add(null);
                }
                return Nodes.node(keys);
            }

            @Override
            <P_IN> Spliterator<T> opEvaluateParallelLazy(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.DISTINCT.isKnown(helper.getStreamAndOpFlags())) {
                    return helper.wrapSpliterator(spliterator);
                }
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.reduce(helper, spliterator).spliterator();
                }
                return new StreamSpliterators.DistinctSpliterator(helper.wrapSpliterator(spliterator));
            }

            @Override
            Sink<T> opWrapSink(int flags, Sink<T> sink) {
                Objects.requireNonNull(sink);
                if (StreamOpFlag.DISTINCT.isKnown(flags)) {
                    return sink;
                }
                if (StreamOpFlag.SORTED.isKnown(flags)) {
                    return new Sink.ChainedReference<T, T>(sink){
                        boolean seenNull;
                        T lastSeen;

                        @Override
                        public void begin(long size) {
                            this.seenNull = false;
                            this.lastSeen = null;
                            this.downstream.begin(-1L);
                        }

                        @Override
                        public void end() {
                            this.seenNull = false;
                            this.lastSeen = null;
                            this.downstream.end();
                        }

                        @Override
                        public void accept(T t) {
                            if (t == null) {
                                if (!this.seenNull) {
                                    this.seenNull = true;
                                    this.lastSeen = null;
                                    this.downstream.accept(null);
                                }
                            } else if (this.lastSeen == null || !t.equals(this.lastSeen)) {
                                this.lastSeen = t;
                                this.downstream.accept(this.lastSeen);
                            }
                        }
                    };
                }
                return new Sink.ChainedReference<T, T>(sink){
                    Set<T> seen;

                    @Override
                    public void begin(long size) {
                        this.seen = new HashSet();
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void end() {
                        this.seen = null;
                        this.downstream.end();
                    }

                    @Override
                    public void accept(T t) {
                        if (!this.seen.contains(t)) {
                            this.seen.add(t);
                            this.downstream.accept(t);
                        }
                    }
                };
            }

            private static /* synthetic */ void lambda$opEvaluateParallel$49(AtomicBoolean atomicBoolean, ConcurrentMap concurrentMap, Object t) {
                if (t == null) {
                    atomicBoolean.set(true);
                } else {
                    concurrentMap.putIfAbsent(t, Boolean.TRUE);
                }
            }

            static /* synthetic */ void access$lambda$0(AtomicBoolean atomicBoolean, ConcurrentMap concurrentMap, Object object) {
                1.lambda$opEvaluateParallel$49(atomicBoolean, concurrentMap, object);
            }
        };
    }
}

