/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.Iterators;
import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.PrimitiveIterator;
import java8.util.Spliterators;
import java8.util.function.DoubleConsumer;
import java8.util.function.DoublePredicate;
import java8.util.function.DoubleSupplier;
import java8.util.function.DoubleUnaryOperator;
import java8.util.stream.DoubleStream;
import java8.util.stream.DoubleStreams$$Lambda$1;
import java8.util.stream.DoubleStreams$$Lambda$2;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;
import java8.util.stream.WhileOps;

public final class DoubleStreams {
    public static DoubleStream takeWhile(DoubleStream stream, DoublePredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        DoubleStream doubleStream = StreamSupport.doubleStream(new WhileOps.UnorderedWhileSpliterator.OfDouble.Taking(stream.spliterator(), true, predicate), stream.isParallel());
        DoubleStream doubleStream2 = stream;
        doubleStream2.getClass();
        return (DoubleStream)doubleStream.onClose(DoubleStreams$$Lambda$1.lambdaFactory$(doubleStream2));
    }

    public static DoubleStream dropWhile(DoubleStream stream, DoublePredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        DoubleStream doubleStream = StreamSupport.doubleStream(new WhileOps.UnorderedWhileSpliterator.OfDouble.Dropping(stream.spliterator(), true, predicate), stream.isParallel());
        DoubleStream doubleStream2 = stream;
        doubleStream2.getClass();
        return (DoubleStream)doubleStream.onClose(DoubleStreams$$Lambda$2.lambdaFactory$(doubleStream2));
    }

    public static DoubleStream.Builder builder() {
        return new Streams.DoubleStreamBuilderImpl();
    }

    public static DoubleStream empty() {
        return StreamSupport.doubleStream(Spliterators.emptyDoubleSpliterator(), false);
    }

    public static DoubleStream of(double t) {
        return StreamSupport.doubleStream(new Streams.DoubleStreamBuilderImpl(t), false);
    }

    public static DoubleStream of(double ... values) {
        return J8Arrays.stream(values);
    }

    public static DoubleStream iterate(final double seed, final DoubleUnaryOperator f) {
        Objects.requireNonNull(f);
        PrimitiveIterator.OfDouble iterator = new PrimitiveIterator.OfDouble(){
            double t;
            {
                this.t = seed;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public double nextDouble() {
                double v = this.t;
                this.t = f.applyAsDouble(this.t);
                return v;
            }

            @Override
            public Double next() {
                return this.nextDouble();
            }

            @Override
            public void forEachRemaining(DoubleConsumer action) {
                Iterators.forEachRemaining(this, action);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return StreamSupport.doubleStream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static DoubleStream generate(DoubleSupplier s) {
        Objects.requireNonNull(s);
        return StreamSupport.doubleStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfDouble(Long.MAX_VALUE, s), false);
    }

    public static DoubleStream concat(DoubleStream a, DoubleStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfDouble split = new Streams.ConcatSpliterator.OfDouble(a.spliterator(), b.spliterator());
        DoubleStream stream = StreamSupport.doubleStream(split, a.isParallel() || b.isParallel());
        return (DoubleStream)stream.onClose(Streams.composedClose(a, b));
    }

    private DoubleStreams() {
    }

    public static final class J8Builder {
        public static DoubleStream.Builder add(DoubleStream.Builder this_, double t) {
            this_.accept(t);
            return this_;
        }

        private J8Builder() {
        }
    }
}

