/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.Objects;
import java8.util.function.DoubleConsumer;
import java8.util.function.IntConsumer;
import java8.util.function.LongConsumer;
import java8.util.stream.SinkConsumer;
import java8.util.stream.SinkDefaults;

interface Sink<T>
extends SinkConsumer<T> {
    public void begin(long var1);

    public void end();

    public boolean cancellationRequested();

    @Override
    public void accept(int var1);

    @Override
    public void accept(long var1);

    @Override
    public void accept(double var1);

    public static abstract class ChainedDouble<E_OUT>
    implements OfDouble {
        protected final Sink<? super E_OUT> downstream;

        public ChainedDouble(Sink<? super E_OUT> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void begin(long size) {
            this.downstream.begin(size);
        }

        @Override
        public void end() {
            this.downstream.end();
        }

        @Override
        public boolean cancellationRequested() {
            return this.downstream.cancellationRequested();
        }

        @Override
        public void accept(int value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(long value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(Double i) {
            SinkDefaults.OfDouble.accept(this, i);
        }
    }

    public static abstract class ChainedLong<E_OUT>
    implements OfLong {
        protected final Sink<? super E_OUT> downstream;

        public ChainedLong(Sink<? super E_OUT> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void begin(long size) {
            this.downstream.begin(size);
        }

        @Override
        public void end() {
            this.downstream.end();
        }

        @Override
        public boolean cancellationRequested() {
            return this.downstream.cancellationRequested();
        }

        @Override
        public void accept(int value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(Long i) {
            SinkDefaults.OfLong.accept(this, i);
        }

        @Override
        public void accept(double value) {
            SinkDefaults.accept(this, value);
        }
    }

    public static abstract class ChainedInt<E_OUT>
    implements OfInt {
        protected final Sink<? super E_OUT> downstream;

        public ChainedInt(Sink<? super E_OUT> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void begin(long size) {
            this.downstream.begin(size);
        }

        @Override
        public void end() {
            this.downstream.end();
        }

        @Override
        public boolean cancellationRequested() {
            return this.downstream.cancellationRequested();
        }

        @Override
        public void accept(long value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(double value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(Integer i) {
            SinkDefaults.OfInt.accept(this, i);
        }
    }

    public static abstract class ChainedReference<T, E_OUT>
    implements Sink<T> {
        protected final Sink<? super E_OUT> downstream;

        public ChainedReference(Sink<? super E_OUT> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void begin(long size) {
            this.downstream.begin(size);
        }

        @Override
        public void end() {
            this.downstream.end();
        }

        @Override
        public boolean cancellationRequested() {
            return this.downstream.cancellationRequested();
        }

        @Override
        public void accept(int value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(long value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(double value) {
            SinkDefaults.accept(this, value);
        }
    }

    public static interface OfDouble
    extends Sink<Double>,
    DoubleConsumer {
        @Override
        public void accept(double var1);

        @Override
        public void accept(Double var1);
    }

    public static interface OfLong
    extends Sink<Long>,
    LongConsumer {
        @Override
        public void accept(long var1);

        @Override
        public void accept(Long var1);
    }

    public static interface OfInt
    extends Sink<Integer>,
    IntConsumer {
        @Override
        public void accept(int var1);

        @Override
        public void accept(Integer var1);
    }
}

