/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java.util.Collection;
import java.util.Iterator;
import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.function.Supplier;
import java8.util.function.UnaryOperator;
import java8.util.stream.DoublePipeline;
import java8.util.stream.DoubleStream;
import java8.util.stream.IntPipeline;
import java8.util.stream.IntStream;
import java8.util.stream.LongPipeline;
import java8.util.stream.LongStream;
import java8.util.stream.ReferencePipeline;
import java8.util.stream.Stream;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.Streams;

public final class StreamSupport {
    private StreamSupport() {
    }

    public static <T> Stream.Builder<T> builder() {
        return new Streams.StreamBuilderImpl();
    }

    public static <T> Stream<T> empty() {
        return StreamSupport.stream(Spliterators.emptySpliterator(), false);
    }

    public static <T> Stream<T> of(T t) {
        return StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> ofNullable(T t) {
        return t == null ? StreamSupport.empty() : StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> of(T ... values) {
        return J8Arrays.stream(values);
    }

    public static <T> Stream<T> iterate(final T seed, final UnaryOperator<T> f) {
        Objects.requireNonNull(f);
        Iterator iterator = new Iterator<T>(){
            T t = Streams.NONE;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                this.t = this.t == Streams.NONE ? seed : f.apply(this.t);
                return this.t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1040), false);
    }

    public static <T> Stream<T> generate(Supplier<T> s) {
        Objects.requireNonNull(s);
        return StreamSupport.stream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfRef<T>(Long.MAX_VALUE, s), false);
    }

    public static <T> Stream<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfRef split = new Streams.ConcatSpliterator.OfRef(a.spliterator(), b.spliterator());
        Stream stream = StreamSupport.stream(split, a.isParallel() || b.isParallel());
        return (Stream)stream.onClose(Streams.composedClose(a, b));
    }

    public static <T> Stream.Builder<T> add(Stream.Builder<T> builder, T t) {
        builder.accept(t);
        return builder;
    }

    public static <T> Stream<T> stream(Collection<? extends T> c) {
        return StreamSupport.stream(Spliterators.spliterator(c), false);
    }

    public static <T> Stream<T> parallelStream(Collection<? extends T> c) {
        return StreamSupport.stream(Spliterators.spliterator(c), true);
    }

    public static <T> Stream<T> stream(Collection<? extends T> c, int characteristics) {
        return StreamSupport.stream(c, characteristics, false);
    }

    public static <T> Stream<T> stream(Collection<? extends T> c, int characteristics, boolean parallel) {
        Objects.requireNonNull(c);
        return StreamSupport.stream(Spliterators.spliterator(c, characteristics), parallel);
    }

    public static <T> Stream<T> stream(Spliterator<T> spliterator, boolean parallel) {
        Objects.requireNonNull(spliterator);
        return new ReferencePipeline.Head(spliterator, StreamOpFlag.fromCharacteristics(spliterator), parallel);
    }

    public static <T> Stream<T> stream(Supplier<? extends Spliterator<T>> supplier, int characteristics, boolean parallel) {
        Objects.requireNonNull(supplier);
        return new ReferencePipeline.Head(supplier, StreamOpFlag.fromCharacteristics(characteristics), parallel);
    }

    public static IntStream intStream(Spliterator.OfInt spliterator, boolean parallel) {
        return new IntPipeline.Head(spliterator, StreamOpFlag.fromCharacteristics(spliterator), parallel);
    }

    public static IntStream intStream(Supplier<? extends Spliterator.OfInt> supplier, int characteristics, boolean parallel) {
        return new IntPipeline.Head((Supplier<? extends Spliterator<Integer>>)((Supplier<Spliterator<Integer>>)supplier), StreamOpFlag.fromCharacteristics(characteristics), parallel);
    }

    public static LongStream longStream(Spliterator.OfLong spliterator, boolean parallel) {
        return new LongPipeline.Head(spliterator, StreamOpFlag.fromCharacteristics(spliterator), parallel);
    }

    public static LongStream longStream(Supplier<? extends Spliterator.OfLong> supplier, int characteristics, boolean parallel) {
        return new LongPipeline.Head((Supplier<? extends Spliterator<Long>>)((Supplier<Spliterator<Long>>)supplier), StreamOpFlag.fromCharacteristics(characteristics), parallel);
    }

    public static DoubleStream doubleStream(Spliterator.OfDouble spliterator, boolean parallel) {
        return new DoublePipeline.Head(spliterator, StreamOpFlag.fromCharacteristics(spliterator), parallel);
    }

    public static DoubleStream doubleStream(Supplier<? extends Spliterator.OfDouble> supplier, int characteristics, boolean parallel) {
        return new DoublePipeline.Head((Supplier<? extends Spliterator<Double>>)((Supplier<Spliterator<Double>>)supplier), StreamOpFlag.fromCharacteristics(characteristics), parallel);
    }
}

