/*
 * Decompiled with CFR 0.152.
 */
package java8.lang;

import java.math.BigInteger;
import java8.lang.Integers;

public final class Longs {
    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor < 0L) {
            return Longs.compareUnsigned(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend > 0L) {
            return dividend / divisor;
        }
        return Longs.toUnsignedBigInteger(dividend).divide(Longs.toUnsignedBigInteger(divisor)).longValue();
    }

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(Integers.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integers.toUnsignedLong(lower)));
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(long x, long y) {
        return Longs.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (dividend > 0L && divisor > 0L) {
            return dividend % divisor;
        }
        if (Longs.compareUnsigned(dividend, divisor) < 0) {
            return dividend;
        }
        return Longs.toUnsignedBigInteger(dividend).remainder(Longs.toUnsignedBigInteger(divisor)).longValue();
    }

    public static long sum(long a, long b) {
        return a + b;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    private Longs() {
    }
}

