/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

final class DualPivotQuicksort {
    private static final int MAX_RUN_COUNT = 67;
    private static final int QUICKSORT_THRESHOLD = 286;
    private static final int INSERTION_SORT_THRESHOLD = 47;
    private static final int COUNTING_SORT_THRESHOLD_FOR_BYTE = 29;
    private static final int COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR = 3200;
    private static final int NUM_SHORT_VALUES = 65536;
    private static final int NUM_CHAR_VALUES = 65536;
    private static final int NUM_BYTE_VALUES = 256;

    private DualPivotQuicksort() {
    }

    static void sort(int[] a, int left, int right, int[] work, int workBase, int workLen) {
        int ao;
        int bo;
        int[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a[k] == a[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    int t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            }
            if (run[count] > left && a[run[count]] >= a[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count <= 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new int[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a, left, work, workBase, blen);
            b = a;
            bo = 0;
            a = work;
            ao = workBase - left;
        } else {
            b = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i + bo] = q >= hi || p < mi && a[p + ao] <= a[q + ao] ? a[p++ + ao] : a[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i + bo] = a[i + ao];
                }
                run[++last] = right;
            }
            int[] t = a;
            a = b;
            b = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(int[] a, int left, int right, boolean leftmost) {
        int t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    int ai = a[i + 1];
                    while (ai < a[j]) {
                        a[j + 1] = a[j];
                        if (j-- != left) continue;
                    }
                    a[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a[++left] >= a[left - 1]);
                int k = left;
                while (++left <= right) {
                    int a1 = a[k];
                    int a2 = a[left];
                    if (a1 < a2) {
                        a2 = a1;
                        a1 = a[left];
                    }
                    while (a1 < a[--k]) {
                        a[k + 2] = a[k];
                    }
                    a[++k + 1] = a1;
                    while (a2 < a[--k]) {
                        a[k + 1] = a[k];
                    }
                    a[k + 1] = a2;
                    k = ++left;
                }
                int last = a[right];
                while (last < a[--right]) {
                    a[right + 1] = a[right];
                }
                a[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a[e2] < a[e1]) {
            t = a[e2];
            a[e2] = a[e1];
            a[e1] = t;
        }
        if (a[e3] < a[e2]) {
            t = a[e3];
            a[e3] = a[e2];
            a[e2] = t;
            if (t < a[e1]) {
                a[e2] = a[e1];
                a[e1] = t;
            }
        }
        if (a[e4] < a[e3]) {
            t = a[e4];
            a[e4] = a[e3];
            a[e3] = t;
            if (t < a[e2]) {
                a[e3] = a[e2];
                a[e2] = t;
                if (t < a[e1]) {
                    a[e2] = a[e1];
                    a[e1] = t;
                }
            }
        }
        if (a[e5] < a[e4]) {
            t = a[e5];
            a[e5] = a[e4];
            a[e4] = t;
            if (t < a[e3]) {
                a[e4] = a[e3];
                a[e3] = t;
                if (t < a[e2]) {
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a[e1] != a[e2] && a[e2] != a[e3] && a[e3] != a[e4] && a[e4] != a[e5]) {
            int ak;
            int pivot1 = a[e2];
            int pivot2 = a[e4];
            a[e2] = a[left];
            a[e4] = a[right];
            while (a[++less] < pivot1) {
            }
            while (a[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a[k];
                if (ak < pivot1) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a[great] < pivot1) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            a[left] = a[less - 1];
            a[less - 1] = pivot1;
            a[right] = a[great + 1];
            a[great + 1] = pivot2;
            DualPivotQuicksort.sort(a, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a[less] == pivot1) {
                    ++less;
                }
                while (a[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a[k];
                    if (ak == pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less] = pivot1;
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a, less, great, false);
        } else {
            int pivot = a[e3];
            for (int k = less; k <= great; ++k) {
                if (a[k] == pivot) continue;
                int ak = a[k];
                if (ak < pivot) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                while (a[great] > pivot) {
                    --great;
                }
                if (a[great] < pivot) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = pivot;
                }
                a[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    static void sort(long[] a, int left, int right, long[] work, int workBase, int workLen) {
        int ao;
        int bo;
        long[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a[k] == a[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    long t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            }
            if (run[count] > left && a[run[count]] >= a[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count <= 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new long[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a, left, work, workBase, blen);
            b = a;
            bo = 0;
            a = work;
            ao = workBase - left;
        } else {
            b = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i + bo] = q >= hi || p < mi && a[p + ao] <= a[q + ao] ? a[p++ + ao] : a[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i + bo] = a[i + ao];
                }
                run[++last] = right;
            }
            long[] t = a;
            a = b;
            b = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(long[] a, int left, int right, boolean leftmost) {
        long t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    long ai = a[i + 1];
                    while (ai < a[j]) {
                        a[j + 1] = a[j];
                        if (j-- != left) continue;
                    }
                    a[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a[++left] >= a[left - 1]);
                int k = left;
                while (++left <= right) {
                    long a1 = a[k];
                    long a2 = a[left];
                    if (a1 < a2) {
                        a2 = a1;
                        a1 = a[left];
                    }
                    while (a1 < a[--k]) {
                        a[k + 2] = a[k];
                    }
                    a[++k + 1] = a1;
                    while (a2 < a[--k]) {
                        a[k + 1] = a[k];
                    }
                    a[k + 1] = a2;
                    k = ++left;
                }
                long last = a[right];
                while (last < a[--right]) {
                    a[right + 1] = a[right];
                }
                a[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a[e2] < a[e1]) {
            t = a[e2];
            a[e2] = a[e1];
            a[e1] = t;
        }
        if (a[e3] < a[e2]) {
            t = a[e3];
            a[e3] = a[e2];
            a[e2] = t;
            if (t < a[e1]) {
                a[e2] = a[e1];
                a[e1] = t;
            }
        }
        if (a[e4] < a[e3]) {
            t = a[e4];
            a[e4] = a[e3];
            a[e3] = t;
            if (t < a[e2]) {
                a[e3] = a[e2];
                a[e2] = t;
                if (t < a[e1]) {
                    a[e2] = a[e1];
                    a[e1] = t;
                }
            }
        }
        if (a[e5] < a[e4]) {
            t = a[e5];
            a[e5] = a[e4];
            a[e4] = t;
            if (t < a[e3]) {
                a[e4] = a[e3];
                a[e3] = t;
                if (t < a[e2]) {
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a[e1] != a[e2] && a[e2] != a[e3] && a[e3] != a[e4] && a[e4] != a[e5]) {
            long ak;
            long pivot1 = a[e2];
            long pivot2 = a[e4];
            a[e2] = a[left];
            a[e4] = a[right];
            while (a[++less] < pivot1) {
            }
            while (a[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a[k];
                if (ak < pivot1) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a[great] < pivot1) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            a[left] = a[less - 1];
            a[less - 1] = pivot1;
            a[right] = a[great + 1];
            a[great + 1] = pivot2;
            DualPivotQuicksort.sort(a, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a[less] == pivot1) {
                    ++less;
                }
                while (a[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a[k];
                    if (ak == pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less] = pivot1;
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a, less, great, false);
        } else {
            long pivot = a[e3];
            for (int k = less; k <= great; ++k) {
                if (a[k] == pivot) continue;
                long ak = a[k];
                if (ak < pivot) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                while (a[great] > pivot) {
                    --great;
                }
                if (a[great] < pivot) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = pivot;
                }
                a[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    static void sort(short[] a, int left, int right, short[] work, int workBase, int workLen) {
        if (right - left > 3200) {
            int[] count = new int[65536];
            int i = left - 1;
            while (++i <= right) {
                int n = a[i] - Short.MIN_VALUE;
                count[n] = count[n] + 1;
            }
            i = 65536;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                short value = (short)(i + Short.MIN_VALUE);
                int s = count[i];
                do {
                    a[--k] = value;
                } while (--s > 0);
            }
        } else {
            DualPivotQuicksort.doSort(a, left, right, work, workBase, workLen);
        }
    }

    private static void doSort(short[] a, int left, int right, short[] work, int workBase, int workLen) {
        int ao;
        int bo;
        short[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a[k] == a[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    short t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            }
            if (run[count] > left && a[run[count]] >= a[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count <= 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new short[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a, left, work, workBase, blen);
            b = a;
            bo = 0;
            a = work;
            ao = workBase - left;
        } else {
            b = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i + bo] = q >= hi || p < mi && a[p + ao] <= a[q + ao] ? a[p++ + ao] : a[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i + bo] = a[i + ao];
                }
                run[++last] = right;
            }
            short[] t = a;
            a = b;
            b = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(short[] a, int left, int right, boolean leftmost) {
        short t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    short ai = a[i + 1];
                    while (ai < a[j]) {
                        a[j + 1] = a[j];
                        if (j-- != left) continue;
                    }
                    a[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a[++left] >= a[left - 1]);
                int k = left;
                while (++left <= right) {
                    short a1 = a[k];
                    short a2 = a[left];
                    if (a1 < a2) {
                        a2 = a1;
                        a1 = a[left];
                    }
                    while (a1 < a[--k]) {
                        a[k + 2] = a[k];
                    }
                    a[++k + 1] = a1;
                    while (a2 < a[--k]) {
                        a[k + 1] = a[k];
                    }
                    a[k + 1] = a2;
                    k = ++left;
                }
                short last = a[right];
                while (last < a[--right]) {
                    a[right + 1] = a[right];
                }
                a[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a[e2] < a[e1]) {
            t = a[e2];
            a[e2] = a[e1];
            a[e1] = t;
        }
        if (a[e3] < a[e2]) {
            t = a[e3];
            a[e3] = a[e2];
            a[e2] = t;
            if (t < a[e1]) {
                a[e2] = a[e1];
                a[e1] = t;
            }
        }
        if (a[e4] < a[e3]) {
            t = a[e4];
            a[e4] = a[e3];
            a[e3] = t;
            if (t < a[e2]) {
                a[e3] = a[e2];
                a[e2] = t;
                if (t < a[e1]) {
                    a[e2] = a[e1];
                    a[e1] = t;
                }
            }
        }
        if (a[e5] < a[e4]) {
            t = a[e5];
            a[e5] = a[e4];
            a[e4] = t;
            if (t < a[e3]) {
                a[e4] = a[e3];
                a[e3] = t;
                if (t < a[e2]) {
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a[e1] != a[e2] && a[e2] != a[e3] && a[e3] != a[e4] && a[e4] != a[e5]) {
            short ak;
            short pivot1 = a[e2];
            short pivot2 = a[e4];
            a[e2] = a[left];
            a[e4] = a[right];
            while (a[++less] < pivot1) {
            }
            while (a[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a[k];
                if (ak < pivot1) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a[great] < pivot1) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            a[left] = a[less - 1];
            a[less - 1] = pivot1;
            a[right] = a[great + 1];
            a[great + 1] = pivot2;
            DualPivotQuicksort.sort(a, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a[less] == pivot1) {
                    ++less;
                }
                while (a[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a[k];
                    if (ak == pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less] = pivot1;
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a, less, great, false);
        } else {
            short pivot = a[e3];
            for (int k = less; k <= great; ++k) {
                if (a[k] == pivot) continue;
                short ak = a[k];
                if (ak < pivot) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                while (a[great] > pivot) {
                    --great;
                }
                if (a[great] < pivot) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = pivot;
                }
                a[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    static void sort(char[] a, int left, int right, char[] work, int workBase, int workLen) {
        if (right - left > 3200) {
            int[] count = new int[65536];
            int i = left - 1;
            while (++i <= right) {
                char c = a[i];
                count[c] = count[c] + 1;
            }
            i = 65536;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                char value = (char)i;
                int s = count[i];
                do {
                    a[--k] = value;
                } while (--s > 0);
            }
        } else {
            DualPivotQuicksort.doSort(a, left, right, work, workBase, workLen);
        }
    }

    private static void doSort(char[] a, int left, int right, char[] work, int workBase, int workLen) {
        int ao;
        int bo;
        char[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a[k] == a[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    char t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            }
            if (run[count] > left && a[run[count]] >= a[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count <= 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new char[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a, left, work, workBase, blen);
            b = a;
            bo = 0;
            a = work;
            ao = workBase - left;
        } else {
            b = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i + bo] = q >= hi || p < mi && a[p + ao] <= a[q + ao] ? a[p++ + ao] : a[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i + bo] = a[i + ao];
                }
                run[++last] = right;
            }
            char[] t = a;
            a = b;
            b = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(char[] a, int left, int right, boolean leftmost) {
        char t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    char ai = a[i + 1];
                    while (ai < a[j]) {
                        a[j + 1] = a[j];
                        if (j-- != left) continue;
                    }
                    a[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a[++left] >= a[left - 1]);
                int k = left;
                while (++left <= right) {
                    char a1 = a[k];
                    char a2 = a[left];
                    if (a1 < a2) {
                        a2 = a1;
                        a1 = a[left];
                    }
                    while (a1 < a[--k]) {
                        a[k + 2] = a[k];
                    }
                    a[++k + 1] = a1;
                    while (a2 < a[--k]) {
                        a[k + 1] = a[k];
                    }
                    a[k + 1] = a2;
                    k = ++left;
                }
                char last = a[right];
                while (last < a[--right]) {
                    a[right + 1] = a[right];
                }
                a[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a[e2] < a[e1]) {
            t = a[e2];
            a[e2] = a[e1];
            a[e1] = t;
        }
        if (a[e3] < a[e2]) {
            t = a[e3];
            a[e3] = a[e2];
            a[e2] = t;
            if (t < a[e1]) {
                a[e2] = a[e1];
                a[e1] = t;
            }
        }
        if (a[e4] < a[e3]) {
            t = a[e4];
            a[e4] = a[e3];
            a[e3] = t;
            if (t < a[e2]) {
                a[e3] = a[e2];
                a[e2] = t;
                if (t < a[e1]) {
                    a[e2] = a[e1];
                    a[e1] = t;
                }
            }
        }
        if (a[e5] < a[e4]) {
            t = a[e5];
            a[e5] = a[e4];
            a[e4] = t;
            if (t < a[e3]) {
                a[e4] = a[e3];
                a[e3] = t;
                if (t < a[e2]) {
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a[e1] != a[e2] && a[e2] != a[e3] && a[e3] != a[e4] && a[e4] != a[e5]) {
            char ak;
            char pivot1 = a[e2];
            char pivot2 = a[e4];
            a[e2] = a[left];
            a[e4] = a[right];
            while (a[++less] < pivot1) {
            }
            while (a[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a[k];
                if (ak < pivot1) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a[great] < pivot1) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            a[left] = a[less - 1];
            a[less - 1] = pivot1;
            a[right] = a[great + 1];
            a[great + 1] = pivot2;
            DualPivotQuicksort.sort(a, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a[less] == pivot1) {
                    ++less;
                }
                while (a[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a[k];
                    if (ak == pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less] = pivot1;
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a, less, great, false);
        } else {
            char pivot = a[e3];
            for (int k = less; k <= great; ++k) {
                if (a[k] == pivot) continue;
                char ak = a[k];
                if (ak < pivot) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                while (a[great] > pivot) {
                    --great;
                }
                if (a[great] < pivot) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = pivot;
                }
                a[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    static void sort(byte[] a, int left, int right) {
        if (right - left > 29) {
            int[] count = new int[256];
            int i = left - 1;
            while (++i <= right) {
                int n = a[i] - -128;
                count[n] = count[n] + 1;
            }
            i = 256;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                byte value = (byte)(i + -128);
                int s = count[i];
                do {
                    a[--k] = value;
                } while (--s > 0);
            }
        } else {
            int i;
            int j = i = left;
            while (i < right) {
                byte ai = a[i + 1];
                while (ai < a[j]) {
                    a[j + 1] = a[j];
                    if (j-- != left) continue;
                }
                a[j + 1] = ai;
                j = ++i;
            }
        }
    }

    static void sort(float[] a, int left, int right, float[] work, int workBase, int workLen) {
        float ak;
        while (left <= right && Float.isNaN(a[right])) {
            --right;
        }
        int k = right;
        while (--k >= left) {
            float ak2 = a[k];
            if (ak2 == ak2) continue;
            a[k] = a[right];
            a[right] = ak2;
            --right;
        }
        DualPivotQuicksort.doSort(a, left, right, work, workBase, workLen);
        int hi = right;
        while (left < hi) {
            int middle = left + hi >>> 1;
            float middleValue = a[middle];
            if (middleValue < 0.0f) {
                left = middle + 1;
                continue;
            }
            hi = middle;
        }
        while (left <= right && Float.floatToRawIntBits(a[left]) < 0) {
            ++left;
        }
        int k2 = left;
        int p = left - 1;
        while (++k2 <= right && (ak = a[k2]) == 0.0f) {
            if (Float.floatToRawIntBits(ak) >= 0) continue;
            a[k2] = 0.0f;
            a[++p] = -0.0f;
        }
    }

    private static void doSort(float[] a, int left, int right, float[] work, int workBase, int workLen) {
        int ao;
        int bo;
        float[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a[k] == a[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    float t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            }
            if (run[count] > left && a[run[count]] >= a[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count <= 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new float[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a, left, work, workBase, blen);
            b = a;
            bo = 0;
            a = work;
            ao = workBase - left;
        } else {
            b = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i + bo] = q >= hi || p < mi && a[p + ao] <= a[q + ao] ? a[p++ + ao] : a[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i + bo] = a[i + ao];
                }
                run[++last] = right;
            }
            float[] t = a;
            a = b;
            b = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(float[] a, int left, int right, boolean leftmost) {
        float t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    float ai = a[i + 1];
                    while (ai < a[j]) {
                        a[j + 1] = a[j];
                        if (j-- != left) continue;
                    }
                    a[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a[++left] >= a[left - 1]);
                int k = left;
                while (++left <= right) {
                    float a1 = a[k];
                    float a2 = a[left];
                    if (a1 < a2) {
                        a2 = a1;
                        a1 = a[left];
                    }
                    while (a1 < a[--k]) {
                        a[k + 2] = a[k];
                    }
                    a[++k + 1] = a1;
                    while (a2 < a[--k]) {
                        a[k + 1] = a[k];
                    }
                    a[k + 1] = a2;
                    k = ++left;
                }
                float last = a[right];
                while (last < a[--right]) {
                    a[right + 1] = a[right];
                }
                a[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a[e2] < a[e1]) {
            t = a[e2];
            a[e2] = a[e1];
            a[e1] = t;
        }
        if (a[e3] < a[e2]) {
            t = a[e3];
            a[e3] = a[e2];
            a[e2] = t;
            if (t < a[e1]) {
                a[e2] = a[e1];
                a[e1] = t;
            }
        }
        if (a[e4] < a[e3]) {
            t = a[e4];
            a[e4] = a[e3];
            a[e3] = t;
            if (t < a[e2]) {
                a[e3] = a[e2];
                a[e2] = t;
                if (t < a[e1]) {
                    a[e2] = a[e1];
                    a[e1] = t;
                }
            }
        }
        if (a[e5] < a[e4]) {
            t = a[e5];
            a[e5] = a[e4];
            a[e4] = t;
            if (t < a[e3]) {
                a[e4] = a[e3];
                a[e3] = t;
                if (t < a[e2]) {
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a[e1] != a[e2] && a[e2] != a[e3] && a[e3] != a[e4] && a[e4] != a[e5]) {
            float ak;
            float pivot1 = a[e2];
            float pivot2 = a[e4];
            a[e2] = a[left];
            a[e4] = a[right];
            while (a[++less] < pivot1) {
            }
            while (a[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a[k];
                if (ak < pivot1) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                if (!(ak > pivot2)) continue;
                while (a[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a[great] < pivot1) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            a[left] = a[less - 1];
            a[less - 1] = pivot1;
            a[right] = a[great + 1];
            a[great + 1] = pivot2;
            DualPivotQuicksort.sort(a, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a[less] == pivot1) {
                    ++less;
                }
                while (a[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a[k];
                    if (ak == pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a, less, great, false);
        } else {
            float pivot = a[e3];
            for (int k = less; k <= great; ++k) {
                if (a[k] == pivot) continue;
                float ak = a[k];
                if (ak < pivot) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                while (a[great] > pivot) {
                    --great;
                }
                if (a[great] < pivot) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    static void sort(double[] a, int left, int right, double[] work, int workBase, int workLen) {
        double ak;
        while (left <= right && Double.isNaN(a[right])) {
            --right;
        }
        int k = right;
        while (--k >= left) {
            double ak2 = a[k];
            if (ak2 == ak2) continue;
            a[k] = a[right];
            a[right] = ak2;
            --right;
        }
        DualPivotQuicksort.doSort(a, left, right, work, workBase, workLen);
        int hi = right;
        while (left < hi) {
            int middle = left + hi >>> 1;
            double middleValue = a[middle];
            if (middleValue < 0.0) {
                left = middle + 1;
                continue;
            }
            hi = middle;
        }
        while (left <= right && Double.doubleToRawLongBits(a[left]) < 0L) {
            ++left;
        }
        int k2 = left;
        int p = left - 1;
        while (++k2 <= right && (ak = a[k2]) == 0.0) {
            if (Double.doubleToRawLongBits(ak) >= 0L) continue;
            a[k2] = 0.0;
            a[++p] = -0.0;
        }
    }

    private static void doSort(double[] a, int left, int right, double[] work, int workBase, int workLen) {
        int ao;
        int bo;
        double[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a[k] == a[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    double t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            }
            if (run[count] > left && a[run[count]] >= a[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count <= 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new double[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a, left, work, workBase, blen);
            b = a;
            bo = 0;
            a = work;
            ao = workBase - left;
        } else {
            b = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i + bo] = q >= hi || p < mi && a[p + ao] <= a[q + ao] ? a[p++ + ao] : a[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i + bo] = a[i + ao];
                }
                run[++last] = right;
            }
            double[] t = a;
            a = b;
            b = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(double[] a, int left, int right, boolean leftmost) {
        double t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    double ai = a[i + 1];
                    while (ai < a[j]) {
                        a[j + 1] = a[j];
                        if (j-- != left) continue;
                    }
                    a[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a[++left] >= a[left - 1]);
                int k = left;
                while (++left <= right) {
                    double a1 = a[k];
                    double a2 = a[left];
                    if (a1 < a2) {
                        a2 = a1;
                        a1 = a[left];
                    }
                    while (a1 < a[--k]) {
                        a[k + 2] = a[k];
                    }
                    a[++k + 1] = a1;
                    while (a2 < a[--k]) {
                        a[k + 1] = a[k];
                    }
                    a[k + 1] = a2;
                    k = ++left;
                }
                double last = a[right];
                while (last < a[--right]) {
                    a[right + 1] = a[right];
                }
                a[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a[e2] < a[e1]) {
            t = a[e2];
            a[e2] = a[e1];
            a[e1] = t;
        }
        if (a[e3] < a[e2]) {
            t = a[e3];
            a[e3] = a[e2];
            a[e2] = t;
            if (t < a[e1]) {
                a[e2] = a[e1];
                a[e1] = t;
            }
        }
        if (a[e4] < a[e3]) {
            t = a[e4];
            a[e4] = a[e3];
            a[e3] = t;
            if (t < a[e2]) {
                a[e3] = a[e2];
                a[e2] = t;
                if (t < a[e1]) {
                    a[e2] = a[e1];
                    a[e1] = t;
                }
            }
        }
        if (a[e5] < a[e4]) {
            t = a[e5];
            a[e5] = a[e4];
            a[e4] = t;
            if (t < a[e3]) {
                a[e4] = a[e3];
                a[e3] = t;
                if (t < a[e2]) {
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a[e1] != a[e2] && a[e2] != a[e3] && a[e3] != a[e4] && a[e4] != a[e5]) {
            double ak;
            double pivot1 = a[e2];
            double pivot2 = a[e4];
            a[e2] = a[left];
            a[e4] = a[right];
            while (a[++less] < pivot1) {
            }
            while (a[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a[k];
                if (ak < pivot1) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                if (!(ak > pivot2)) continue;
                while (a[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a[great] < pivot1) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            a[left] = a[less - 1];
            a[less - 1] = pivot1;
            a[right] = a[great + 1];
            a[great + 1] = pivot2;
            DualPivotQuicksort.sort(a, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a[less] == pivot1) {
                    ++less;
                }
                while (a[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a[k];
                    if (ak == pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a, less, great, false);
        } else {
            double pivot = a[e3];
            for (int k = less; k <= great; ++k) {
                if (a[k] == pivot) continue;
                double ak = a[k];
                if (ak < pivot) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                while (a[great] > pivot) {
                    --great;
                }
                if (a[great] < pivot) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }
}

