/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Arrays;
import java.util.Comparator;
import java8.util.function.BiFunction;
import java8.util.function.Supplier;

public final class Objects {
    private Objects() {
        throw new AssertionError();
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean deepEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Objects.deepEquals0(a, b);
    }

    private static boolean deepEquals0(Object e1, Object e2) {
        boolean eq = e1 instanceof Object[] && e2 instanceof Object[] ? Arrays.deepEquals((Object[])e1, (Object[])e2) : (e1 instanceof byte[] && e2 instanceof byte[] ? Objects.equals((byte[])e1, (byte[])e2) : (e1 instanceof short[] && e2 instanceof short[] ? Objects.equals((short[])e1, (short[])e2) : (e1 instanceof int[] && e2 instanceof int[] ? Objects.equals((int[])e1, (int[])e2) : (e1 instanceof long[] && e2 instanceof long[] ? Objects.equals((long[])e1, (long[])e2) : (e1 instanceof char[] && e2 instanceof char[] ? Objects.equals((char[])e1, (char[])e2) : (e1 instanceof float[] && e2 instanceof float[] ? Objects.equals((float[])e1, (float[])e2) : (e1 instanceof double[] && e2 instanceof double[] ? Objects.equals((double[])e1, (double[])e2) : (e1 instanceof boolean[] && e2 instanceof boolean[] ? Objects.equals((boolean[])e1, (boolean[])e2) : e1.equals(e2)))))))));
        return eq;
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static String toString(Object o) {
        return String.valueOf(o);
    }

    public static String toString(Object o, String nullDefault) {
        return o != null ? o.toString() : nullDefault;
    }

    public static <T> int compare(T a, T b, Comparator<? super T> c) {
        return a == b ? 0 : c.compare(a, b);
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean nonNull(Object obj) {
        return obj != null;
    }

    public static <T> T requireNonNullElse(T obj, T defaultObj) {
        return obj != null ? obj : Objects.requireNonNull(defaultObj, "defaultObj");
    }

    public static <T> T requireNonNullElseGet(T obj, Supplier<? extends T> supplier) {
        return obj != null ? obj : Objects.requireNonNull(Objects.requireNonNull(supplier, "supplier").get(), "supplier.get()");
    }

    public static <T> T requireNonNull(T obj, Supplier<String> messageSupplier) {
        if (obj == null) {
            throw new NullPointerException(messageSupplier.get());
        }
        return obj;
    }

    private static RuntimeException outOfBounds(int a, int b, BiFunction<Integer, Integer, ? extends RuntimeException> oobe) {
        IndexOutOfBoundsException e = oobe == null ? null : oobe.apply(a, b);
        return e == null ? new IndexOutOfBoundsException("Indexed access out of bounds: " + a + ", " + b) : e;
    }

    public static int checkIndex(int index, int length) throws IndexOutOfBoundsException {
        return Objects.checkIndex(index, length, null);
    }

    public static <T extends RuntimeException> int checkIndex(int index, int length, BiFunction<Integer, Integer, T> oobe) throws T, IndexOutOfBoundsException {
        if (index < 0 || index >= length) {
            throw Objects.outOfBounds(index, length, oobe);
        }
        return index;
    }

    public static int checkFromToIndex(int fromIndex, int toIndex, int length) throws IndexOutOfBoundsException {
        return Objects.checkFromToIndex(fromIndex, toIndex, length, null);
    }

    public static <T extends RuntimeException> int checkFromToIndex(int fromIndex, int toIndex, int length, BiFunction<Integer, Integer, T> oobe) throws T, IndexOutOfBoundsException {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw Objects.outOfBounds(fromIndex, toIndex, oobe);
        }
        return fromIndex;
    }

    public static int checkFromIndexSize(int fromIndex, int size, int length) throws IndexOutOfBoundsException {
        return Objects.checkFromIndexSize(fromIndex, size, length, null);
    }

    public static <T extends RuntimeException> int checkFromIndexSize(int fromIndex, int size, int length, BiFunction<Integer, Integer, T> oobe) throws T, IndexOutOfBoundsException {
        if ((length | fromIndex | size) < 0 || size > length - fromIndex) {
            throw Objects.outOfBounds(fromIndex, size, oobe);
        }
        return fromIndex;
    }
}

