/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.function.Consumer;

final class PBQueueSpliterator<E>
implements Spliterator<E> {
    private final PriorityBlockingQueue<E> queue;
    private Object[] array;
    private int index;
    private int fence;

    private PBQueueSpliterator(PriorityBlockingQueue<E> queue, Object[] array, int index, int fence) {
        this.queue = queue;
        this.array = array;
        this.index = index;
        this.fence = fence;
    }

    static <T> Spliterator<T> spliterator(PriorityBlockingQueue<T> queue) {
        return new PBQueueSpliterator<T>(queue, null, 0, -1);
    }

    private int getFence() {
        int hi = this.fence;
        if (hi < 0) {
            this.array = this.queue.toArray();
            hi = this.fence = this.array.length;
        }
        return hi;
    }

    @Override
    public Spliterator<E> trySplit() {
        PBQueueSpliterator<E> pBQueueSpliterator;
        int lo = this.index;
        int hi = this.getFence();
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            pBQueueSpliterator = null;
        } else {
            this.index = mid;
            PBQueueSpliterator<E> pBQueueSpliterator2 = new PBQueueSpliterator<E>(this.queue, this.array, lo, this.index);
            pBQueueSpliterator = pBQueueSpliterator2;
        }
        return pBQueueSpliterator;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        int i;
        int hi;
        Objects.requireNonNull(action);
        Object[] a = this.array;
        if (this.array == null) {
            a = this.queue.toArray();
            this.fence = a.length;
        }
        if ((hi = this.fence) <= a.length && (i = this.index) >= 0 && i < (this.index = hi)) {
            do {
                action.accept(a[i]);
            } while (++i < hi);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (this.getFence() > this.index && this.index >= 0) {
            Object e = this.array[this.index++];
            action.accept(e);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.getFence() - this.index;
    }

    @Override
    public int characteristics() {
        return 16704;
    }

    @Override
    public Comparator<? super E> getComparator() {
        return Spliterators.getComparator(this);
    }

    @Override
    public long getExactSizeIfKnown() {
        return Spliterators.getExactSizeIfKnown(this);
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return Spliterators.hasCharacteristics(this, characteristics);
    }
}

