/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java8.util.Objects;
import java8.util.concurrent.CountedCompleter;
import java8.util.concurrent.ForkJoinTask;
import java8.util.concurrent.ForkJoinWorkerThread;
import java8.util.concurrent.TLRandom;
import java8.util.concurrent.UnsafeAccess;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    static final int SMASK = 65535;
    static final int MAX_CAP = Short.MAX_VALUE;
    static final int EVENMASK = 65534;
    static final int SQMASK = 126;
    static final int UNSIGNALLED = Integer.MIN_VALUE;
    static final int SS_SEQ = 65536;
    static final int MODE_MASK = -65536;
    static final int SPARE_WORKER = 131072;
    static final int UNREGISTERED = 262144;
    static final int FIFO_QUEUE = Integer.MIN_VALUE;
    static final int LIFO_QUEUE = 0;
    static final int IS_OWNED = 1;
    static final int POLL_LIMIT = 1023;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int COMMON_PARALLELISM;
    private static final int COMMON_MAX_SPARES;
    private static int poolNumberSequence;
    private static final long IDLE_TIMEOUT_MS = 2000L;
    private static final long TIMEOUT_SLOP_MS = 20L;
    private static final int DEFAULT_COMMON_MAX_SPARES = 256;
    private static final int SEED_INCREMENT = -1640531527;
    private static final long SP_MASK = 0xFFFFFFFFL;
    private static final long UC_MASK = -4294967296L;
    private static final int AC_SHIFT = 48;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final int TC_SHIFT = 32;
    private static final long TC_UNIT = 0x100000000L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long ADD_WORKER = 0x800000000000L;
    private static final int STARTED = 1;
    private static final int STOP = 2;
    private static final int TERMINATED = 4;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    volatile long ctl;
    volatile int runState;
    final int config;
    AuxState auxState;
    volatile WorkQueue[] workQueues;
    final String workerNamePrefix;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    private static final Unsafe U;
    private static final long CTL;
    private static final long RUNSTATE;
    private static final int ABASE;
    private static final int ASHIFT;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    static long getAndAddLong(Object o, long offset, long delta) {
        long v;
        while (!U.compareAndSwapLong(o, offset, v = U.getLongVolatile(o, offset), v + delta)) {
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInitialize(boolean checkTermination) {
        if (this.runState == 0) {
            int p = this.config & 0xFFFF;
            int n = p > 1 ? p - 1 : 1;
            n |= n >>> 1;
            n |= n >>> 2;
            n |= n >>> 4;
            n |= n >>> 8;
            n |= n >>> 16;
            n = n + 1 << 1 & 0xFFFF;
            AuxState aux = new AuxState();
            WorkQueue[] ws = new WorkQueue[n];
            RuntimePermission runtimePermission = modifyThreadPermission;
            synchronized (runtimePermission) {
                if (this.runState == 0) {
                    this.workQueues = ws;
                    this.auxState = aux;
                    this.runState = 1;
                }
            }
        }
        if (checkTermination && this.runState < 0) {
            this.tryTerminate(false, false);
            throw new RejectedExecutionException();
        }
    }

    private boolean createWorker(boolean isSpare) {
        ForkJoinWorkerThreadFactory fac = this.factory;
        Throwable ex = null;
        ForkJoinWorkerThread wt = null;
        try {
            if (fac != null && (wt = fac.newThread(this)) != null) {
                WorkQueue q;
                if (isSpare && (q = wt.workQueue) != null) {
                    q.config |= 0x20000;
                }
                wt.start();
                return true;
            }
        }
        catch (Throwable rex) {
            ex = rex;
        }
        this.deregisterWorker(wt, ex);
        return false;
    }

    private void tryAddWorker(long c) {
        do {
            long nc = 0xFFFF000000000000L & c + 0x1000000000000L | 0xFFFF00000000L & c + 0x100000000L;
            if (this.ctl != c || !U.compareAndSwapLong(this, CTL, c, nc)) continue;
            this.createWorker(false);
            break;
        } while (((c = this.ctl) & 0x800000000000L) != 0L && (int)c == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WorkQueue registerWorker(ForkJoinWorkerThread wt) {
        wt.setDaemon(true);
        Thread.UncaughtExceptionHandler handler = this.ueh;
        if (handler != null) {
            wt.setUncaughtExceptionHandler(handler);
        }
        WorkQueue w = new WorkQueue(this, wt);
        int i = 0;
        int mode = this.config & 0xFFFF0000;
        AuxState aux = this.auxState;
        if (aux != null) {
            aux.lock();
            try {
                int n;
                int s = (int)(aux.indexSeed += -1640531527L);
                WorkQueue[] ws = this.workQueues;
                if (ws != null && (n = ws.length) > 0) {
                    int m = n - 1;
                    i = m & (s << 1 | 1);
                    if (ws[i] != null) {
                        int step;
                        int probes = 0;
                        int n2 = step = n <= 4 ? 2 : (n >>> 1 & 0xFFFE) + 2;
                        while (ws[i = i + step & m] != null) {
                            if (++probes < n) continue;
                            this.workQueues = ws = Arrays.copyOf(ws, n <<= 1);
                            m = n - 1;
                            probes = 0;
                        }
                    }
                    w.hint = s;
                    w.config = i | mode;
                    w.scanState = i | s & 0x7FFF0000;
                    ws[i] = w;
                }
            }
            finally {
                aux.unlock();
            }
        }
        wt.setName(this.workerNamePrefix.concat(Integer.toString(i >>> 1)));
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex) {
        WorkQueue w = null;
        if (wt != null && (w = wt.workQueue) != null) {
            int idx = w.config & 0xFFFF;
            int ns = w.nsteals;
            AuxState aux = this.auxState;
            if (aux != null) {
                aux.lock();
                try {
                    WorkQueue[] ws = this.workQueues;
                    if (this.workQueues != null && ws.length > idx && ws[idx] == w) {
                        ws[idx] = null;
                    }
                    aux.stealCount += (long)ns;
                }
                finally {
                    aux.unlock();
                }
            }
        }
        if (w == null || (w.config & 0x40000) == 0) {
            long c;
            while (!U.compareAndSwapLong(this, CTL, c = this.ctl, 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & c)) {
            }
        }
        if (w != null) {
            w.currentSteal = null;
            w.qlock = -1;
            w.cancelAll();
        }
        while (this.tryTerminate(false, false) >= 0 && w != null && w.array != null) {
            int wl;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (wl = ws.length) <= 0) break;
            long c = this.ctl;
            int sp = (int)c;
            if (sp != 0) {
                if (!this.tryRelease(c, ws[wl - 1 & sp], 0x1000000000000L)) continue;
                break;
            }
            if (ex == null || (c & 0x800000000000L) == 0L) break;
            this.tryAddWorker(c);
            break;
        }
        if (ex == null) {
            ForkJoinTask.helpExpungeStaleExceptions();
        } else {
            ForkJoinTask.rethrow(ex);
        }
    }

    final void signalWork() {
        long c;
        while ((c = this.ctl) < 0L) {
            WorkQueue v;
            int i;
            int sp = (int)c;
            if (sp == 0) {
                if ((c & 0x800000000000L) == 0L) break;
                this.tryAddWorker(c);
                break;
            }
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || ws.length <= (i = sp & 0xFFFF) || (v = ws[i]) == null) break;
            int ns = sp & Integer.MAX_VALUE;
            int vs = v.scanState;
            long nc = (long)v.stackPred & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & c + 0x1000000000000L;
            if (sp != vs || !U.compareAndSwapLong(this, CTL, c, nc)) continue;
            v.scanState = ns;
            LockSupport.unpark(v.parker);
            break;
        }
    }

    private boolean tryRelease(long c, WorkQueue v, long inc) {
        int sp = (int)c;
        int ns = sp & Integer.MAX_VALUE;
        if (v != null) {
            int vs = v.scanState;
            long nc = (long)v.stackPred & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & c + inc;
            if (sp == vs && U.compareAndSwapLong(this, CTL, c, nc)) {
                v.scanState = ns;
                LockSupport.unpark(v.parker);
                return true;
            }
        }
        return false;
    }

    private void tryReactivate(WorkQueue w, WorkQueue[] ws, int r) {
        WorkQueue v;
        int wl;
        long c = this.ctl;
        int sp = (int)c;
        if (sp != 0 && w != null && ws != null && (wl = ws.length) > 0 && ((sp ^ r) & 0x10000) == 0 && (v = ws[wl - 1 & sp]) != null) {
            long nc = (long)v.stackPred & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & c + 0x1000000000000L;
            int ns = sp & Integer.MAX_VALUE;
            if (w.scanState < 0 && v.scanState == sp && U.compareAndSwapLong(this, CTL, c, nc)) {
                v.scanState = ns;
                LockSupport.unpark(v.parker);
            }
        }
    }

    private void inactivate(WorkQueue w, int ss) {
        int ns = ss + 65536 | Integer.MIN_VALUE;
        long lc = (long)ns & 0xFFFFFFFFL;
        if (w != null) {
            long nc;
            long c;
            w.scanState = ns;
            do {
                c = this.ctl;
                nc = lc | 0xFFFFFFFF00000000L & c - 0x1000000000000L;
                w.stackPred = (int)c;
            } while (!U.compareAndSwapLong(this, CTL, c, nc));
        }
    }

    private int awaitWork(WorkQueue w) {
        int stat = 0;
        if (w != null && w.scanState < 0) {
            long c = this.ctl;
            if ((int)(c >> 48) + (this.config & 0xFFFF) <= 0) {
                stat = this.timedAwaitWork(w, c);
            } else if ((this.runState & 2) != 0) {
                w.qlock = -1;
                stat = -1;
            } else if (w.scanState < 0) {
                w.parker = Thread.currentThread();
                if (w.scanState < 0) {
                    LockSupport.park(this);
                }
                w.parker = null;
                if ((this.runState & 2) != 0) {
                    w.qlock = -1;
                    stat = -1;
                } else if (w.scanState < 0) {
                    Thread.interrupted();
                }
            }
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int timedAwaitWork(WorkQueue w, long c) {
        int stat = 0;
        int scale = 1 - (short)(c >>> 32);
        long deadline = (long)(scale <= 0 ? 1 : scale) * 2000L + System.currentTimeMillis();
        if ((this.runState >= 0 || (stat = this.tryTerminate(false, false)) > 0) && w != null && w.scanState < 0) {
            w.parker = Thread.currentThread();
            if (w.scanState < 0) {
                LockSupport.parkUntil(this, deadline);
            }
            w.parker = null;
            if ((this.runState & 2) != 0) {
                w.qlock = -1;
                stat = -1;
            } else {
                AuxState aux;
                int ss = w.scanState;
                if (ss < 0 && !Thread.interrupted() && (int)c == ss && (aux = this.auxState) != null && this.ctl == c && deadline - System.currentTimeMillis() <= 20L) {
                    aux.lock();
                    try {
                        int cfg = w.config;
                        int idx = cfg & 0xFFFF;
                        long nc = 0xFFFFFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & (long)w.stackPred;
                        if ((this.runState & 2) == 0) {
                            WorkQueue[] ws = this.workQueues;
                            if (this.workQueues != null && idx < ws.length && idx >= 0 && ws[idx] == w && U.compareAndSwapLong(this, CTL, c, nc)) {
                                ws[idx] = null;
                                w.config = cfg | 0x40000;
                                w.qlock = -1;
                                stat = -1;
                            }
                        }
                    }
                    finally {
                        aux.unlock();
                    }
                }
            }
        }
        return stat;
    }

    private boolean tryDropSpare(WorkQueue w) {
        if (w != null && w.isEmpty()) {
            int sp;
            long c;
            while ((short)((c = this.ctl) >> 32) > 0 && ((sp = (int)c) != 0 || (int)(c >> 48) > 0)) {
                boolean dropped;
                long nc;
                int wl;
                WorkQueue[] ws = this.workQueues;
                if (this.workQueues == null || (wl = ws.length) <= 0) break;
                if (sp == 0) {
                    nc = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & c;
                    dropped = U.compareAndSwapLong(this, CTL, c, nc);
                } else {
                    WorkQueue v = ws[wl - 1 & sp];
                    if (v == null || v.scanState != sp) {
                        dropped = false;
                    } else {
                        boolean canDrop;
                        nc = (long)v.stackPred & 0xFFFFFFFFL;
                        if (w == v || w.scanState >= 0) {
                            canDrop = true;
                            nc |= 0xFFFF000000000000L & c | 0xFFFF00000000L & c - 0x100000000L;
                        } else {
                            canDrop = false;
                            nc |= 0xFFFF000000000000L & c + 0x1000000000000L | 0xFFFF00000000L & c;
                        }
                        if (U.compareAndSwapLong(this, CTL, c, nc)) {
                            v.scanState = sp & Integer.MAX_VALUE;
                            LockSupport.unpark(v.parker);
                            dropped = canDrop;
                        } else {
                            dropped = false;
                        }
                    }
                }
                if (!dropped) continue;
                int cfg = w.config;
                int idx = cfg & 0xFFFF;
                if (idx >= 0 && idx < ws.length && ws[idx] == w) {
                    ws[idx] = null;
                }
                w.config = cfg | 0x40000;
                w.qlock = -1;
                return true;
            }
        }
        return false;
    }

    final void runWorker(WorkQueue w) {
        w.growArray();
        int bound = (w.config & 0x20000) != 0 ? 0 : 1023;
        long seed = (long)w.hint * -2685821657736338717L;
        if ((this.runState & 2) == 0) {
            long r;
            long l = r = seed == 0L ? 1L : seed;
            while (bound != 0 || !this.tryDropSpare(w)) {
                int step = (int)(r >>> 48) | 1;
                r ^= r >>> 12;
                r ^= r << 25;
                if (this.scan(w, bound, step, (int)(r ^= r >>> 27)) >= 0 || this.awaitWork(w) >= 0) continue;
                break;
            }
        }
    }

    private int scan(WorkQueue w, int bound, int step, int r) {
        int wl;
        int stat = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && w != null && (wl = ws.length) > 0) {
            int origin;
            int m = wl - 1;
            int idx = origin = m & r;
            int npolls = 0;
            int ss = w.scanState;
            while (true) {
                int b;
                WorkQueue q;
                if ((q = ws[idx]) != null && (b = q.base) - q.top < 0) {
                    int al;
                    ForkJoinTask<?>[] a = q.array;
                    if (q.array != null && (al = a.length) > 0) {
                        int index = al - 1 & b;
                        long offset = ((long)index << ASHIFT) + (long)ABASE;
                        ForkJoinTask t = (ForkJoinTask)U.getObjectVolatile(a, offset);
                        if (t == null || b++ != q.base) break;
                        if (ss < 0) {
                            this.tryReactivate(w, ws, r);
                            break;
                        }
                        if (!U.compareAndSwapObject(a, offset, t, null)) break;
                        q.base = b;
                        w.currentSteal = t;
                        if (b != q.top) {
                            this.signalWork();
                        }
                        w.runTask(t);
                        if (++npolls <= bound) continue;
                        break;
                    }
                }
                if (npolls != 0) break;
                if ((idx = idx + step & m) != origin) continue;
                if (ss < 0) {
                    stat = ss;
                    break;
                }
                if (r >= 0) {
                    this.inactivate(w, ss);
                    break;
                }
                r <<= 1;
            }
        }
        return stat;
    }

    final int helpComplete(WorkQueue w, CountedCompleter<?> task, int maxTasks) {
        int wl;
        int s = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (wl = ws.length) > 1 && task != null && w != null) {
            int origin;
            int m = wl - 1;
            int mode = w.config;
            int r = ~mode;
            int k = origin = r & m;
            int step = 3;
            int h = 1;
            int oldSum = 0;
            int checkSum = 0;
            while ((s = task.status) >= 0) {
                WorkQueue q;
                CountedCompleter<?> p;
                if (h == 1 && (p = w.popCC(task, mode)) != null) {
                    p.doExec();
                    if (maxTasks != 0 && --maxTasks == 0) break;
                    origin = k;
                    checkSum = 0;
                    oldSum = 0;
                    continue;
                }
                int i = k | 1;
                if (i < 0 || i > m || (q = ws[i]) == null) {
                    h = 0;
                } else {
                    h = q.pollAndExecCC(task);
                    if (h < 0) {
                        checkSum += h;
                    }
                }
                if (h > 0) {
                    if (h == 1 && maxTasks != 0 && --maxTasks == 0) break;
                    step = r >>> 16 | 3;
                    r ^= r << 13;
                    r ^= r >>> 17;
                    r ^= r << 5;
                    k = origin = r & m;
                    checkSum = 0;
                    oldSum = 0;
                    continue;
                }
                if ((k = k + step & m) != origin) continue;
                if (oldSum == (oldSum = checkSum)) break;
                checkSum = 0;
            }
        }
        return s;
    }

    private void helpStealer(WorkQueue w, ForkJoinTask<?> task) {
        if (task != null && w != null) {
            ForkJoinTask<?> ps = w.currentSteal;
            int oldSum = 0;
            block0: while (w.tryRemoveAndExec(task) && task.status >= 0) {
                int wl;
                WorkQueue[] ws = this.workQueues;
                if (this.workQueues == null || (wl = ws.length) <= 0) break;
                int m = wl - 1;
                int checkSum = 0;
                WorkQueue j = w;
                ForkJoinTask<?> subtask = task;
                block1: while (subtask.status >= 0) {
                    WorkQueue v;
                    block10: {
                        int h = j.hint | 1;
                        int k = 0;
                        do {
                            int i;
                            if ((v = ws[i = h + (k << 1) & m]) == null) continue;
                            if (v.currentSteal == subtask) {
                                j.hint = i;
                                break block10;
                            }
                            checkSum += v.base;
                        } while (++k <= m);
                        break block0;
                    }
                    while (subtask.status >= 0) {
                        int index;
                        long offset;
                        int al;
                        int b = v.base;
                        checkSum += b;
                        ForkJoinTask<?> next = v.currentJoin;
                        ForkJoinTask<?> t = null;
                        ForkJoinTask<?>[] a = v.array;
                        if (v.array != null && (al = a.length) > 0 && (t = (ForkJoinTask<?>)U.getObjectVolatile(a, offset = ((long)(index = al - 1 & b) << ASHIFT) + (long)ABASE)) != null && b++ == v.base) {
                            if (j.currentJoin != subtask || v.currentSteal != subtask || subtask.status < 0) continue block0;
                            if (U.compareAndSwapObject(a, offset, t, null)) {
                                v.base = b;
                                w.currentSteal = t;
                                int top = w.top;
                                while (true) {
                                    t.doExec();
                                    w.currentSteal = ps;
                                    if (task.status < 0) break block0;
                                    if (w.top == top) break;
                                    t = w.pop();
                                    if (t == null) continue block0;
                                    w.currentSteal = t;
                                }
                            }
                        }
                        if (t != null || b != v.base || b - v.top < 0) continue;
                        subtask = next;
                        if (subtask == null) {
                            if (next != v.currentJoin || oldSum != (oldSum = checkSum)) continue block0;
                            break block0;
                        }
                        j = v;
                        continue block1;
                    }
                    continue block0;
                }
            }
        }
    }

    private boolean tryCompensate(WorkQueue w) {
        boolean canBlock;
        int wl;
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        int pc = this.config & 0xFFFF;
        int ac = pc + (int)(c >> 48);
        int tc = pc + (short)(c >> 32);
        if (w == null || w.qlock < 0 || pc == 0 || ws == null || (wl = ws.length) <= 0) {
            canBlock = false;
        } else {
            int m = wl - 1;
            boolean busy = true;
            for (int i = 0; i <= m; ++i) {
                WorkQueue v;
                int k = i << 1 | 1;
                if (k > m || k < 0 || (v = ws[k]) == null || v.scanState < 0 || v.currentSteal != null) continue;
                busy = false;
                break;
            }
            if (!busy || this.ctl != c) {
                canBlock = false;
            } else {
                int sp = (int)c;
                if (sp != 0) {
                    canBlock = this.tryRelease(c, ws[m & sp], 0L);
                } else if (tc >= pc && ac > 1 && w.isEmpty()) {
                    long nc = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFFFFFFFFFFL & c;
                    canBlock = U.compareAndSwapLong(this, CTL, c, nc);
                } else {
                    if (tc >= Short.MAX_VALUE || this == common && tc >= pc + COMMON_MAX_SPARES) {
                        throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
                    }
                    boolean isSpare = tc >= pc;
                    long nc = 0xFFFF000000000000L & c | 0xFFFF00000000L & c + 0x100000000L;
                    canBlock = U.compareAndSwapLong(this, CTL, c, nc) && this.createWorker(isSpare);
                }
            }
        }
        return canBlock;
    }

    final int awaitJoin(WorkQueue w, ForkJoinTask<?> task, long deadline) {
        int s = 0;
        if (w != null) {
            ForkJoinTask<?> prevJoin = w.currentJoin;
            if (task != null && (s = task.status) >= 0) {
                CountedCompleter cc;
                w.currentJoin = task;
                CountedCompleter countedCompleter = cc = task instanceof CountedCompleter ? (CountedCompleter)task : null;
                do {
                    long ms;
                    if (cc != null) {
                        this.helpComplete(w, cc, 0);
                    } else {
                        this.helpStealer(w, task);
                    }
                    s = task.status;
                    if (s < 0) break;
                    if (deadline == 0L) {
                        ms = 0L;
                    } else {
                        long ns = deadline - System.nanoTime();
                        if (ns <= 0L) break;
                        ms = TimeUnit.NANOSECONDS.toMillis(ns);
                        if (ms <= 0L) {
                            ms = 1L;
                        }
                    }
                    if (!this.tryCompensate(w)) continue;
                    task.internalWait(ms);
                    ForkJoinPool.getAndAddLong(this, CTL, 0x1000000000000L);
                } while ((s = task.status) >= 0);
                w.currentJoin = prevJoin;
            }
        }
        return s;
    }

    private WorkQueue findNonEmptyStealQueue() {
        int wl;
        int r = TLRandom.nextSecondarySeed();
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (wl = ws.length) > 0) {
            int origin;
            int m = wl - 1;
            int k = origin = r & m;
            int oldSum = 0;
            int checkSum = 0;
            while (true) {
                WorkQueue q;
                if ((q = ws[k]) != null) {
                    int b = q.base;
                    if (b - q.top < 0) {
                        return q;
                    }
                    checkSum += b;
                }
                if ((k = k + 1 & m) != origin) continue;
                if (oldSum == (oldSum = checkSum)) break;
                checkSum = 0;
            }
        }
        return null;
    }

    final void helpQuiescePool(WorkQueue w) {
        ForkJoinTask<?> ps = w.currentSteal;
        int wc = w.config;
        boolean active = true;
        while (true) {
            long c;
            ForkJoinTask<?> t;
            if (wc >= 0 && (t = w.pop()) != null) {
                w.currentSteal = t;
                w.currentSteal.doExec();
                w.currentSteal = ps;
                continue;
            }
            WorkQueue q = this.findNonEmptyStealQueue();
            if (q != null) {
                if (!active) {
                    active = true;
                    ForkJoinPool.getAndAddLong(this, CTL, 0x1000000000000L);
                }
                if ((t = q.pollAt(q.base)) == null) continue;
                w.currentSteal = t;
                w.currentSteal.doExec();
                w.currentSteal = ps;
                if (++w.nsteals >= 0) continue;
                w.transferStealCount(this);
                continue;
            }
            if (active) {
                c = this.ctl;
                long nc = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFFFFFFFFFFL & c;
                if (!U.compareAndSwapLong(this, CTL, c, nc)) continue;
                active = false;
                continue;
            }
            c = this.ctl;
            if ((int)(c >> 48) + (this.config & 0xFFFF) <= 0 && U.compareAndSwapLong(this, CTL, c, c + 0x1000000000000L)) break;
        }
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue w) {
        WorkQueue q;
        ForkJoinTask<?> t;
        do {
            if ((t = w.nextLocalTask()) != null) {
                return t;
            }
            q = this.findNonEmptyStealQueue();
            if (q != null) continue;
            return null;
        } while ((t = q.pollAt(q.base)) == null);
        return t;
    }

    static int getSurplusQueuedTaskCount() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool pool = wt.pool;
            int p = pool.config & 0xFFFF;
            WorkQueue q = wt.workQueue;
            int n = q.top - q.base;
            int a = (int)(pool.ctl >> 48) + p;
            return n - (a > (p >>>= 1) ? 0 : (a > (p >>>= 1) ? 1 : (a > (p >>>= 1) ? 2 : (a > (p >>>= 1) ? 4 : 8))));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryTerminate(boolean now, boolean enable) {
        WorkQueue w;
        int i;
        WorkQueue[] ws;
        long checkSum;
        long oldSum;
        int rs;
        while ((rs = this.runState) >= 0) {
            if (!enable || this == common) {
                return 1;
            }
            if (rs == 0) {
                this.tryInitialize(false);
                continue;
            }
            U.compareAndSwapInt(this, RUNSTATE, rs, rs | Integer.MIN_VALUE);
        }
        if ((rs & 2) == 0) {
            if (!now) {
                oldSum = 0L;
                do {
                    if ((int)((checkSum = this.ctl) >> 48) + (this.config & 0xFFFF) > 0) {
                        return 0;
                    }
                    ws = this.workQueues;
                    if (this.workQueues == null) continue;
                    for (i = 0; i < ws.length; ++i) {
                        w = ws[i];
                        if (w == null) continue;
                        int b = w.base;
                        checkSum += (long)b;
                        if (w.currentSteal == null && b == w.top) continue;
                        return 0;
                    }
                } while (oldSum != (oldSum = checkSum));
            }
            while (!U.compareAndSwapInt(this, RUNSTATE, rs = this.runState, rs | 2)) {
            }
        }
        oldSum = 0L;
        do {
            checkSum = this.ctl;
            ws = this.workQueues;
            if (this.workQueues == null) continue;
            for (i = 0; i < ws.length; ++i) {
                w = ws[i];
                if (w == null) continue;
                w.cancelAll();
                checkSum += (long)w.base;
                if (w.qlock < 0) continue;
                w.qlock = -1;
                ForkJoinWorkerThread wt = w.owner;
                if (wt == null) continue;
                try {
                    wt.interrupt();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        } while (oldSum != (oldSum = checkSum));
        if ((short)(this.ctl >>> 32) + (this.config & 0xFFFF) <= 0) {
            this.runState = -2147483641;
            ForkJoinPool forkJoinPool = this;
            synchronized (forkJoinPool) {
                this.notifyAll();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCreateExternalQueue(int index) {
        AuxState aux = this.auxState;
        if (aux != null && index >= 0) {
            WorkQueue q = new WorkQueue(this, null);
            q.config = index;
            q.scanState = Integer.MAX_VALUE;
            q.qlock = 1;
            boolean installed = false;
            aux.lock();
            try {
                WorkQueue[] ws = this.workQueues;
                if (this.workQueues != null && index < ws.length && ws[index] == null) {
                    ws[index] = q;
                    installed = true;
                }
            }
            finally {
                aux.unlock();
            }
            if (installed) {
                try {
                    q.growArray();
                }
                finally {
                    q.qlock = 0;
                }
            }
        }
    }

    final void externalPush(ForkJoinTask<?> task) {
        int r = TLRandom.getProbe();
        if (r == 0) {
            TLRandom.localInit();
            r = TLRandom.getProbe();
        }
        while (true) {
            int wl;
            int rs = this.runState;
            WorkQueue[] ws = this.workQueues;
            if (rs <= 0 || ws == null || (wl = ws.length) <= 0) {
                this.tryInitialize(true);
                continue;
            }
            int k = wl - 1 & r & 0x7E;
            WorkQueue q = ws[k];
            if (q == null) {
                this.tryCreateExternalQueue(k);
                continue;
            }
            int stat = q.sharedPush(task);
            if (stat < 0) break;
            if (stat == 0) {
                this.signalWork();
                break;
            }
            r = TLRandom.advanceProbe(r);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> ForkJoinTask<T> externalSubmit(ForkJoinTask<T> task) {
        Objects.requireNonNull(task);
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            WorkQueue q;
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            if (w.pool == this && (q = w.workQueue) != null) {
                q.push(task);
                return task;
            }
        }
        this.externalPush(task);
        return task;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WorkQueue commonSubmitterQueue() {
        ForkJoinPool p = common;
        int r = TLRandom.getProbe();
        if (p == null) return null;
        WorkQueue[] ws = p.workQueues;
        if (p.workQueues == null) return null;
        int wl = ws.length;
        if (wl <= 0) return null;
        WorkQueue workQueue = ws[wl - 1 & r & 0x7E];
        return workQueue;
    }

    final boolean tryExternalUnpush(ForkJoinTask<?> task) {
        WorkQueue w;
        int wl;
        int r = TLRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        return this.workQueues != null && (wl = ws.length) > 0 && (w = ws[wl - 1 & r & 0x7E]) != null && w.trySharedUnpush(task);
    }

    final int externalHelpComplete(CountedCompleter<?> task, int maxTasks) {
        int wl;
        int r = TLRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        return this.workQueues != null && (wl = ws.length) > 0 ? this.helpComplete(ws[wl - 1 & r & 0x7E], task, maxTasks) : 0;
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        this(ForkJoinPool.checkParallelism(parallelism), ForkJoinPool.checkFactory(factory), handler, asyncMode ? Integer.MIN_VALUE : 0, "ForkJoinPool-" + ForkJoinPool.nextPoolId() + "-worker-");
        ForkJoinPool.checkPermission();
    }

    private static int checkParallelism(int parallelism) {
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return parallelism;
    }

    private static ForkJoinWorkerThreadFactory checkFactory(ForkJoinWorkerThreadFactory factory) {
        return Objects.requireNonNull(factory);
    }

    private ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, int mode, String workerNamePrefix) {
        this.workerNamePrefix = workerNamePrefix;
        this.factory = factory;
        this.ueh = handler;
        this.config = parallelism & 0xFFFF | mode;
        long np = -parallelism;
        this.ctl = np << 48 & 0xFFFF000000000000L | np << 32 & 0xFFFF00000000L;
    }

    public static ForkJoinPool commonPool() {
        return common;
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        this.externalSubmit(Objects.requireNonNull(task));
        return task.join();
    }

    public void execute(ForkJoinTask<?> task) {
        this.externalSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        Objects.requireNonNull(task);
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.RunnableExecuteAction(task);
        this.externalSubmit(job);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        return this.externalSubmit(task);
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        return this.externalSubmit(new ForkJoinTask.AdaptedCallable<T>(task));
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        return this.externalSubmit(new ForkJoinTask.AdaptedRunnable<T>(task, result));
    }

    public ForkJoinTask<?> submit(Runnable task) {
        Objects.requireNonNull(task);
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task);
        return this.externalSubmit(job);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        try {
            for (Callable<T> t : tasks) {
                ForkJoinTask.AdaptedCallable<T> f = new ForkJoinTask.AdaptedCallable<T>(t);
                futures.add(f);
                this.externalSubmit(f);
            }
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ((ForkJoinTask)futures.get(i)).quietlyJoin();
            }
            return futures;
        }
        catch (Throwable t) {
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ((Future)futures.get(i)).cancel(false);
            }
            throw t;
        }
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        int par = this.config & 0xFFFF;
        return par > 0 ? par : 1;
    }

    public static int getCommonPoolParallelism() {
        return COMMON_PARALLELISM;
    }

    public int getPoolSize() {
        return (this.config & 0xFFFF) + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return (this.config & Integer.MIN_VALUE) != 0;
    }

    public int getRunningThreadCount() {
        int rc = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || !w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        return rc;
    }

    public int getActiveThreadCount() {
        int r = (this.config & 0xFFFF) + (int)(this.ctl >> 48);
        return r <= 0 ? 0 : r;
    }

    public boolean isQuiescent() {
        return (this.config & 0xFFFF) + (int)(this.ctl >> 48) <= 0;
    }

    public long getStealCount() {
        AuxState sc = this.auxState;
        long count = sc == null ? 0L : sc.stealCount;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += (long)w.nsteals;
            }
        }
        return count;
    }

    public long getQueuedTaskCount() {
        long count = 0L;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += (long)w.queueSize();
            }
        }
        return count;
    }

    public int getQueuedSubmissionCount() {
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += w.queueSize();
            }
        }
        return count;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || w.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        int wl;
        int r = TLRandom.nextSecondarySeed();
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (wl = ws.length) > 0) {
            int m = wl - 1;
            for (int i = 0; i < wl; ++i) {
                ForkJoinTask<?> t;
                WorkQueue w = ws[i << 1 & m];
                if (w == null || (t = w.poll()) == null) continue;
                return t;
            }
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinTask<?> t;
                WorkQueue w = ws[i];
                if (w == null) continue;
                while ((t = w.poll()) != null) {
                    c.add(t);
                    ++count;
                }
            }
        }
        return count;
    }

    public String toString() {
        int rs;
        long qt = 0L;
        long qs = 0L;
        int rc = 0;
        AuxState sc = this.auxState;
        long st = sc == null ? 0L : sc.stealCount;
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                int size = w.queueSize();
                if ((i & 1) == 0) {
                    qs += (long)size;
                    continue;
                }
                qt += (long)size;
                st += (long)w.nsteals;
                if (!w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        int pc = this.config & 0xFFFF;
        int tc = pc + (short)(c >>> 32);
        int ac = pc + (int)(c >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = ((rs = this.runState) & 4) != 0 ? "Terminated" : ((rs & 2) != 0 ? "Terminating" : ((rs & Integer.MIN_VALUE) != 0 ? "Shutting down" : "Running"));
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return (this.runState & 4) != 0;
    }

    public boolean isTerminating() {
        int rs = this.runState;
        return (rs & 2) != 0 && (rs & 4) == 0;
    }

    @Override
    public boolean isShutdown() {
        return (this.runState & Integer.MIN_VALUE) != 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(timeout, unit);
            return false;
        }
        long nanos = unit.toNanos(timeout);
        if (this.isTerminated()) {
            return true;
        }
        if (nanos <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + nanos;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            while (true) {
                if (this.isTerminated()) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
                this.wait(millis > 0L ? millis : 1L);
                nanos = deadline - System.nanoTime();
            }
        }
    }

    public boolean awaitQuiescence(long timeout, TimeUnit unit) {
        long nanos = unit.toNanos(timeout);
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)thread;
            if (wt.pool == this) {
                this.helpQuiescePool(wt.workQueue);
                return true;
            }
        }
        long startTime = System.nanoTime();
        int r = 0;
        boolean found = true;
        block0: while (!this.isQuiescent()) {
            int wl;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (wl = ws.length) <= 0) break;
            if (!found) {
                if (System.nanoTime() - startTime > nanos) {
                    return false;
                }
                Thread.yield();
            }
            found = false;
            int m = wl - 1;
            for (int j = m + 1 << 2; j >= 0; --j) {
                int b;
                WorkQueue q;
                int k;
                if ((k = r++ & m) > m || k < 0 || (q = ws[k]) == null || (b = q.base) - q.top >= 0) continue;
                found = true;
                ForkJoinTask<?> t = q.pollAt(b);
                if (t == null) continue block0;
                t.doExec();
                continue block0;
            }
        }
        return true;
    }

    static void quiesceCommonPool() {
        common.awaitQuiescence(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool p = wt.pool;
            if (p != null) {
                WorkQueue w = wt.workQueue;
                while (!blocker.isReleasable()) {
                    if (!p.tryCompensate(w)) continue;
                    try {
                        while (!blocker.isReleasable() && !blocker.block()) {
                        }
                        return;
                    }
                    finally {
                        ForkJoinPool.getAndAddLong(p, CTL, 0x1000000000000L);
                    }
                }
                return;
            }
        }
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    static ForkJoinPool makeCommonPool() {
        int parallelism = -1;
        ForkJoinWorkerThreadFactory factory = null;
        Thread.UncaughtExceptionHandler handler = null;
        try {
            String pp = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            String fp = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            String hp = System.getProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
            if (pp != null) {
                parallelism = Integer.parseInt(pp);
            }
            if (fp != null) {
                factory = (ForkJoinWorkerThreadFactory)ClassLoader.getSystemClassLoader().loadClass(fp).newInstance();
            }
            if (hp != null) {
                handler = (Thread.UncaughtExceptionHandler)ClassLoader.getSystemClassLoader().loadClass(hp).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (factory == null) {
            factory = System.getSecurityManager() == null ? defaultForkJoinWorkerThreadFactory : new InnocuousForkJoinWorkerThreadFactory();
        }
        if (parallelism < 0 && (parallelism = Runtime.getRuntime().availableProcessors() - 1) <= 0) {
            parallelism = 1;
        }
        if (parallelism > Short.MAX_VALUE) {
            parallelism = Short.MAX_VALUE;
        }
        return new ForkJoinPool(parallelism, factory, handler, 0, "ForkJoinPool.commonPool-worker-");
    }

    static {
        U = UnsafeAccess.unsafe;
        try {
            CTL = U.objectFieldOffset(ForkJoinPool.class.getDeclaredField("ctl"));
            RUNSTATE = U.objectFieldOffset(ForkJoinPool.class.getDeclaredField("runState"));
            ABASE = U.arrayBaseOffset(ForkJoinTask[].class);
            int scale = U.arrayIndexScale(ForkJoinTask[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("array index scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        int commonMaxSpares = 256;
        try {
            String p = System.getProperty("java.util.concurrent.ForkJoinPool.common.maximumSpares");
            if (p != null) {
                commonMaxSpares = Integer.parseInt(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMMON_MAX_SPARES = commonMaxSpares;
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        common = AccessController.doPrivileged(new PrivilegedAction<ForkJoinPool>(){

            @Override
            public ForkJoinPool run() {
                return ForkJoinPool.makeCommonPool();
            }
        });
        COMMON_PARALLELISM = Math.max(ForkJoinPool.common.config & 0xFFFF, 1);
    }

    static final class MemBar {
        private static final AtomicInteger x = new AtomicInteger();
        private static final Unsafe U = UnsafeAccess.unsafe;
        private static final long OFF;

        static void loadFence() {
            U.getIntVolatile(x, OFF);
        }

        static void storeFence() {
            U.putOrderedInt(x, OFF, 0);
        }

        static void fullFence() {
            U.putIntVolatile(x, OFF, 0);
        }

        private MemBar() {
        }

        static {
            try {
                OFF = U.objectFieldOffset(AtomicInteger.class.getDeclaredField("value"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    private static final class InnocuousForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext innocuousAcc;

        private InnocuousForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool pool) {
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread.InnocuousForkJoinWorkerThread(pool);
                }
            }, innocuousAcc);
        }

        static {
            Permissions innocuousPerms = new Permissions();
            innocuousPerms.add(modifyThreadPermission);
            innocuousPerms.add(new RuntimePermission("enableContextClassLoaderOverride"));
            innocuousPerms.add(new RuntimePermission("modifyThreadGroup"));
            innocuousAcc = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, innocuousPerms)});
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile int scanState;
        int stackPred;
        int nsteals;
        int hint;
        int config;
        volatile int qlock;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        volatile ForkJoinTask<?> currentJoin;
        volatile ForkJoinTask<?> currentSteal;
        private static final Unsafe U = UnsafeAccess.unsafe;
        private static final long QLOCK;
        private static final int ABASE;
        private static final int ASHIFT;

        WorkQueue(ForkJoinPool pool, ForkJoinWorkerThread owner) {
            this.pool = pool;
            this.owner = owner;
            this.top = 4096;
            this.base = 4096;
        }

        final int getPoolIndex() {
            return (this.config & 0xFFFF) >>> 1;
        }

        final int queueSize() {
            int n = this.base - this.top;
            return n >= 0 ? 0 : -n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int s = this.top;
            int n = this.base - s;
            if (n >= 0) return true;
            if (n != -1) return false;
            ForkJoinTask<?>[] a = this.array;
            if (this.array == null) return true;
            int al = a.length;
            if (al == 0) return true;
            if (a[al - 1 & s - 1] != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> task) {
            int al;
            MemBar.storeFence();
            int s = this.top;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (al = a.length) > 0) {
                a[al - 1 & s] = task;
                this.top = s + 1;
                ForkJoinPool p = this.pool;
                int d = this.base - s;
                if (d == 0 && p != null) {
                    MemBar.fullFence();
                    p.signalWork();
                } else if (al + d == 1) {
                    this.growArray();
                }
            }
        }

        final ForkJoinTask<?>[] growArray() {
            int b;
            int t;
            int oldMask;
            int size;
            ForkJoinTask<?>[] oldA = this.array;
            int n = size = oldA != null ? oldA.length << 1 : 8192;
            if (size < 8192 || size > 0x4000000) {
                throw new RejectedExecutionException("Queue capacity exceeded");
            }
            this.array = new ForkJoinTask[size];
            ForkJoinTask[] a = this.array;
            if (oldA != null && (oldMask = oldA.length - 1) > 0 && (t = this.top) - (b = this.base) > 0) {
                int mask = size - 1;
                do {
                    int index;
                    long offset;
                    ForkJoinTask x;
                    if ((x = (ForkJoinTask)U.getObjectVolatile(oldA, offset = ((long)(index = b & oldMask) << ASHIFT) + (long)ABASE)) == null || !U.compareAndSwapObject(oldA, offset, x, null)) continue;
                    a[b & mask] = x;
                } while (++b != t);
                MemBar.storeFence();
            }
            return a;
        }

        final ForkJoinTask<?> pop() {
            int index;
            long offset;
            ForkJoinTask t;
            int al;
            int b = this.base;
            int s = this.top;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && b != s && (al = a.length) > 0 && (t = (ForkJoinTask)U.getObject(a, offset = ((long)(index = al - 1 & --s) << ASHIFT) + (long)ABASE)) != null && U.compareAndSwapObject(a, offset, t, null)) {
                this.top = s;
                return t;
            }
            return null;
        }

        final ForkJoinTask<?> pollAt(int b) {
            int index;
            long offset;
            ForkJoinTask t;
            int al;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (al = a.length) > 0 && (t = (ForkJoinTask)U.getObjectVolatile(a, offset = ((long)(index = al - 1 & b) << ASHIFT) + (long)ABASE)) != null && b++ == this.base && U.compareAndSwapObject(a, offset, t, null)) {
                this.base = b;
                return t;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final ForkJoinTask<?> poll() {
            while (true) {
                int al;
                int d;
                int b = this.base;
                int s = this.top;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || (d = b - s) >= 0 || (al = a.length) <= 0) return null;
                int index = al - 1 & b;
                long offset = ((long)index << ASHIFT) + (long)ABASE;
                ForkJoinTask t = (ForkJoinTask)U.getObjectVolatile(a, offset);
                if (b++ != this.base) continue;
                if (t != null) {
                    if (!U.compareAndSwapObject(a, offset, t, null)) continue;
                    this.base = b;
                    return t;
                }
                if (d == -1) return null;
            }
        }

        final ForkJoinTask<?> nextLocalTask() {
            return this.config < 0 ? this.poll() : this.pop();
        }

        final ForkJoinTask<?> peek() {
            int al;
            ForkJoinTask<?>[] a = this.array;
            return this.array != null && (al = a.length) > 0 ? a[al - 1 & (this.config < 0 ? this.base : this.top - 1)] : null;
        }

        final boolean tryUnpush(ForkJoinTask<?> task) {
            int index;
            long offset;
            int al;
            int b = this.base;
            int s = this.top;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && b != s && (al = a.length) > 0 && U.compareAndSwapObject(a, offset = ((long)(index = al - 1 & --s) << ASHIFT) + (long)ABASE, task, null)) {
                this.top = s;
                return true;
            }
            return false;
        }

        final int sharedPush(ForkJoinTask<?> task) {
            int stat;
            if (U.compareAndSwapInt(this, QLOCK, 0, 1)) {
                int d;
                int al;
                int b = this.base;
                int s = this.top;
                ForkJoinTask<?>[] a = this.array;
                if (this.array != null && (al = a.length) > 0 && al - 1 + (d = b - s) > 0) {
                    a[al - 1 & s] = task;
                    this.top = s + 1;
                    this.qlock = 0;
                    stat = d < 0 && b == this.base ? d : 0;
                } else {
                    this.growAndSharedPush(task);
                    stat = 0;
                }
            } else {
                stat = 1;
            }
            return stat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void growAndSharedPush(ForkJoinTask<?> task) {
            try {
                int al;
                this.growArray();
                int s = this.top;
                ForkJoinTask<?>[] a = this.array;
                if (this.array != null && (al = a.length) > 0) {
                    a[al - 1 & s] = task;
                    this.top = s + 1;
                }
            }
            finally {
                this.qlock = 0;
            }
        }

        final boolean trySharedUnpush(ForkJoinTask<?> task) {
            int index;
            long offset;
            ForkJoinTask t;
            int al;
            boolean popped = false;
            int s = this.top - 1;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (al = a.length) > 0 && (t = (ForkJoinTask)U.getObject(a, offset = ((long)(index = al - 1 & s) << ASHIFT) + (long)ABASE)) == task && U.compareAndSwapInt(this, QLOCK, 0, 1)) {
                if (U.compareAndSwapObject(a, offset, task, null)) {
                    popped = true;
                    this.top = s;
                }
                U.putOrderedInt(this, QLOCK, 0);
            }
            return popped;
        }

        final void cancelAll() {
            ForkJoinTask<?> t = this.currentJoin;
            if (t != null) {
                this.currentJoin = null;
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
            if ((t = this.currentSteal) != null) {
                this.currentSteal = null;
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
            while ((t = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
        }

        private static Object getAndSetObject(Object o, long offset, Object newValue) {
            Object v;
            while (!U.compareAndSwapObject(o, offset, v = U.getObjectVolatile(o, offset), newValue)) {
            }
            return v;
        }

        final void localPopAndExec() {
            int nexec = 0;
            do {
                int index;
                long offset;
                ForkJoinTask t;
                int al;
                int b = this.base;
                int s = this.top;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || b == s || (al = a.length) <= 0 || (t = (ForkJoinTask)WorkQueue.getAndSetObject(a, offset = ((long)(index = al - 1 & --s) << ASHIFT) + (long)ABASE, null)) == null) break;
                this.top = s;
                this.currentSteal = t;
                this.currentSteal.doExec();
            } while (++nexec <= 1023);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void localPollAndExec() {
            int nexec = 0;
            while (true) {
                int index;
                long offset;
                ForkJoinTask t;
                int al;
                int b = this.base;
                int s = this.top;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || b == s || (al = a.length) <= 0) return;
                if ((t = (ForkJoinTask)WorkQueue.getAndSetObject(a, offset = ((long)(index = al - 1 & b++) << ASHIFT) + (long)ABASE, null)) == null) continue;
                this.base = b;
                t.doExec();
                if (++nexec > 1023) return;
            }
        }

        final void runTask(ForkJoinTask<?> task) {
            if (task != null) {
                task.doExec();
                if (this.config < 0) {
                    this.localPollAndExec();
                } else {
                    this.localPopAndExec();
                }
                int ns = ++this.nsteals;
                ForkJoinWorkerThread thread = this.owner;
                this.currentSteal = null;
                if (ns < 0) {
                    this.transferStealCount(this.pool);
                }
                if (thread != null) {
                    thread.afterTopLevelExec();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void transferStealCount(ForkJoinPool p) {
            AuxState aux;
            if (p != null && (aux = p.auxState) != null) {
                long s = this.nsteals;
                this.nsteals = 0;
                if (s < 0L) {
                    s = Integer.MAX_VALUE;
                }
                aux.lock();
                try {
                    aux.stealCount += s;
                }
                finally {
                    aux.unlock();
                }
            }
        }

        final boolean tryRemoveAndExec(ForkJoinTask<?> task) {
            if (task != null && task.status >= 0) {
                int s;
                int b;
                int d;
                while ((d = (b = this.base) - (s = this.top)) < 0) {
                    int index;
                    long offset;
                    ForkJoinTask t;
                    int al;
                    ForkJoinTask<?>[] a = this.array;
                    if (this.array == null || (al = a.length) <= 0) break;
                    while ((t = (ForkJoinTask)U.getObjectVolatile(a, offset = (long)(((index = --s & al - 1) << ASHIFT) + ABASE))) != null) {
                        if (t == task) {
                            boolean removed = false;
                            if (s + 1 == this.top) {
                                if (U.compareAndSwapObject(a, offset, t, null)) {
                                    this.top = s;
                                    removed = true;
                                }
                            } else if (this.base == b) {
                                removed = U.compareAndSwapObject(a, offset, t, new EmptyTask());
                            }
                            if (!removed) break;
                            ForkJoinTask<?> ps = this.currentSteal;
                            this.currentSteal = task;
                            this.currentSteal.doExec();
                            this.currentSteal = ps;
                            break;
                        }
                        if (t.status < 0 && s + 1 == this.top) {
                            if (!U.compareAndSwapObject(a, offset, t, null)) break;
                            this.top = s;
                            break;
                        }
                        if (++d != 0) continue;
                        if (this.base != b) break;
                        return false;
                    }
                    if (task.status >= 0) continue;
                    return false;
                }
            }
            return true;
        }

        final CountedCompleter<?> popCC(CountedCompleter<?> task, int mode) {
            block7: {
                CountedCompleter<?> t;
                int index;
                long offset;
                ForkJoinTask o;
                int al;
                int b = this.base;
                int s = this.top;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || b == s || (al = a.length) <= 0 || !((o = (ForkJoinTask)U.getObjectVolatile(a, offset = ((long)(index = al - 1 & s - 1) << ASHIFT) + (long)ABASE)) instanceof CountedCompleter)) break block7;
                CountedCompleter<?> r = t = (CountedCompleter<?>)o;
                do {
                    if (r != task) continue;
                    if ((mode & 1) == 0) {
                        if (U.compareAndSwapInt(this, QLOCK, 0, 1)) {
                            boolean popped = U.compareAndSwapObject(a, offset, t, null);
                            if (popped) {
                                this.top = s - 1;
                            }
                            U.putOrderedInt(this, QLOCK, 0);
                            if (popped) {
                                return t;
                            }
                        }
                    } else if (U.compareAndSwapObject(a, offset, t, null)) {
                        this.top = s - 1;
                        return t;
                    }
                    break;
                } while ((r = r.completer) != null);
            }
            return null;
        }

        final int pollAndExecCC(CountedCompleter<?> task) {
            int h;
            block9: {
                int al;
                int b = this.base;
                int s = this.top;
                ForkJoinTask<?>[] a = this.array;
                if (this.array != null && b != s && (al = a.length) > 0) {
                    int index = al - 1 & b;
                    long offset = ((long)index << ASHIFT) + (long)ABASE;
                    ForkJoinTask o = (ForkJoinTask)U.getObjectVolatile(a, offset);
                    if (o == null) {
                        h = 2;
                    } else if (!(o instanceof CountedCompleter)) {
                        h = -1;
                    } else {
                        CountedCompleter<?> t;
                        CountedCompleter<?> r = t = (CountedCompleter<?>)o;
                        do {
                            if (r != task) continue;
                            if (b++ == this.base && U.compareAndSwapObject(a, offset, t, null)) {
                                this.base = b;
                                t.doExec();
                                h = 1;
                            } else {
                                h = 2;
                            }
                            break block9;
                        } while ((r = r.completer) != null);
                        h = -1;
                    }
                } else {
                    h = b | Integer.MIN_VALUE;
                }
            }
            return h;
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s;
            ForkJoinWorkerThread wt;
            return this.scanState >= 0 && (wt = this.owner) != null && (s = wt.getState()) != Thread.State.BLOCKED && s != Thread.State.WAITING && s != Thread.State.TIMED_WAITING;
        }

        static {
            try {
                QLOCK = U.objectFieldOffset(WorkQueue.class.getDeclaredField("qlock"));
                ABASE = U.arrayBaseOffset(ForkJoinTask[].class);
                int scale = U.arrayIndexScale(ForkJoinTask[].class);
                if ((scale & scale - 1) != 0) {
                    throw new Error("array index scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    private static final class AuxState
    extends ReentrantLock {
        private static final long serialVersionUID = -6001602636862214147L;
        volatile long stealCount;
        long indexSeed;

        AuxState() {
        }
    }

    private static final class EmptyTask
    extends ForkJoinTask<Void> {
        private static final long serialVersionUID = -7721805057305804111L;

        EmptyTask() {
            this.status = -268435456;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void x) {
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    private static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

