/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent;

import java.security.AccessControlContext;
import java.security.ProtectionDomain;
import java8.util.concurrent.ForkJoinPool;
import java8.util.concurrent.UnsafeAccess;
import sun.misc.Unsafe;

public class ForkJoinWorkerThread
extends Thread {
    private static final String NAME_PLACEHOLDER = "aForkJoinWorkerThread";
    final ForkJoinPool pool;
    final ForkJoinPool.WorkQueue workQueue;
    private static final Unsafe U = UnsafeAccess.unsafe;
    static final boolean IS_PRE8_IBM;
    private static final long THREADLOCALS;
    private static final long INHERITABLETHREADLOCALS;
    private static final long INHERITEDACCESSCONTROLCONTEXT;

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        super(NAME_PLACEHOLDER);
        this.pool = pool;
        this.workQueue = pool.registerWorker(this);
    }

    ForkJoinWorkerThread(ForkJoinPool pool, ThreadGroup threadGroup, AccessControlContext acc) {
        super(threadGroup, NAME_PLACEHOLDER);
        U.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, acc);
        this.eraseThreadLocals();
        this.pool = pool;
        this.workQueue = pool.registerWorker(this);
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.workQueue.getPoolIndex();
    }

    protected void onStart() {
    }

    protected void onTermination(Throwable exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.workQueue.array == null) {
            Throwable exception = null;
            try {
                this.onStart();
                this.pool.runWorker(this.workQueue);
            }
            catch (Throwable ex) {
                exception = ex;
            }
            finally {
                try {
                    this.onTermination(exception);
                }
                catch (Throwable ex) {
                    if (exception == null) {
                        exception = ex;
                    }
                }
                finally {
                    this.pool.deregisterWorker(this, exception);
                }
            }
        }
    }

    final void eraseThreadLocals() {
        U.putObject(this, THREADLOCALS, null);
        U.putObject(this, INHERITABLETHREADLOCALS, null);
    }

    void afterTopLevelExec() {
    }

    private static boolean isAndroid() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("android.util.DisplayMetrics");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz != null;
    }

    private static boolean isIBMPre8() {
        String ver;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.misc.JarVersion");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz != null && (ver = System.getProperty("java.class.version", "45")) != null && ver.length() >= 2 && "52".compareTo(ver = ver.substring(0, 2)) > 0;
    }

    static {
        try {
            IS_PRE8_IBM = ForkJoinWorkerThread.isIBMPre8();
            if (!ForkJoinWorkerThread.isAndroid()) {
                THREADLOCALS = U.objectFieldOffset(Thread.class.getDeclaredField("threadLocals"));
                INHERITABLETHREADLOCALS = U.objectFieldOffset(Thread.class.getDeclaredField("inheritableThreadLocals"));
                String accFieldName = IS_PRE8_IBM ? "accessControlContext" : "inheritedAccessControlContext";
                INHERITEDACCESSCONTROLCONTEXT = U.objectFieldOffset(Thread.class.getDeclaredField(accFieldName));
            } else {
                THREADLOCALS = 0L;
                INHERITABLETHREADLOCALS = 0L;
                INHERITEDACCESSCONTROLCONTEXT = 0L;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class InnocuousForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private static final ThreadGroup innocuousThreadGroup = InnocuousForkJoinWorkerThread.createThreadGroup();
        private static final AccessControlContext INNOCUOUS_ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});

        InnocuousForkJoinWorkerThread(ForkJoinPool pool) {
            super(pool, innocuousThreadGroup, INNOCUOUS_ACC);
        }

        @Override
        void afterTopLevelExec() {
            this.eraseThreadLocals();
        }

        @Override
        public ClassLoader getContextClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }

        @Override
        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler x) {
        }

        @Override
        public void setContextClassLoader(ClassLoader cl) {
            throw new SecurityException("setContextClassLoader");
        }

        private static ThreadGroup createThreadGroup() {
            try {
                Unsafe u = UnsafeAccess.unsafe;
                String groupFieldName = IS_PRE8_IBM ? "threadGroup" : "group";
                long tg = u.objectFieldOffset(Thread.class.getDeclaredField(groupFieldName));
                long gp = u.objectFieldOffset(ThreadGroup.class.getDeclaredField("parent"));
                ThreadGroup group = (ThreadGroup)u.getObject(Thread.currentThread(), tg);
                while (group != null) {
                    ThreadGroup parent = (ThreadGroup)u.getObject(group, gp);
                    if (parent == null) {
                        return new ThreadGroup(group, "InnocuousForkJoinWorkerThreadGroup");
                    }
                    group = parent;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
            throw new Error("Cannot create ThreadGroup");
        }
    }
}

