/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java8.util.concurrent.UnsafeAccess;
import sun.misc.Unsafe;

final class TLRandom {
    private static final AtomicInteger probeGenerator = new AtomicInteger();
    private static final AtomicLong seeder = new AtomicLong(TLRandom.initialSeed());
    private static final long GAMMA = -7046029254386353131L;
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final ThreadLocal<SeedsHolder> localSeeds = new ThreadLocal<SeedsHolder>(){

        @Override
        protected SeedsHolder initialValue() {
            return new SeedsHolder();
        }
    };
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long VALUE_OFF;

    private static long initialSeed() {
        String pp = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.util.secureRandomSeed");
            }
        });
        if (pp != null && pp.equalsIgnoreCase("true")) {
            byte[] seedBytes = SecureRandom.getSeed(8);
            long s = (long)seedBytes[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                s = s << 8 | (long)seedBytes[i] & 0xFFL;
            }
            return s;
        }
        return TLRandom.mix64(System.currentTimeMillis()) ^ TLRandom.mix64(System.nanoTime());
    }

    static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    static int mix32(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        return (int)((z ^ z >>> 33) * -4265267296055464877L >>> 32);
    }

    private TLRandom() {
    }

    static final void localInit() {
        int p = probeGenerator.addAndGet(-1640531527);
        int probe = p == 0 ? 1 : p;
        long seed = TLRandom.mix64(seeder.getAndAdd(-4942790177534073029L));
        TLRandom.setThreadLocalRandomSeed(seed);
        TLRandom.setThreadLocalRandomProbe(probe);
    }

    static final long nextSeed() {
        long r = TLRandom.getThreadLocalRandomSeed() + -7046029254386353131L;
        TLRandom.setThreadLocalRandomSeed(r);
        return r;
    }

    static final int getProbe() {
        return TLRandom.getThreadLocalRandomProbe();
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        TLRandom.setThreadLocalRandomProbe(probe);
        return probe;
    }

    static final int nextSecondarySeed() {
        int r = TLRandom.getThreadLocalRandomSecondarySeed();
        if (r != 0) {
            r ^= r << 13;
            r ^= r >>> 17;
            r ^= r << 5;
        } else {
            r = TLRandom.mix32(seeder.getAndAdd(-4942790177534073029L));
            if (r == 0) {
                r = 1;
            }
        }
        TLRandom.setThreadLocalRandomSecondarySeed(r);
        return r;
    }

    static long getThreadLocalRandomSeed() {
        return TLRandom.localSeeds.get().threadSeed;
    }

    private static void setThreadLocalRandomSeed(long seed) {
        TLRandom.localSeeds.get().threadSeed = seed;
    }

    static int getThreadLocalRandomProbe() {
        return TLRandom.localSeeds.get().threadProbe;
    }

    private static void setThreadLocalRandomProbe(int probe) {
        TLRandom.localSeeds.get().threadProbe = probe;
    }

    private static int getThreadLocalRandomSecondarySeed() {
        return TLRandom.localSeeds.get().threadSecondarySeed;
    }

    private static void setThreadLocalRandomSecondarySeed(int secondary) {
        TLRandom.localSeeds.get().threadSecondarySeed = secondary;
    }

    private static void setUncontendedToTrue(Integer isUncontended) {
        U.putInt(isUncontended, VALUE_OFF, 1);
    }

    private static int getInitializedProbe(Integer uncontended) {
        int p = TLRandom.getThreadLocalRandomProbe();
        if (p == 0) {
            TLRandom.localInit();
            p = TLRandom.getThreadLocalRandomProbe();
            TLRandom.setUncontendedToTrue(uncontended);
        }
        return p;
    }

    static {
        try {
            VALUE_OFF = U.objectFieldOffset(Integer.class.getDeclaredField("value"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static final class SeedsHolder {
        long threadSeed;
        int threadProbe;
        int threadSecondarySeed;

        private SeedsHolder() {
        }
    }
}

