/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.Optional;
import java8.util.OptionalDouble;
import java8.util.OptionalInt;
import java8.util.OptionalLong;
import java8.util.Spliterator;
import java8.util.concurrent.CountedCompleter;
import java8.util.function.Predicate;
import java8.util.function.Supplier;
import java8.util.stream.AbstractShortCircuitTask;
import java8.util.stream.FindOps$$Lambda$1;
import java8.util.stream.FindOps$$Lambda$2;
import java8.util.stream.FindOps$$Lambda$3;
import java8.util.stream.FindOps$$Lambda$4;
import java8.util.stream.FindOps$$Lambda$5;
import java8.util.stream.FindOps$$Lambda$6;
import java8.util.stream.FindOps$$Lambda$7;
import java8.util.stream.FindOps$$Lambda$8;
import java8.util.stream.PipelineHelper;
import java8.util.stream.Sink;
import java8.util.stream.SinkDefaults;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamShape;
import java8.util.stream.TerminalOp;
import java8.util.stream.TerminalSink;

final class FindOps {
    private FindOps() {
    }

    public static <T> TerminalOp<T, Optional<T>> makeRef(boolean mustFindFirst) {
        return new FindOp(mustFindFirst, StreamShape.REFERENCE, Optional.empty(), FindOps$$Lambda$1.lambdaFactory$(), FindOps$$Lambda$2.lambdaFactory$());
    }

    public static TerminalOp<Integer, OptionalInt> makeInt(boolean mustFindFirst) {
        return new FindOp<Integer, OptionalInt>(mustFindFirst, StreamShape.INT_VALUE, OptionalInt.empty(), FindOps$$Lambda$3.lambdaFactory$(), FindOps$$Lambda$4.lambdaFactory$());
    }

    public static TerminalOp<Long, OptionalLong> makeLong(boolean mustFindFirst) {
        return new FindOp<Long, OptionalLong>(mustFindFirst, StreamShape.LONG_VALUE, OptionalLong.empty(), FindOps$$Lambda$5.lambdaFactory$(), FindOps$$Lambda$6.lambdaFactory$());
    }

    public static TerminalOp<Double, OptionalDouble> makeDouble(boolean mustFindFirst) {
        return new FindOp<Double, OptionalDouble>(mustFindFirst, StreamShape.DOUBLE_VALUE, OptionalDouble.empty(), FindOps$$Lambda$7.lambdaFactory$(), FindOps$$Lambda$8.lambdaFactory$());
    }

    private static final class FindTask<P_IN, P_OUT, O>
    extends AbstractShortCircuitTask<P_IN, P_OUT, O, FindTask<P_IN, P_OUT, O>> {
        private final FindOp<P_OUT, O> op;

        FindTask(FindOp<P_OUT, O> op, PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator) {
            super(helper, spliterator);
            this.op = op;
        }

        FindTask(FindTask<P_IN, P_OUT, O> parent, Spliterator<P_IN> spliterator) {
            super(parent, spliterator);
            this.op = parent.op;
        }

        @Override
        protected FindTask<P_IN, P_OUT, O> makeChild(Spliterator<P_IN> spliterator) {
            return new FindTask<P_IN, P_OUT, O>(this, spliterator);
        }

        @Override
        protected O getEmptyResult() {
            return this.op.emptyValue;
        }

        private void foundResult(O answer) {
            if (this.isLeftmostNode()) {
                this.shortCircuit(answer);
            } else {
                this.cancelLaterNodes();
            }
        }

        @Override
        protected O doLeaf() {
            Object result = ((TerminalSink)this.helper.wrapAndCopyInto((Sink)this.op.sinkSupplier.get(), this.spliterator)).get();
            if (!this.op.mustFindFirst) {
                if (result != null) {
                    this.shortCircuit(result);
                }
                return null;
            }
            if (result != null) {
                this.foundResult(result);
                return (O)result;
            }
            return null;
        }

        @Override
        public void onCompletion(CountedCompleter<?> caller) {
            if (this.op.mustFindFirst) {
                FindTask child = (FindTask)this.leftChild;
                FindTask p = null;
                while (child != p) {
                    Object result = child.getLocalResult();
                    if (result != null && this.op.presentPredicate.test(result)) {
                        this.setLocalResult(result);
                        this.foundResult(result);
                        break;
                    }
                    p = child;
                    child = (FindTask)this.rightChild;
                }
            }
            super.onCompletion(caller);
        }
    }

    private static abstract class FindSink<T, O>
    implements TerminalSink<T, O> {
        boolean hasValue;
        T value;

        FindSink() {
        }

        @Override
        public void accept(T value) {
            if (!this.hasValue) {
                this.hasValue = true;
                this.value = value;
            }
        }

        @Override
        public boolean cancellationRequested() {
            return this.hasValue;
        }

        @Override
        public void begin(long size) {
        }

        @Override
        public void end() {
        }

        @Override
        public void accept(int value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(long value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(double value) {
            SinkDefaults.accept(this, value);
        }

        static final class OfDouble
        extends FindSink<Double, OptionalDouble>
        implements Sink.OfDouble {
            OfDouble() {
            }

            @Override
            public void accept(double value) {
                this.accept(Double.valueOf(value));
            }

            @Override
            public OptionalDouble get() {
                return this.hasValue ? OptionalDouble.of((Double)this.value) : null;
            }
        }

        static final class OfLong
        extends FindSink<Long, OptionalLong>
        implements Sink.OfLong {
            OfLong() {
            }

            @Override
            public void accept(long value) {
                this.accept(Long.valueOf(value));
            }

            @Override
            public OptionalLong get() {
                return this.hasValue ? OptionalLong.of((Long)this.value) : null;
            }
        }

        static final class OfInt
        extends FindSink<Integer, OptionalInt>
        implements Sink.OfInt {
            OfInt() {
            }

            @Override
            public void accept(int value) {
                this.accept(Integer.valueOf(value));
            }

            @Override
            public OptionalInt get() {
                return this.hasValue ? OptionalInt.of((Integer)this.value) : null;
            }
        }

        static final class OfRef<T>
        extends FindSink<T, Optional<T>> {
            OfRef() {
            }

            @Override
            public Optional<T> get() {
                return this.hasValue ? Optional.of(this.value) : null;
            }
        }
    }

    private static final class FindOp<T, O>
    implements TerminalOp<T, O> {
        private final StreamShape shape;
        final boolean mustFindFirst;
        final O emptyValue;
        final Predicate<O> presentPredicate;
        final Supplier<TerminalSink<T, O>> sinkSupplier;

        FindOp(boolean mustFindFirst, StreamShape shape, O emptyValue, Predicate<O> presentPredicate, Supplier<TerminalSink<T, O>> sinkSupplier) {
            this.mustFindFirst = mustFindFirst;
            this.shape = shape;
            this.emptyValue = emptyValue;
            this.presentPredicate = presentPredicate;
            this.sinkSupplier = sinkSupplier;
        }

        @Override
        public int getOpFlags() {
            return StreamOpFlag.IS_SHORT_CIRCUIT | (this.mustFindFirst ? 0 : StreamOpFlag.NOT_ORDERED);
        }

        @Override
        public StreamShape inputShape() {
            return this.shape;
        }

        @Override
        public <S> O evaluateSequential(PipelineHelper<T> helper, Spliterator<S> spliterator) {
            Object result = ((TerminalSink)helper.wrapAndCopyInto((Sink)this.sinkSupplier.get(), spliterator)).get();
            return (O)(result != null ? result : this.emptyValue);
        }

        @Override
        public <P_IN> O evaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
            return (O)new FindTask(this, helper, spliterator).invoke();
        }
    }
}

