/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.Iterators;
import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.PrimitiveIterator;
import java8.util.Spliterators;
import java8.util.function.IntConsumer;
import java8.util.function.IntPredicate;
import java8.util.function.IntSupplier;
import java8.util.function.IntUnaryOperator;
import java8.util.stream.IntStream;
import java8.util.stream.IntStreams$$Lambda$1;
import java8.util.stream.IntStreams$$Lambda$2;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;
import java8.util.stream.WhileOps;

public final class IntStreams {
    public static IntStream takeWhile(IntStream stream, IntPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        IntStream intStream = StreamSupport.intStream(new WhileOps.UnorderedWhileSpliterator.OfInt.Taking(stream.spliterator(), true, predicate), stream.isParallel());
        IntStream intStream2 = stream;
        intStream2.getClass();
        return (IntStream)intStream.onClose(IntStreams$$Lambda$1.lambdaFactory$(intStream2));
    }

    public static IntStream dropWhile(IntStream stream, IntPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        IntStream intStream = StreamSupport.intStream(new WhileOps.UnorderedWhileSpliterator.OfInt.Dropping(stream.spliterator(), true, predicate), stream.isParallel());
        IntStream intStream2 = stream;
        intStream2.getClass();
        return (IntStream)intStream.onClose(IntStreams$$Lambda$2.lambdaFactory$(intStream2));
    }

    public static IntStream.Builder builder() {
        return new Streams.IntStreamBuilderImpl();
    }

    public static IntStream empty() {
        return StreamSupport.intStream(Spliterators.emptyIntSpliterator(), false);
    }

    public static IntStream of(int t) {
        return StreamSupport.intStream(new Streams.IntStreamBuilderImpl(t), false);
    }

    public static IntStream of(int ... values) {
        return J8Arrays.stream(values);
    }

    public static IntStream iterate(final int seed, final IntUnaryOperator f) {
        Objects.requireNonNull(f);
        PrimitiveIterator.OfInt iterator = new PrimitiveIterator.OfInt(){
            int t;
            {
                this.t = seed;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public int nextInt() {
                int v = this.t;
                this.t = f.applyAsInt(this.t);
                return v;
            }

            @Override
            public Integer next() {
                return this.nextInt();
            }

            @Override
            public void forEachRemaining(IntConsumer action) {
                Iterators.forEachRemaining(this, action);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return StreamSupport.intStream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static IntStream generate(IntSupplier s) {
        Objects.requireNonNull(s);
        return StreamSupport.intStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfInt(Long.MAX_VALUE, s), false);
    }

    public static IntStream range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return IntStreams.empty();
        }
        return StreamSupport.intStream(new Streams.RangeIntSpliterator(startInclusive, endExclusive, false), false);
    }

    public static IntStream rangeClosed(int startInclusive, int endInclusive) {
        if (startInclusive > endInclusive) {
            return IntStreams.empty();
        }
        return StreamSupport.intStream(new Streams.RangeIntSpliterator(startInclusive, endInclusive, true), false);
    }

    public static IntStream concat(IntStream a, IntStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfInt split = new Streams.ConcatSpliterator.OfInt(a.spliterator(), b.spliterator());
        IntStream stream = StreamSupport.intStream(split, a.isParallel() || b.isParallel());
        return (IntStream)stream.onClose(Streams.composedClose(a, b));
    }

    private IntStreams() {
    }
}

