/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.lang.Longs;
import java8.util.Iterators;
import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.PrimitiveIterator;
import java8.util.Spliterators;
import java8.util.function.LongConsumer;
import java8.util.function.LongPredicate;
import java8.util.function.LongSupplier;
import java8.util.function.LongUnaryOperator;
import java8.util.stream.LongStream;
import java8.util.stream.LongStreams$$Lambda$1;
import java8.util.stream.LongStreams$$Lambda$2;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;
import java8.util.stream.WhileOps;

public final class LongStreams {
    public static LongStream takeWhile(LongStream stream, LongPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        LongStream longStream = StreamSupport.longStream(new WhileOps.UnorderedWhileSpliterator.OfLong.Taking(stream.spliterator(), true, predicate), stream.isParallel());
        LongStream longStream2 = stream;
        longStream2.getClass();
        return (LongStream)longStream.onClose(LongStreams$$Lambda$1.lambdaFactory$(longStream2));
    }

    public static LongStream dropWhile(LongStream stream, LongPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        LongStream longStream = StreamSupport.longStream(new WhileOps.UnorderedWhileSpliterator.OfLong.Dropping(stream.spliterator(), true, predicate), stream.isParallel());
        LongStream longStream2 = stream;
        longStream2.getClass();
        return (LongStream)longStream.onClose(LongStreams$$Lambda$2.lambdaFactory$(longStream2));
    }

    public static LongStream.Builder builder() {
        return new Streams.LongStreamBuilderImpl();
    }

    public static LongStream empty() {
        return StreamSupport.longStream(Spliterators.emptyLongSpliterator(), false);
    }

    public static LongStream of(long t) {
        return StreamSupport.longStream(new Streams.LongStreamBuilderImpl(t), false);
    }

    public static LongStream of(long ... values) {
        return J8Arrays.stream(values);
    }

    public static LongStream iterate(final long seed, final LongUnaryOperator f) {
        Objects.requireNonNull(f);
        PrimitiveIterator.OfLong iterator = new PrimitiveIterator.OfLong(){
            long t;
            {
                this.t = seed;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public long nextLong() {
                long v = this.t;
                this.t = f.applyAsLong(this.t);
                return v;
            }

            @Override
            public Long next() {
                return this.nextLong();
            }

            @Override
            public void forEachRemaining(LongConsumer action) {
                Iterators.forEachRemaining(this, action);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static LongStream generate(LongSupplier s) {
        Objects.requireNonNull(s);
        return StreamSupport.longStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfLong(Long.MAX_VALUE, s), false);
    }

    public static LongStream range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return LongStreams.empty();
        }
        if (endExclusive - startInclusive < 0L) {
            long m = startInclusive + Longs.divideUnsigned(endExclusive - startInclusive, 2L) + 1L;
            return LongStreams.concat(LongStreams.range(startInclusive, m), LongStreams.range(m, endExclusive));
        }
        return StreamSupport.longStream(new Streams.RangeLongSpliterator(startInclusive, endExclusive, false), false);
    }

    public static LongStream rangeClosed(long startInclusive, long endInclusive) {
        if (startInclusive > endInclusive) {
            return LongStreams.empty();
        }
        if (endInclusive - startInclusive + 1L <= 0L) {
            long m = startInclusive + Longs.divideUnsigned(endInclusive - startInclusive, 2L) + 1L;
            return LongStreams.concat(LongStreams.range(startInclusive, m), LongStreams.rangeClosed(m, endInclusive));
        }
        return StreamSupport.longStream(new Streams.RangeLongSpliterator(startInclusive, endInclusive, true), false);
    }

    public static LongStream concat(LongStream a, LongStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfLong split = new Streams.ConcatSpliterator.OfLong(a.spliterator(), b.spliterator());
        LongStream stream = StreamSupport.longStream(split, a.isParallel() || b.isParallel());
        return (LongStream)stream.onClose(Streams.composedClose(a, b));
    }

    private LongStreams() {
    }
}

