/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.function.DoublePredicate;
import java8.util.function.IntPredicate;
import java8.util.function.LongPredicate;
import java8.util.function.Predicate;
import java8.util.function.Supplier;
import java8.util.stream.AbstractShortCircuitTask;
import java8.util.stream.MatchOps$$Lambda$1;
import java8.util.stream.MatchOps$$Lambda$2;
import java8.util.stream.MatchOps$$Lambda$3;
import java8.util.stream.MatchOps$$Lambda$4;
import java8.util.stream.PipelineHelper;
import java8.util.stream.Sink;
import java8.util.stream.SinkDefaults;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamShape;
import java8.util.stream.TerminalOp;

final class MatchOps {
    private MatchOps() {
    }

    public static <T> TerminalOp<T, Boolean> makeRef(Predicate<? super T> predicate, MatchKind matchKind) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(matchKind);
        return new MatchOp(StreamShape.REFERENCE, matchKind, MatchOps$$Lambda$1.lambdaFactory$(matchKind, predicate));
    }

    public static TerminalOp<Integer, Boolean> makeInt(IntPredicate predicate, MatchKind matchKind) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(matchKind);
        return new MatchOp<Integer>(StreamShape.INT_VALUE, matchKind, MatchOps$$Lambda$2.lambdaFactory$(matchKind, predicate));
    }

    public static TerminalOp<Long, Boolean> makeLong(LongPredicate predicate, MatchKind matchKind) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(matchKind);
        return new MatchOp<Long>(StreamShape.LONG_VALUE, matchKind, MatchOps$$Lambda$3.lambdaFactory$(matchKind, predicate));
    }

    public static TerminalOp<Double, Boolean> makeDouble(DoublePredicate predicate, MatchKind matchKind) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(matchKind);
        return new MatchOp<Double>(StreamShape.DOUBLE_VALUE, matchKind, MatchOps$$Lambda$4.lambdaFactory$(matchKind, predicate));
    }

    private static /* synthetic */ BooleanTerminalSink lambda$makeDouble$168(final MatchKind matchKind, final DoublePredicate doublePredicate) {
        class MatchSink
        extends BooleanTerminalSink<Double>
        implements Sink.OfDouble {
            MatchSink() {
                super(matchKind2);
            }

            @Override
            public void accept(double t) {
                if (!this.stop && doublePredicate.test(t) == matchKind.stopOnPredicateMatches) {
                    this.stop = true;
                    this.value = matchKind.shortCircuitResult;
                }
            }

            @Override
            public void accept(Double i) {
                SinkDefaults.OfDouble.accept(this, i);
            }
        }
        return new MatchSink();
    }

    private static /* synthetic */ BooleanTerminalSink lambda$makeLong$167(final MatchKind matchKind, final LongPredicate longPredicate) {
        class MatchSink
        extends BooleanTerminalSink<Long>
        implements Sink.OfLong {
            MatchSink() {
                super(matchKind2);
            }

            @Override
            public void accept(long t) {
                if (!this.stop && longPredicate.test(t) == matchKind.stopOnPredicateMatches) {
                    this.stop = true;
                    this.value = matchKind.shortCircuitResult;
                }
            }

            @Override
            public void accept(Long i) {
                SinkDefaults.OfLong.accept(this, i);
            }
        }
        return new MatchSink();
    }

    private static /* synthetic */ BooleanTerminalSink lambda$makeInt$166(final MatchKind matchKind, final IntPredicate intPredicate) {
        class MatchSink
        extends BooleanTerminalSink<Integer>
        implements Sink.OfInt {
            MatchSink() {
                super(matchKind2);
            }

            @Override
            public void accept(int t) {
                if (!this.stop && intPredicate.test(t) == matchKind.stopOnPredicateMatches) {
                    this.stop = true;
                    this.value = matchKind.shortCircuitResult;
                }
            }

            @Override
            public void accept(Integer i) {
                SinkDefaults.OfInt.accept(this, i);
            }
        }
        return new MatchSink();
    }

    private static /* synthetic */ BooleanTerminalSink lambda$makeRef$165(final MatchKind matchKind, final Predicate predicate) {
        class MatchSink
        extends BooleanTerminalSink<T> {
            MatchSink() {
                super(matchKind2);
            }

            @Override
            public void accept(T t) {
                if (!this.stop && predicate.test(t) == matchKind.stopOnPredicateMatches) {
                    this.stop = true;
                    this.value = matchKind.shortCircuitResult;
                }
            }
        }
        return new MatchSink();
    }

    static /* synthetic */ BooleanTerminalSink access$lambda$0(MatchKind matchKind, Predicate predicate) {
        return MatchOps.lambda$makeRef$165(matchKind, predicate);
    }

    static /* synthetic */ BooleanTerminalSink access$lambda$1(MatchKind matchKind, IntPredicate intPredicate) {
        return MatchOps.lambda$makeInt$166(matchKind, intPredicate);
    }

    static /* synthetic */ BooleanTerminalSink access$lambda$2(MatchKind matchKind, LongPredicate longPredicate) {
        return MatchOps.lambda$makeLong$167(matchKind, longPredicate);
    }

    static /* synthetic */ BooleanTerminalSink access$lambda$3(MatchKind matchKind, DoublePredicate doublePredicate) {
        return MatchOps.lambda$makeDouble$168(matchKind, doublePredicate);
    }

    private static final class MatchTask<P_IN, P_OUT>
    extends AbstractShortCircuitTask<P_IN, P_OUT, Boolean, MatchTask<P_IN, P_OUT>> {
        private final MatchOp<P_OUT> op;

        MatchTask(MatchOp<P_OUT> op, PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator) {
            super(helper, spliterator);
            this.op = op;
        }

        MatchTask(MatchTask<P_IN, P_OUT> parent, Spliterator<P_IN> spliterator) {
            super(parent, spliterator);
            this.op = parent.op;
        }

        @Override
        protected MatchTask<P_IN, P_OUT> makeChild(Spliterator<P_IN> spliterator) {
            return new MatchTask<P_IN, P_OUT>(this, spliterator);
        }

        @Override
        protected Boolean doLeaf() {
            boolean b = ((BooleanTerminalSink)this.helper.wrapAndCopyInto((Sink)this.op.sinkSupplier.get(), this.spliterator)).getAndClearState();
            if (b == this.op.matchKind.shortCircuitResult) {
                this.shortCircuit(b);
            }
            return null;
        }

        @Override
        protected Boolean getEmptyResult() {
            return !this.op.matchKind.shortCircuitResult;
        }
    }

    private static abstract class BooleanTerminalSink<T>
    implements Sink<T> {
        boolean stop;
        boolean value;

        BooleanTerminalSink(MatchKind matchKind) {
            this.value = !matchKind.shortCircuitResult;
        }

        public boolean getAndClearState() {
            return this.value;
        }

        @Override
        public boolean cancellationRequested() {
            return this.stop;
        }

        @Override
        public void begin(long size) {
        }

        @Override
        public void end() {
        }

        @Override
        public void accept(int value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(long value) {
            SinkDefaults.accept(this, value);
        }

        @Override
        public void accept(double value) {
            SinkDefaults.accept(this, value);
        }
    }

    private static final class MatchOp<T>
    implements TerminalOp<T, Boolean> {
        private final StreamShape inputShape;
        final MatchKind matchKind;
        final Supplier<BooleanTerminalSink<T>> sinkSupplier;

        MatchOp(StreamShape shape, MatchKind matchKind, Supplier<BooleanTerminalSink<T>> sinkSupplier) {
            this.inputShape = shape;
            this.matchKind = matchKind;
            this.sinkSupplier = sinkSupplier;
        }

        @Override
        public int getOpFlags() {
            return StreamOpFlag.IS_SHORT_CIRCUIT | StreamOpFlag.NOT_ORDERED;
        }

        @Override
        public StreamShape inputShape() {
            return this.inputShape;
        }

        @Override
        public <S> Boolean evaluateSequential(PipelineHelper<T> helper, Spliterator<S> spliterator) {
            return ((BooleanTerminalSink)helper.wrapAndCopyInto((Sink)this.sinkSupplier.get(), spliterator)).getAndClearState();
        }

        @Override
        public <S> Boolean evaluateParallel(PipelineHelper<T> helper, Spliterator<S> spliterator) {
            return (Boolean)new MatchTask<S, T>(this, helper, spliterator).invoke();
        }
    }

    static enum MatchKind {
        ANY(true, true),
        ALL(false, false),
        NONE(true, false);

        private final boolean stopOnPredicateMatches;
        private final boolean shortCircuitResult;

        private MatchKind(boolean stopOnPredicateMatches, boolean shortCircuitResult) {
            this.stopOnPredicateMatches = stopOnPredicateMatches;
            this.shortCircuitResult = shortCircuitResult;
        }
    }
}

