/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java.util.Iterator;
import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.Spliterators;
import java8.util.function.Predicate;
import java8.util.function.Supplier;
import java8.util.function.UnaryOperator;
import java8.util.stream.RefStreams$$Lambda$1;
import java8.util.stream.RefStreams$$Lambda$2;
import java8.util.stream.Stream;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;
import java8.util.stream.WhileOps;

public final class RefStreams {
    public static <T> Stream<T> takeWhile(Stream<? extends T> stream, Predicate<? super T> predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        Stream<T> s = stream;
        Stream<T> stream2 = StreamSupport.stream(new WhileOps.UnorderedWhileSpliterator.OfRef.Taking<T>(s.spliterator(), true, predicate), s.isParallel());
        Stream<T> stream3 = s;
        stream3.getClass();
        return (Stream)stream2.onClose(RefStreams$$Lambda$1.lambdaFactory$(stream3));
    }

    public static <T> Stream<T> dropWhile(Stream<? extends T> stream, Predicate<? super T> predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        Stream<T> s = stream;
        Stream<T> stream2 = StreamSupport.stream(new WhileOps.UnorderedWhileSpliterator.OfRef.Dropping<T>(s.spliterator(), true, predicate), s.isParallel());
        Stream<T> stream3 = s;
        stream3.getClass();
        return (Stream)stream2.onClose(RefStreams$$Lambda$2.lambdaFactory$(stream3));
    }

    public static <T> Stream.Builder<T> builder() {
        return new Streams.StreamBuilderImpl();
    }

    public static <T> Stream<T> empty() {
        return StreamSupport.stream(Spliterators.emptySpliterator(), false);
    }

    public static <T> Stream<T> of(T t) {
        return StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> ofNullable(T t) {
        return t == null ? RefStreams.empty() : StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> of(T ... values) {
        return J8Arrays.stream(values);
    }

    public static <T, S extends T> Stream<T> iterate(final S seed, final UnaryOperator<S> f) {
        Objects.requireNonNull(f);
        Iterator iterator = new Iterator<T>(){
            S s = Streams.NONE;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                this.s = this.s == Streams.NONE ? seed : f.apply(this.s);
                return this.s;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1040), false);
    }

    public static <T> Stream<T> generate(Supplier<? extends T> s) {
        Objects.requireNonNull(s);
        return StreamSupport.stream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfRef<T>(Long.MAX_VALUE, s), false);
    }

    public static <T> Stream<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfRef split = new Streams.ConcatSpliterator.OfRef(a.spliterator(), b.spliterator());
        Stream stream = StreamSupport.stream(split, a.isParallel() || b.isParallel());
        return (Stream)stream.onClose(Streams.composedClose(a, b));
    }

    private RefStreams() {
    }
}

