/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java8.util.concurrent.ForkJoinPool;
import java8.util.concurrent.TLRandom;

public class ForkJoinWorkerThread
extends Thread {
    private static final String NAME_PLACEHOLDER = "aForkJoinWorkerThread";
    final ForkJoinPool pool;
    final ForkJoinPool.WorkQueue workQueue;

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        super(NAME_PLACEHOLDER);
        this.pool = pool;
        this.workQueue = pool.registerWorker(this);
    }

    ForkJoinWorkerThread(ForkJoinPool pool, ClassLoader ccl) {
        super(NAME_PLACEHOLDER);
        TLRandom.setContextClassLoader(this, ccl);
        this.pool = pool;
        this.workQueue = pool.registerWorker(this);
    }

    ForkJoinWorkerThread(ForkJoinPool pool, ClassLoader ccl, ThreadGroup threadGroup, AccessControlContext acc) {
        super(threadGroup, NAME_PLACEHOLDER);
        super.setContextClassLoader(ccl);
        TLRandom.setInheritedAccessControlContext(this, acc);
        TLRandom.eraseThreadLocals(this);
        this.pool = pool;
        this.workQueue = pool.registerWorker(this);
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.workQueue.getPoolIndex();
    }

    protected void onStart() {
    }

    protected void onTermination(Throwable exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.workQueue.array == null) {
            Throwable exception = null;
            try {
                this.onStart();
                this.pool.runWorker(this.workQueue);
            }
            catch (Throwable ex) {
                exception = ex;
            }
            finally {
                try {
                    this.onTermination(exception);
                }
                catch (Throwable ex) {
                    if (exception == null) {
                        exception = ex;
                    }
                }
                finally {
                    this.pool.deregisterWorker(this, exception);
                }
            }
        }
    }

    void afterTopLevelExec() {
    }

    static final class InnocuousForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private static final ThreadGroup innocuousThreadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                ThreadGroup p;
                ThreadGroup group = Thread.currentThread().getThreadGroup();
                while ((p = group.getParent()) != null) {
                    group = p;
                }
                return new ThreadGroup(group, "InnocuousForkJoinWorkerThreadGroup");
            }
        });
        private static final AccessControlContext INNOCUOUS_ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});

        InnocuousForkJoinWorkerThread(ForkJoinPool pool) {
            super(pool, ClassLoader.getSystemClassLoader(), innocuousThreadGroup, INNOCUOUS_ACC);
        }

        @Override
        void afterTopLevelExec() {
            TLRandom.eraseThreadLocals(this);
        }

        @Override
        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler x) {
        }

        @Override
        public void setContextClassLoader(ClassLoader cl) {
            throw new SecurityException("setContextClassLoader");
        }
    }
}

