/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.concurrent.CountedCompleter;
import java8.util.concurrent.ForkJoinTask;
import java8.util.function.BinaryOperator;
import java8.util.function.Consumer;
import java8.util.function.DoubleConsumer;
import java8.util.function.IntConsumer;
import java8.util.function.IntFunction;
import java8.util.function.LongConsumer;
import java8.util.function.LongFunction;
import java8.util.stream.AbstractTask;
import java8.util.stream.Node;
import java8.util.stream.Nodes$$Lambda$1;
import java8.util.stream.Nodes$$Lambda$2;
import java8.util.stream.Nodes$CollectorTask$OfDouble$$Lambda$1;
import java8.util.stream.Nodes$CollectorTask$OfDouble$$Lambda$2;
import java8.util.stream.Nodes$CollectorTask$OfInt$$Lambda$1;
import java8.util.stream.Nodes$CollectorTask$OfInt$$Lambda$2;
import java8.util.stream.Nodes$CollectorTask$OfLong$$Lambda$1;
import java8.util.stream.Nodes$CollectorTask$OfLong$$Lambda$2;
import java8.util.stream.Nodes$CollectorTask$OfRef$$Lambda$1;
import java8.util.stream.Nodes$CollectorTask$OfRef$$Lambda$2;
import java8.util.stream.Nodes$OfDouble$$Lambda$1;
import java8.util.stream.Nodes$OfInt$$Lambda$1;
import java8.util.stream.Nodes$OfLong$$Lambda$1;
import java8.util.stream.PipelineHelper;
import java8.util.stream.Sink;
import java8.util.stream.SinkDefaults;
import java8.util.stream.SpinedBuffer;
import java8.util.stream.StreamShape;

final class Nodes {
    static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    static final String BAD_SIZE = "Stream size exceeds max array size";
    private static final Node EMPTY_NODE = new EmptyNode.OfRef();
    private static final Node.OfInt EMPTY_INT_NODE = new EmptyNode.OfInt();
    private static final Node.OfLong EMPTY_LONG_NODE = new EmptyNode.OfLong();
    private static final Node.OfDouble EMPTY_DOUBLE_NODE = new EmptyNode.OfDouble();
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];

    private Nodes() {
        throw new Error("no instances");
    }

    static <T> StreamShape getShape() {
        return StreamShape.REFERENCE;
    }

    static <T> int getChildCount() {
        return 0;
    }

    static <T> Node<T> getChild() {
        throw new IndexOutOfBoundsException();
    }

    static <T> Node<T> truncate(Node<T> node, long from, long to, IntFunction<T[]> generator) {
        if (from == 0L && to == node.count()) {
            return node;
        }
        Spliterator<T> spliterator = node.spliterator();
        long size = to - from;
        Node.Builder<T> nodeBuilder = Nodes.builder(size, generator);
        nodeBuilder.begin(size);
        int i = 0;
        while ((long)i < from && spliterator.tryAdvance(Nodes$$Lambda$1.lambdaFactory$())) {
            ++i;
        }
        if (to == node.count()) {
            spliterator.forEachRemaining(nodeBuilder);
        } else {
            i = 0;
            while ((long)i < size && spliterator.tryAdvance(nodeBuilder)) {
                ++i;
            }
        }
        nodeBuilder.end();
        return nodeBuilder.build();
    }

    static <T> IntFunction<T[]> castingArray() {
        return Nodes$$Lambda$2.lambdaFactory$();
    }

    static <T> Node<T> emptyNode(StreamShape shape) {
        switch (shape) {
            case REFERENCE: {
                return EMPTY_NODE;
            }
            case INT_VALUE: {
                return EMPTY_INT_NODE;
            }
            case LONG_VALUE: {
                return EMPTY_LONG_NODE;
            }
            case DOUBLE_VALUE: {
                return EMPTY_DOUBLE_NODE;
            }
        }
        throw new IllegalStateException("Unknown shape " + (Object)((Object)shape));
    }

    static <T> Node<T> conc(StreamShape shape, Node<T> left, Node<T> right) {
        switch (shape) {
            case REFERENCE: {
                return new ConcNode<T>(left, right);
            }
            case INT_VALUE: {
                return new ConcNode.OfInt((Node.OfInt)left, (Node.OfInt)right);
            }
            case LONG_VALUE: {
                return new ConcNode.OfLong((Node.OfLong)left, (Node.OfLong)right);
            }
            case DOUBLE_VALUE: {
                return new ConcNode.OfDouble((Node.OfDouble)left, (Node.OfDouble)right);
            }
        }
        throw new IllegalStateException("Unknown shape " + (Object)((Object)shape));
    }

    static <T> Node<T> node(T[] array) {
        return new ArrayNode<T>(array);
    }

    static <T> Node<T> node(Collection<T> c) {
        return new CollectionNode<T>(c);
    }

    static <T> Node.Builder<T> builder(long exactSizeIfKnown, IntFunction<T[]> generator) {
        return exactSizeIfKnown >= 0L && exactSizeIfKnown < 0x7FFFFFF7L ? new FixedNodeBuilder(exactSizeIfKnown, generator) : Nodes.builder();
    }

    static <T> Node.Builder<T> builder() {
        return new SpinedNodeBuilder();
    }

    static Node.OfInt node(int[] array) {
        return new IntArrayNode(array);
    }

    static Node.Builder.OfInt intBuilder(long exactSizeIfKnown) {
        return exactSizeIfKnown >= 0L && exactSizeIfKnown < 0x7FFFFFF7L ? new IntFixedNodeBuilder(exactSizeIfKnown) : Nodes.intBuilder();
    }

    static Node.Builder.OfInt intBuilder() {
        return new IntSpinedNodeBuilder();
    }

    static Node.OfLong node(long[] array) {
        return new LongArrayNode(array);
    }

    static Node.Builder.OfLong longBuilder(long exactSizeIfKnown) {
        return exactSizeIfKnown >= 0L && exactSizeIfKnown < 0x7FFFFFF7L ? new LongFixedNodeBuilder(exactSizeIfKnown) : Nodes.longBuilder();
    }

    static Node.Builder.OfLong longBuilder() {
        return new LongSpinedNodeBuilder();
    }

    static Node.OfDouble node(double[] array) {
        return new DoubleArrayNode(array);
    }

    static Node.Builder.OfDouble doubleBuilder(long exactSizeIfKnown) {
        return exactSizeIfKnown >= 0L && exactSizeIfKnown < 0x7FFFFFF7L ? new DoubleFixedNodeBuilder(exactSizeIfKnown) : Nodes.doubleBuilder();
    }

    static Node.Builder.OfDouble doubleBuilder() {
        return new DoubleSpinedNodeBuilder();
    }

    public static <P_IN, P_OUT> Node<P_OUT> collect(PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator, boolean flattenTree, IntFunction<P_OUT[]> generator) {
        long size = helper.exactOutputSizeIfKnown(spliterator);
        if (size >= 0L && spliterator.hasCharacteristics(16384)) {
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            P_OUT[] array = generator.apply((int)size);
            new SizedCollectorTask.OfRef<P_IN, P_OUT>(spliterator, helper, array).invoke();
            return Nodes.node(array);
        }
        Node node = (Node)new CollectorTask.OfRef<P_IN, P_OUT>(helper, generator, spliterator).invoke();
        return flattenTree ? Nodes.flatten(node, generator) : node;
    }

    public static <P_IN> Node.OfInt collectInt(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator, boolean flattenTree) {
        long size = helper.exactOutputSizeIfKnown(spliterator);
        if (size >= 0L && spliterator.hasCharacteristics(16384)) {
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            int[] array = new int[(int)size];
            new SizedCollectorTask.OfInt<P_IN>(spliterator, helper, array).invoke();
            return Nodes.node(array);
        }
        Node.OfInt node = (Node.OfInt)new CollectorTask.OfInt<P_IN>(helper, spliterator).invoke();
        return flattenTree ? Nodes.flattenInt(node) : node;
    }

    public static <P_IN> Node.OfLong collectLong(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator, boolean flattenTree) {
        long size = helper.exactOutputSizeIfKnown(spliterator);
        if (size >= 0L && spliterator.hasCharacteristics(16384)) {
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            long[] array = new long[(int)size];
            new SizedCollectorTask.OfLong<P_IN>(spliterator, helper, array).invoke();
            return Nodes.node(array);
        }
        Node.OfLong node = (Node.OfLong)new CollectorTask.OfLong<P_IN>(helper, spliterator).invoke();
        return flattenTree ? Nodes.flattenLong(node) : node;
    }

    public static <P_IN> Node.OfDouble collectDouble(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator, boolean flattenTree) {
        long size = helper.exactOutputSizeIfKnown(spliterator);
        if (size >= 0L && spliterator.hasCharacteristics(16384)) {
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            double[] array = new double[(int)size];
            new SizedCollectorTask.OfDouble<P_IN>(spliterator, helper, array).invoke();
            return Nodes.node(array);
        }
        Node.OfDouble node = (Node.OfDouble)new CollectorTask.OfDouble<P_IN>(helper, spliterator).invoke();
        return flattenTree ? Nodes.flattenDouble(node) : node;
    }

    public static <T> Node<T> flatten(Node<T> node, IntFunction<T[]> generator) {
        if (node.getChildCount() > 0) {
            long size = node.count();
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            Object[] array = generator.apply((int)size);
            new ToArrayTask.OfRef(node, array, 0).invoke();
            return Nodes.node(array);
        }
        return node;
    }

    public static Node.OfInt flattenInt(Node.OfInt node) {
        if (node.getChildCount() > 0) {
            long size = node.count();
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            int[] array = new int[(int)size];
            new ToArrayTask.OfInt(node, array, 0).invoke();
            return Nodes.node(array);
        }
        return node;
    }

    public static Node.OfLong flattenLong(Node.OfLong node) {
        if (node.getChildCount() > 0) {
            long size = node.count();
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            long[] array = new long[(int)size];
            new ToArrayTask.OfLong(node, array, 0).invoke();
            return Nodes.node(array);
        }
        return node;
    }

    public static Node.OfDouble flattenDouble(Node.OfDouble node) {
        if (node.getChildCount() > 0) {
            long size = node.count();
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            double[] array = new double[(int)size];
            new ToArrayTask.OfDouble(node, array, 0).invoke();
            return Nodes.node(array);
        }
        return node;
    }

    static /* synthetic */ Object[] lambda$castingArray$107(int size) {
        return new Object[size];
    }

    static /* synthetic */ void lambda$truncate$103(Object e) {
    }

    private static class CollectorTask<P_IN, P_OUT, T_NODE extends Node<P_OUT>, T_BUILDER extends Node.Builder<P_OUT>>
    extends AbstractTask<P_IN, P_OUT, T_NODE, CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER>> {
        protected final PipelineHelper<P_OUT> helper;
        protected final LongFunction<T_BUILDER> builderFactory;
        protected final BinaryOperator<T_NODE> concFactory;

        CollectorTask(PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator, LongFunction<T_BUILDER> builderFactory, BinaryOperator<T_NODE> concFactory) {
            super(helper, spliterator);
            this.helper = helper;
            this.builderFactory = builderFactory;
            this.concFactory = concFactory;
        }

        CollectorTask(CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER> parent, Spliterator<P_IN> spliterator) {
            super(parent, spliterator);
            this.helper = parent.helper;
            this.builderFactory = parent.builderFactory;
            this.concFactory = parent.concFactory;
        }

        @Override
        protected CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER> makeChild(Spliterator<P_IN> spliterator) {
            return new CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER>(this, spliterator);
        }

        @Override
        protected T_NODE doLeaf() {
            Node.Builder builder = (Node.Builder)this.builderFactory.apply(this.helper.exactOutputSizeIfKnown(this.spliterator));
            return (T_NODE)this.helper.wrapAndCopyInto(builder, this.spliterator).build();
        }

        @Override
        public void onCompletion(CountedCompleter<?> caller) {
            if (!this.isLeaf()) {
                this.setLocalResult(this.concFactory.apply(((CollectorTask)this.leftChild).getLocalResult(), ((CollectorTask)this.rightChild).getLocalResult()));
            }
            super.onCompletion(caller);
        }

        private static final class OfDouble<P_IN>
        extends CollectorTask<P_IN, Double, Node.OfDouble, Node.Builder.OfDouble> {
            OfDouble(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator) {
                super(helper, spliterator, Nodes$CollectorTask$OfDouble$$Lambda$1.lambdaFactory$(), Nodes$CollectorTask$OfDouble$$Lambda$2.lambdaFactory$());
            }
        }

        private static final class OfLong<P_IN>
        extends CollectorTask<P_IN, Long, Node.OfLong, Node.Builder.OfLong> {
            OfLong(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator) {
                super(helper, spliterator, Nodes$CollectorTask$OfLong$$Lambda$1.lambdaFactory$(), Nodes$CollectorTask$OfLong$$Lambda$2.lambdaFactory$());
            }
        }

        private static final class OfInt<P_IN>
        extends CollectorTask<P_IN, Integer, Node.OfInt, Node.Builder.OfInt> {
            OfInt(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator) {
                super(helper, spliterator, Nodes$CollectorTask$OfInt$$Lambda$1.lambdaFactory$(), Nodes$CollectorTask$OfInt$$Lambda$2.lambdaFactory$());
            }
        }

        private static final class OfRef<P_IN, P_OUT>
        extends CollectorTask<P_IN, P_OUT, Node<P_OUT>, Node.Builder<P_OUT>> {
            OfRef(PipelineHelper<P_OUT> helper, IntFunction<P_OUT[]> generator, Spliterator<P_IN> spliterator) {
                super(helper, spliterator, Nodes$CollectorTask$OfRef$$Lambda$1.lambdaFactory$(generator), Nodes$CollectorTask$OfRef$$Lambda$2.lambdaFactory$());
            }

            static /* synthetic */ Node.Builder lambda$new$108(IntFunction intFunction, long s) {
                return Nodes.builder(s, intFunction);
            }
        }
    }

    private static abstract class ToArrayTask<T, T_NODE extends Node<T>, K extends ToArrayTask<T, T_NODE, K>>
    extends CountedCompleter<Void> {
        protected final T_NODE node;
        protected final int offset;

        ToArrayTask(T_NODE node, int offset) {
            this.node = node;
            this.offset = offset;
        }

        ToArrayTask(K parent, T_NODE node, int offset) {
            super((CountedCompleter<?>)parent);
            this.node = node;
            this.offset = offset;
        }

        abstract void copyNodeToArray();

        abstract K makeChild(int var1, int var2);

        @Override
        public void compute() {
            ToArrayTask<T, T_NODE, K> task = this;
            while (true) {
                int i;
                if (task.node.getChildCount() == 0) {
                    task.copyNodeToArray();
                    task.propagateCompletion();
                    return;
                }
                task.setPendingCount(task.node.getChildCount() - 1);
                int size = 0;
                for (i = 0; i < task.node.getChildCount() - 1; ++i) {
                    K leftTask = task.makeChild(i, task.offset + size);
                    size = (int)((long)size + ((ToArrayTask)leftTask).node.count());
                    ((ForkJoinTask)leftTask).fork();
                }
                task = task.makeChild(i, task.offset + size);
            }
        }

        private static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble> {
            private OfDouble(Node.OfDouble node, double[] array, int offset) {
                super(node, array, offset, null);
            }
        }

        private static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong> {
            private OfLong(Node.OfLong node, long[] array, int offset) {
                super(node, array, offset, null);
            }
        }

        private static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt> {
            private OfInt(Node.OfInt node, int[] array, int offset) {
                super(node, array, offset, null);
            }
        }

        private static class OfPrimitive<T, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, T_NODE extends Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>>
        extends ToArrayTask<T, T_NODE, OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>> {
            private final T_ARR array;

            private OfPrimitive(T_NODE node, T_ARR array, int offset) {
                super(node, offset);
                this.array = array;
            }

            private OfPrimitive(OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE> parent, T_NODE node, int offset) {
                super(parent, node, offset);
                this.array = parent.array;
            }

            @Override
            OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE> makeChild(int childIndex, int offset) {
                return new OfPrimitive(this, ((Node.OfPrimitive)this.node).getChild(childIndex), offset);
            }

            @Override
            void copyNodeToArray() {
                ((Node.OfPrimitive)this.node).copyInto(this.array, this.offset);
            }

            /* synthetic */ OfPrimitive(Node.OfPrimitive x0, Object x1, int x2, 1 x3) {
                this(x0, x1, x2);
            }
        }

        private static final class OfRef<T>
        extends ToArrayTask<T, Node<T>, OfRef<T>> {
            private final T[] array;

            private OfRef(Node<T> node, T[] array, int offset) {
                super(node, offset);
                this.array = array;
            }

            private OfRef(OfRef<T> parent, Node<T> node, int offset) {
                super(parent, node, offset);
                this.array = parent.array;
            }

            @Override
            OfRef<T> makeChild(int childIndex, int offset) {
                return new OfRef(this, this.node.getChild(childIndex), offset);
            }

            @Override
            void copyNodeToArray() {
                this.node.copyInto(this.array, this.offset);
            }
        }
    }

    private static abstract class SizedCollectorTask<P_IN, P_OUT, T_SINK extends Sink<P_OUT>, K extends SizedCollectorTask<P_IN, P_OUT, T_SINK, K>>
    extends CountedCompleter<Void>
    implements Sink<P_OUT> {
        protected final Spliterator<P_IN> spliterator;
        protected final PipelineHelper<P_OUT> helper;
        protected final long targetSize;
        protected long offset;
        protected long length;
        protected int index;
        protected int fence;

        SizedCollectorTask(Spliterator<P_IN> spliterator, PipelineHelper<P_OUT> helper, int arrayLength) {
            this.spliterator = spliterator;
            this.helper = helper;
            this.targetSize = AbstractTask.suggestTargetSize(spliterator.estimateSize());
            this.offset = 0L;
            this.length = arrayLength;
        }

        SizedCollectorTask(K parent, Spliterator<P_IN> spliterator, long offset, long length, int arrayLength) {
            super((CountedCompleter<?>)parent);
            this.spliterator = spliterator;
            this.helper = ((SizedCollectorTask)parent).helper;
            this.targetSize = ((SizedCollectorTask)parent).targetSize;
            this.offset = offset;
            this.length = length;
            if (offset < 0L || length < 0L || offset + length - 1L >= (long)arrayLength) {
                throw new IllegalArgumentException(String.format("offset and length interval [%d, %d + %d) is not within array size interval [0, %d)", offset, offset, length, arrayLength));
            }
        }

        @Override
        public void compute() {
            Spliterator<P_IN> leftSplit;
            SizedCollectorTask<P_IN, P_OUT, T_SINK, K> task = this;
            Spliterator<P_IN> rightSplit = this.spliterator;
            while (rightSplit.estimateSize() > task.targetSize && (leftSplit = rightSplit.trySplit()) != null) {
                task.setPendingCount(1);
                long leftSplitSize = leftSplit.estimateSize();
                ((ForkJoinTask)task.makeChild(leftSplit, task.offset, leftSplitSize)).fork();
                task = task.makeChild(rightSplit, task.offset + leftSplitSize, task.length - leftSplitSize);
            }
            SizedCollectorTask sink = task;
            task.helper.wrapAndCopyInto(sink, rightSplit);
            task.propagateCompletion();
        }

        abstract K makeChild(Spliterator<P_IN> var1, long var2, long var4);

        @Override
        public void begin(long size) {
            if (size > this.length) {
                throw new IllegalStateException("size passed to Sink.begin exceeds array length");
            }
            this.index = (int)this.offset;
            this.fence = this.index + (int)this.length;
        }

        @Override
        public void end() {
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(int value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(long value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(double value) {
            SinkDefaults.reject();
        }

        static final class OfDouble<P_IN>
        extends SizedCollectorTask<P_IN, Double, Sink.OfDouble, OfDouble<P_IN>>
        implements Sink.OfDouble {
            private final double[] array;

            OfDouble(Spliterator<P_IN> spliterator, PipelineHelper<Double> helper, double[] array) {
                super(spliterator, helper, array.length);
                this.array = array;
            }

            OfDouble(OfDouble<P_IN> parent, Spliterator<P_IN> spliterator, long offset, long length) {
                super(parent, spliterator, offset, length, parent.array.length);
                this.array = parent.array;
            }

            @Override
            OfDouble<P_IN> makeChild(Spliterator<P_IN> spliterator, long offset, long size) {
                return new OfDouble<P_IN>(this, spliterator, offset, size);
            }

            @Override
            public void accept(double value) {
                if (this.index >= this.fence) {
                    throw new IndexOutOfBoundsException(Integer.toString(this.index));
                }
                this.array[this.index++] = value;
            }

            @Override
            public void accept(Double i) {
                SinkDefaults.OfDouble.accept(this, i);
            }
        }

        static final class OfLong<P_IN>
        extends SizedCollectorTask<P_IN, Long, Sink.OfLong, OfLong<P_IN>>
        implements Sink.OfLong {
            private final long[] array;

            OfLong(Spliterator<P_IN> spliterator, PipelineHelper<Long> helper, long[] array) {
                super(spliterator, helper, array.length);
                this.array = array;
            }

            OfLong(OfLong<P_IN> parent, Spliterator<P_IN> spliterator, long offset, long length) {
                super(parent, spliterator, offset, length, parent.array.length);
                this.array = parent.array;
            }

            @Override
            OfLong<P_IN> makeChild(Spliterator<P_IN> spliterator, long offset, long size) {
                return new OfLong<P_IN>(this, spliterator, offset, size);
            }

            @Override
            public void accept(long value) {
                if (this.index >= this.fence) {
                    throw new IndexOutOfBoundsException(Integer.toString(this.index));
                }
                this.array[this.index++] = value;
            }

            @Override
            public void accept(Long i) {
                SinkDefaults.OfLong.accept(this, i);
            }
        }

        static final class OfInt<P_IN>
        extends SizedCollectorTask<P_IN, Integer, Sink.OfInt, OfInt<P_IN>>
        implements Sink.OfInt {
            private final int[] array;

            OfInt(Spliterator<P_IN> spliterator, PipelineHelper<Integer> helper, int[] array) {
                super(spliterator, helper, array.length);
                this.array = array;
            }

            OfInt(OfInt<P_IN> parent, Spliterator<P_IN> spliterator, long offset, long length) {
                super(parent, spliterator, offset, length, parent.array.length);
                this.array = parent.array;
            }

            @Override
            OfInt<P_IN> makeChild(Spliterator<P_IN> spliterator, long offset, long size) {
                return new OfInt<P_IN>(this, spliterator, offset, size);
            }

            @Override
            public void accept(int value) {
                if (this.index >= this.fence) {
                    throw new IndexOutOfBoundsException(Integer.toString(this.index));
                }
                this.array[this.index++] = value;
            }

            @Override
            public void accept(Integer i) {
                SinkDefaults.OfInt.accept(this, i);
            }
        }

        static final class OfRef<P_IN, P_OUT>
        extends SizedCollectorTask<P_IN, P_OUT, Sink<P_OUT>, OfRef<P_IN, P_OUT>>
        implements Sink<P_OUT> {
            private final P_OUT[] array;

            OfRef(Spliterator<P_IN> spliterator, PipelineHelper<P_OUT> helper, P_OUT[] array) {
                super(spliterator, helper, array.length);
                this.array = array;
            }

            OfRef(OfRef<P_IN, P_OUT> parent, Spliterator<P_IN> spliterator, long offset, long length) {
                super(parent, spliterator, offset, length, parent.array.length);
                this.array = parent.array;
            }

            @Override
            OfRef<P_IN, P_OUT> makeChild(Spliterator<P_IN> spliterator, long offset, long size) {
                return new OfRef<P_IN, P_OUT>(this, spliterator, offset, size);
            }

            @Override
            public void accept(P_OUT value) {
                if (this.index >= this.fence) {
                    throw new IndexOutOfBoundsException(Integer.toString(this.index));
                }
                this.array[this.index++] = value;
            }
        }
    }

    private static final class DoubleSpinedNodeBuilder
    extends SpinedBuffer.OfDouble
    implements Node.OfDouble,
    Node.Builder.OfDouble {
        DoubleSpinedNodeBuilder() {
        }

        @Override
        public Node.OfDouble truncate(long from, long to, IntFunction<Double[]> generator) {
            return OfDouble.truncate(this, from, to, generator);
        }

        @Override
        public Spliterator.OfDouble spliterator() {
            return super.spliterator();
        }

        @Override
        public void forEach(DoubleConsumer consumer) {
            super.forEach(consumer);
        }

        @Override
        public void begin(long size) {
            this.clear();
            this.ensureCapacity(size);
        }

        @Override
        public void accept(double i) {
            super.accept(i);
        }

        @Override
        public void accept(Double i) {
            SinkDefaults.OfDouble.accept(this, i);
        }

        @Override
        public void end() {
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(int value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(long value) {
            SinkDefaults.reject();
        }

        @Override
        public void copyInto(double[] array, int offset) {
            super.copyInto(array, offset);
        }

        @Override
        public void copyInto(Double[] boxed, int offset) {
            OfDouble.copyInto(this, boxed, offset);
        }

        @Override
        public double[] asPrimitiveArray() {
            return (double[])super.asPrimitiveArray();
        }

        public Double[] asArray(IntFunction<Double[]> generator) {
            return OfPrimitive.asArray(this, generator);
        }

        @Override
        public Node.OfDouble build() {
            return this;
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node.OfDouble getChild(int i) {
            return (Node.OfDouble)OfPrimitive.getChild();
        }

        @Override
        public StreamShape getShape() {
            return OfDouble.getShape();
        }
    }

    private static final class LongSpinedNodeBuilder
    extends SpinedBuffer.OfLong
    implements Node.OfLong,
    Node.Builder.OfLong {
        LongSpinedNodeBuilder() {
        }

        @Override
        public Node.OfLong truncate(long from, long to, IntFunction<Long[]> generator) {
            return OfLong.truncate(this, from, to, generator);
        }

        @Override
        public Spliterator.OfLong spliterator() {
            return super.spliterator();
        }

        @Override
        public void forEach(LongConsumer consumer) {
            super.forEach(consumer);
        }

        @Override
        public void begin(long size) {
            this.clear();
            this.ensureCapacity(size);
        }

        @Override
        public void accept(long i) {
            super.accept(i);
        }

        @Override
        public void accept(Long t) {
            SinkDefaults.OfLong.accept(this, t);
        }

        @Override
        public void end() {
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(int value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(double value) {
            SinkDefaults.reject();
        }

        @Override
        public void copyInto(long[] array, int offset) {
            super.copyInto(array, offset);
        }

        @Override
        public void copyInto(Long[] boxed, int offset) {
            OfLong.copyInto(this, boxed, offset);
        }

        @Override
        public long[] asPrimitiveArray() {
            return (long[])super.asPrimitiveArray();
        }

        public Long[] asArray(IntFunction<Long[]> generator) {
            return OfPrimitive.asArray(this, generator);
        }

        @Override
        public StreamShape getShape() {
            return OfLong.getShape();
        }

        @Override
        public Node.OfLong build() {
            return this;
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node.OfLong getChild(int i) {
            return (Node.OfLong)OfPrimitive.getChild();
        }
    }

    private static final class IntSpinedNodeBuilder
    extends SpinedBuffer.OfInt
    implements Node.OfInt,
    Node.Builder.OfInt {
        IntSpinedNodeBuilder() {
        }

        @Override
        public Spliterator.OfInt spliterator() {
            return super.spliterator();
        }

        @Override
        public void forEach(IntConsumer consumer) {
            super.forEach(consumer);
        }

        @Override
        public void begin(long size) {
            this.clear();
            this.ensureCapacity(size);
        }

        @Override
        public void accept(int i) {
            super.accept(i);
        }

        @Override
        public void accept(Integer t) {
            SinkDefaults.OfInt.accept(this, t);
        }

        @Override
        public void end() {
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(long value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(double value) {
            SinkDefaults.reject();
        }

        @Override
        public void copyInto(int[] array, int offset) throws IndexOutOfBoundsException {
            super.copyInto(array, offset);
        }

        @Override
        public void copyInto(Integer[] boxed, int offset) {
            OfInt.copyInto(this, boxed, offset);
        }

        @Override
        public Node.OfInt truncate(long from, long to, IntFunction<Integer[]> generator) {
            return OfInt.truncate(this, from, to, generator);
        }

        @Override
        public int[] asPrimitiveArray() {
            return (int[])super.asPrimitiveArray();
        }

        public Integer[] asArray(IntFunction<Integer[]> generator) {
            return OfPrimitive.asArray(this, generator);
        }

        @Override
        public StreamShape getShape() {
            return OfInt.getShape();
        }

        @Override
        public Node.OfInt build() {
            return this;
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node.OfInt getChild(int i) {
            return (Node.OfInt)OfPrimitive.getChild();
        }
    }

    private static final class DoubleFixedNodeBuilder
    extends DoubleArrayNode
    implements Node.Builder.OfDouble {
        DoubleFixedNodeBuilder(long size) {
            super(size);
        }

        @Override
        public Node.OfDouble build() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("Current size %d is less than fixed size %d", this.curSize, this.array.length));
            }
            return this;
        }

        @Override
        public void begin(long size) {
            if (size != (long)this.array.length) {
                throw new IllegalStateException(String.format("Begin size %d is not equal to fixed size %d", size, this.array.length));
            }
            this.curSize = 0;
        }

        @Override
        public void accept(double i) {
            if (this.curSize >= this.array.length) {
                throw new IllegalStateException(String.format("Accept exceeded fixed size of %d", this.array.length));
            }
            this.array[this.curSize++] = i;
        }

        @Override
        public void accept(Double i) {
            SinkDefaults.OfDouble.accept(this, i);
        }

        @Override
        public void end() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("End size %d is less than fixed size %d", this.curSize, this.array.length));
            }
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(int value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(long value) {
            SinkDefaults.reject();
        }

        @Override
        public String toString() {
            return String.format("DoubleFixedNodeBuilder[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class LongFixedNodeBuilder
    extends LongArrayNode
    implements Node.Builder.OfLong {
        LongFixedNodeBuilder(long size) {
            super(size);
        }

        @Override
        public Node.OfLong build() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("Current size %d is less than fixed size %d", this.curSize, this.array.length));
            }
            return this;
        }

        @Override
        public void begin(long size) {
            if (size != (long)this.array.length) {
                throw new IllegalStateException(String.format("Begin size %d is not equal to fixed size %d", size, this.array.length));
            }
            this.curSize = 0;
        }

        @Override
        public void accept(long i) {
            if (this.curSize >= this.array.length) {
                throw new IllegalStateException(String.format("Accept exceeded fixed size of %d", this.array.length));
            }
            this.array[this.curSize++] = i;
        }

        @Override
        public void accept(Long t) {
            SinkDefaults.OfLong.accept(this, t);
        }

        @Override
        public void end() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("End size %d is less than fixed size %d", this.curSize, this.array.length));
            }
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(int value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(double value) {
            SinkDefaults.reject();
        }

        @Override
        public String toString() {
            return String.format("LongFixedNodeBuilder[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class IntFixedNodeBuilder
    extends IntArrayNode
    implements Node.Builder.OfInt {
        IntFixedNodeBuilder(long size) {
            super(size);
        }

        @Override
        public Node.OfInt build() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("Current size %d is less than fixed size %d", this.curSize, this.array.length));
            }
            return this;
        }

        @Override
        public void begin(long size) {
            if (size != (long)this.array.length) {
                throw new IllegalStateException(String.format("Begin size %d is not equal to fixed size %d", size, this.array.length));
            }
            this.curSize = 0;
        }

        @Override
        public void accept(int i) {
            if (this.curSize >= this.array.length) {
                throw new IllegalStateException(String.format("Accept exceeded fixed size of %d", this.array.length));
            }
            this.array[this.curSize++] = i;
        }

        @Override
        public void accept(Integer t) {
            SinkDefaults.OfInt.accept(this, t);
        }

        @Override
        public void end() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("End size %d is less than fixed size %d", this.curSize, this.array.length));
            }
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(long value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(double value) {
            SinkDefaults.reject();
        }

        @Override
        public String toString() {
            return String.format("IntFixedNodeBuilder[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static class DoubleArrayNode
    implements Node.OfDouble {
        final double[] array;
        int curSize;

        DoubleArrayNode(long size) {
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            this.array = new double[(int)size];
            this.curSize = 0;
        }

        DoubleArrayNode(double[] array) {
            this.array = array;
            this.curSize = array.length;
        }

        @Override
        public void forEach(Consumer<? super Double> consumer) {
            OfDouble.forEach(this, consumer);
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node.OfDouble getChild(int i) {
            return (Node.OfDouble)OfPrimitive.getChild();
        }

        @Override
        public Node.OfDouble truncate(long from, long to, IntFunction<Double[]> generator) {
            return OfDouble.truncate(this, from, to, generator);
        }

        @Override
        public Spliterator.OfDouble spliterator() {
            return J8Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public double[] asPrimitiveArray() {
            if (this.array.length == this.curSize) {
                return this.array;
            }
            return Arrays.copyOf(this.array, this.curSize);
        }

        public Double[] asArray(IntFunction<Double[]> generator) {
            return OfPrimitive.asArray(this, generator);
        }

        @Override
        public double[] newArray(int count) {
            return OfDouble.newArray(this, count);
        }

        @Override
        public void copyInto(Double[] boxed, int offset) {
            OfDouble.copyInto(this, boxed, offset);
        }

        @Override
        public StreamShape getShape() {
            return OfDouble.getShape();
        }

        @Override
        public void copyInto(double[] dest, int destOffset) {
            System.arraycopy(this.array, 0, dest, destOffset, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(DoubleConsumer consumer) {
            for (int i = 0; i < this.curSize; ++i) {
                consumer.accept(this.array[i]);
            }
        }

        public String toString() {
            return String.format("DoubleArrayNode[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static class LongArrayNode
    implements Node.OfLong {
        final long[] array;
        int curSize;

        LongArrayNode(long size) {
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            this.array = new long[(int)size];
            this.curSize = 0;
        }

        LongArrayNode(long[] array) {
            this.array = array;
            this.curSize = array.length;
        }

        @Override
        public void forEach(Consumer<? super Long> consumer) {
            OfLong.forEach(this, consumer);
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node.OfLong getChild(int i) {
            return (Node.OfLong)OfPrimitive.getChild();
        }

        @Override
        public void copyInto(Long[] boxed, int offset) {
            OfLong.copyInto(this, boxed, offset);
        }

        @Override
        public Node.OfLong truncate(long from, long to, IntFunction<Long[]> generator) {
            return OfLong.truncate(this, from, to, generator);
        }

        @Override
        public Spliterator.OfLong spliterator() {
            return J8Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public long[] asPrimitiveArray() {
            if (this.array.length == this.curSize) {
                return this.array;
            }
            return Arrays.copyOf(this.array, this.curSize);
        }

        public Long[] asArray(IntFunction<Long[]> generator) {
            return OfPrimitive.asArray(this, generator);
        }

        @Override
        public long[] newArray(int count) {
            return OfLong.newArray(this, count);
        }

        @Override
        public StreamShape getShape() {
            return OfLong.getShape();
        }

        @Override
        public void copyInto(long[] dest, int destOffset) {
            System.arraycopy(this.array, 0, dest, destOffset, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(LongConsumer consumer) {
            for (int i = 0; i < this.curSize; ++i) {
                consumer.accept(this.array[i]);
            }
        }

        public String toString() {
            return String.format("LongArrayNode[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static class IntArrayNode
    implements Node.OfInt {
        final int[] array;
        int curSize;

        IntArrayNode(long size) {
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            this.array = new int[(int)size];
            this.curSize = 0;
        }

        IntArrayNode(int[] array) {
            this.array = array;
            this.curSize = array.length;
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public void forEach(Consumer<? super Integer> consumer) {
            OfInt.forEach(this, consumer);
        }

        @Override
        public Node.OfInt getChild(int i) {
            return (Node.OfInt)OfPrimitive.getChild();
        }

        @Override
        public Spliterator.OfInt spliterator() {
            return J8Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public Node.OfInt truncate(long from, long to, IntFunction<Integer[]> generator) {
            return OfInt.truncate(this, from, to, generator);
        }

        @Override
        public void copyInto(Integer[] boxed, int offset) {
            OfInt.copyInto(this, boxed, offset);
        }

        @Override
        public int[] asPrimitiveArray() {
            if (this.array.length == this.curSize) {
                return this.array;
            }
            return Arrays.copyOf(this.array, this.curSize);
        }

        public Integer[] asArray(IntFunction<Integer[]> generator) {
            return OfPrimitive.asArray(this, generator);
        }

        @Override
        public int[] newArray(int count) {
            return OfInt.newArray(this, count);
        }

        @Override
        public StreamShape getShape() {
            return OfInt.getShape();
        }

        @Override
        public void copyInto(int[] dest, int destOffset) {
            System.arraycopy(this.array, 0, dest, destOffset, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(IntConsumer consumer) {
            for (int i = 0; i < this.curSize; ++i) {
                consumer.accept(this.array[i]);
            }
        }

        public String toString() {
            return String.format("IntArrayNode[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class SpinedNodeBuilder<T>
    extends SpinedBuffer<T>
    implements Node<T>,
    Node.Builder<T> {
        SpinedNodeBuilder() {
        }

        @Override
        public Spliterator<T> spliterator() {
            return super.spliterator();
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            super.forEach(consumer);
        }

        @Override
        public StreamShape getShape() {
            return Nodes.getShape();
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node<T> getChild(int i) {
            return Nodes.getChild();
        }

        @Override
        public Node<T> truncate(long from, long to, IntFunction<T[]> generator) {
            return Nodes.truncate(this, from, to, generator);
        }

        @Override
        public void begin(long size) {
            this.clear();
            this.ensureCapacity(size);
        }

        @Override
        public void accept(T t) {
            super.accept(t);
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(int value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(long value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(double value) {
            SinkDefaults.reject();
        }

        @Override
        public void end() {
        }

        @Override
        public void copyInto(T[] array, int offset) {
            super.copyInto(array, offset);
        }

        @Override
        public T[] asArray(IntFunction<T[]> arrayFactory) {
            return super.asArray(arrayFactory);
        }

        @Override
        public Node<T> build() {
            return this;
        }
    }

    private static final class FixedNodeBuilder<T>
    extends ArrayNode<T>
    implements Node.Builder<T> {
        FixedNodeBuilder(long size, IntFunction<T[]> generator) {
            super(size, generator);
        }

        @Override
        public Node<T> build() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("Current size %d is less than fixed size %d", this.curSize, this.array.length));
            }
            return this;
        }

        @Override
        public void begin(long size) {
            if (size != (long)this.array.length) {
                throw new IllegalStateException(String.format("Begin size %d is not equal to fixed size %d", size, this.array.length));
            }
            this.curSize = 0;
        }

        @Override
        public void accept(T t) {
            if (this.curSize >= this.array.length) {
                throw new IllegalStateException(String.format("Accept exceeded fixed size of %d", this.array.length));
            }
            this.array[this.curSize++] = t;
        }

        @Override
        public void end() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("End size %d is less than fixed size %d", this.curSize, this.array.length));
            }
        }

        @Override
        public boolean cancellationRequested() {
            return false;
        }

        @Override
        public void accept(int value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(long value) {
            SinkDefaults.reject();
        }

        @Override
        public void accept(double value) {
            SinkDefaults.reject();
        }

        @Override
        public String toString() {
            return String.format("FixedNodeBuilder[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static abstract class InternalNodeSpliterator<T, S extends Spliterator<T>, N extends Node<T>>
    implements Spliterator<T> {
        N curNode;
        int curChildIndex;
        S lastNodeSpliterator;
        S tryAdvanceSpliterator;
        Deque<N> tryAdvanceStack;

        InternalNodeSpliterator(N curNode) {
            this.curNode = curNode;
        }

        protected final Deque<N> initStack() {
            ArrayDeque stack = new ArrayDeque(8);
            for (int i = this.curNode.getChildCount() - 1; i >= this.curChildIndex; --i) {
                stack.addFirst(this.curNode.getChild(i));
            }
            return stack;
        }

        protected final N findNextLeafNode(Deque<N> stack) {
            Node n = null;
            while ((n = (Node)stack.pollFirst()) != null) {
                if (n.getChildCount() == 0) {
                    if (n.count() <= 0L) continue;
                    return (N)n;
                }
                for (int i = n.getChildCount() - 1; i >= 0; --i) {
                    stack.addFirst(n.getChild(i));
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected final boolean initTryAdvance() {
            if (this.curNode == null) {
                return false;
            }
            if (this.tryAdvanceSpliterator != null) return true;
            if (this.lastNodeSpliterator != null) {
                this.tryAdvanceSpliterator = this.lastNodeSpliterator;
                return true;
            }
            this.tryAdvanceStack = this.initStack();
            N leaf = this.findNextLeafNode(this.tryAdvanceStack);
            if (leaf != null) {
                this.tryAdvanceSpliterator = leaf.spliterator();
                return true;
            }
            this.curNode = null;
            return false;
        }

        public final S trySplit() {
            if (this.curNode == null || this.tryAdvanceSpliterator != null) {
                return null;
            }
            if (this.lastNodeSpliterator != null) {
                return (S)this.lastNodeSpliterator.trySplit();
            }
            if (this.curChildIndex < this.curNode.getChildCount() - 1) {
                return (S)this.curNode.getChild(this.curChildIndex++).spliterator();
            }
            this.curNode = this.curNode.getChild(this.curChildIndex);
            if (this.curNode.getChildCount() == 0) {
                this.lastNodeSpliterator = this.curNode.spliterator();
                return (S)this.lastNodeSpliterator.trySplit();
            }
            this.curChildIndex = 0;
            return (S)this.curNode.getChild(this.curChildIndex++).spliterator();
        }

        @Override
        public final long estimateSize() {
            if (this.curNode == null) {
                return 0L;
            }
            if (this.lastNodeSpliterator != null) {
                return this.lastNodeSpliterator.estimateSize();
            }
            long size = 0L;
            for (int i = this.curChildIndex; i < this.curNode.getChildCount(); ++i) {
                size += this.curNode.getChild(i).count();
            }
            return size;
        }

        @Override
        public final int characteristics() {
            return 64;
        }

        private static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble>
        implements Spliterator.OfDouble {
            OfDouble(Node.OfDouble cur) {
                super(cur);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Double> action) {
                return Spliterators.OfDouble.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Double> action) {
                Spliterators.OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
            }
        }

        private static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong>
        implements Spliterator.OfLong {
            OfLong(Node.OfLong cur) {
                super(cur);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Long> action) {
                return Spliterators.OfLong.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Long> action) {
                Spliterators.OfLong.forEachRemaining((Spliterator.OfLong)this, action);
            }
        }

        private static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt>
        implements Spliterator.OfInt {
            OfInt(Node.OfInt cur) {
                super(cur);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Integer> action) {
                return Spliterators.OfInt.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Integer> action) {
                Spliterators.OfInt.forEachRemaining((Spliterator.OfInt)this, action);
            }
        }

        private static abstract class OfPrimitive<T, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, N extends Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, N>>
        extends InternalNodeSpliterator<T, T_SPLITR, N>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(N cur) {
                super(cur);
            }

            @Override
            public boolean tryAdvance(T_CONS consumer) {
                if (!this.initTryAdvance()) {
                    return false;
                }
                boolean hasNext = ((Spliterator.OfPrimitive)this.tryAdvanceSpliterator).tryAdvance(consumer);
                if (!hasNext) {
                    Node.OfPrimitive leaf;
                    if (this.lastNodeSpliterator == null && (leaf = (Node.OfPrimitive)this.findNextLeafNode(this.tryAdvanceStack)) != null) {
                        this.tryAdvanceSpliterator = leaf.spliterator();
                        return ((Spliterator.OfPrimitive)this.tryAdvanceSpliterator).tryAdvance(consumer);
                    }
                    this.curNode = null;
                }
                return hasNext;
            }

            @Override
            public void forEachRemaining(T_CONS consumer) {
                if (this.curNode == null) {
                    return;
                }
                if (this.tryAdvanceSpliterator == null) {
                    if (this.lastNodeSpliterator == null) {
                        Node.OfPrimitive leaf;
                        Deque stack = this.initStack();
                        while ((leaf = (Node.OfPrimitive)this.findNextLeafNode(stack)) != null) {
                            leaf.forEach(consumer);
                        }
                        this.curNode = null;
                    } else {
                        ((Spliterator.OfPrimitive)this.lastNodeSpliterator).forEachRemaining(consumer);
                    }
                } else {
                    while (this.tryAdvance(consumer)) {
                    }
                }
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super T> getComparator() {
                return Spliterators.getComparator(this);
            }
        }

        private static final class OfRef<T>
        extends InternalNodeSpliterator<T, Spliterator<T>, Node<T>> {
            OfRef(Node<T> curNode) {
                super(curNode);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (!this.initTryAdvance()) {
                    return false;
                }
                boolean hasNext = this.tryAdvanceSpliterator.tryAdvance(consumer);
                if (!hasNext) {
                    Object leaf;
                    if (this.lastNodeSpliterator == null && (leaf = this.findNextLeafNode(this.tryAdvanceStack)) != null) {
                        this.tryAdvanceSpliterator = leaf.spliterator();
                        return this.tryAdvanceSpliterator.tryAdvance(consumer);
                    }
                    this.curNode = null;
                }
                return hasNext;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                if (this.curNode == null) {
                    return;
                }
                if (this.tryAdvanceSpliterator == null) {
                    if (this.lastNodeSpliterator == null) {
                        Object leaf;
                        Deque stack = this.initStack();
                        while ((leaf = this.findNextLeafNode(stack)) != null) {
                            leaf.forEach(consumer);
                        }
                        this.curNode = null;
                    } else {
                        this.lastNodeSpliterator.forEachRemaining(consumer);
                    }
                } else {
                    while (this.tryAdvance(consumer)) {
                    }
                }
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super T> getComparator() {
                return Spliterators.getComparator(this);
            }
        }
    }

    static final class ConcNode<T>
    extends AbstractConcNode<T, Node<T>>
    implements Node<T> {
        ConcNode(Node<T> left, Node<T> right) {
            super(left, right);
        }

        @Override
        public Spliterator<T> spliterator() {
            return new InternalNodeSpliterator.OfRef(this);
        }

        @Override
        public void copyInto(T[] array, int offset) {
            Objects.requireNonNull(array);
            this.left.copyInto(array, offset);
            this.right.copyInto(array, offset + (int)this.left.count());
        }

        @Override
        public T[] asArray(IntFunction<T[]> generator) {
            long size = this.count();
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            T[] array = generator.apply((int)size);
            this.copyInto(array, 0);
            return array;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            this.left.forEach(consumer);
            this.right.forEach(consumer);
        }

        @Override
        public Node<T> truncate(long from, long to, IntFunction<T[]> generator) {
            if (from == 0L && to == this.count()) {
                return this;
            }
            long leftCount = this.left.count();
            if (from >= leftCount) {
                return this.right.truncate(from - leftCount, to - leftCount, generator);
            }
            if (to <= leftCount) {
                return this.left.truncate(from, to, generator);
            }
            return Nodes.conc(this.getShape(), this.left.truncate(from, leftCount, generator), this.right.truncate(0L, to - leftCount, generator));
        }

        public String toString() {
            if (this.count() < 32L) {
                return String.format("ConcNode[%s.%s]", this.left, this.right);
            }
            return String.format("ConcNode[size=%d]", this.count());
        }

        static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble>
        implements Node.OfDouble {
            OfDouble(Node.OfDouble left, Node.OfDouble right) {
                super(left, right);
            }

            @Override
            public void forEach(Consumer<? super Double> consumer) {
                java8.util.stream.Nodes$OfDouble.forEach(this, consumer);
            }

            @Override
            public Node.OfDouble truncate(long from, long to, IntFunction<Double[]> generator) {
                return java8.util.stream.Nodes$OfDouble.truncate(this, from, to, generator);
            }

            @Override
            public Spliterator.OfDouble spliterator() {
                return new InternalNodeSpliterator.OfDouble(this);
            }

            @Override
            public void copyInto(Double[] boxed, int offset) {
                java8.util.stream.Nodes$OfDouble.copyInto(this, boxed, offset);
            }

            @Override
            public double[] newArray(int count) {
                return java8.util.stream.Nodes$OfDouble.newArray(this, count);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong>
        implements Node.OfLong {
            OfLong(Node.OfLong left, Node.OfLong right) {
                super(left, right);
            }

            @Override
            public void forEach(Consumer<? super Long> consumer) {
                java8.util.stream.Nodes$OfLong.forEach(this, consumer);
            }

            @Override
            public Node.OfLong truncate(long from, long to, IntFunction<Long[]> generator) {
                return java8.util.stream.Nodes$OfLong.truncate(this, from, to, generator);
            }

            @Override
            public Spliterator.OfLong spliterator() {
                return new InternalNodeSpliterator.OfLong(this);
            }

            @Override
            public void copyInto(Long[] boxed, int offset) {
                java8.util.stream.Nodes$OfLong.copyInto(this, boxed, offset);
            }

            @Override
            public long[] newArray(int count) {
                return java8.util.stream.Nodes$OfLong.newArray(this, count);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt>
        implements Node.OfInt {
            OfInt(Node.OfInt left, Node.OfInt right) {
                super(left, right);
            }

            @Override
            public void forEach(Consumer<? super Integer> consumer) {
                java8.util.stream.Nodes$OfInt.forEach(this, consumer);
            }

            @Override
            public Spliterator.OfInt spliterator() {
                return new InternalNodeSpliterator.OfInt(this);
            }

            @Override
            public Node.OfInt truncate(long from, long to, IntFunction<Integer[]> generator) {
                return java8.util.stream.Nodes$OfInt.truncate(this, from, to, generator);
            }

            @Override
            public void copyInto(Integer[] boxed, int offset) {
                java8.util.stream.Nodes$OfInt.copyInto(this, boxed, offset);
            }

            @Override
            public int[] newArray(int count) {
                return java8.util.stream.Nodes$OfInt.newArray(this, count);
            }
        }

        private static abstract class OfPrimitive<E, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<E, T_CONS, T_SPLITR>, T_NODE extends Node.OfPrimitive<E, T_CONS, T_ARR, T_SPLITR, T_NODE>>
        extends AbstractConcNode<E, T_NODE>
        implements Node.OfPrimitive<E, T_CONS, T_ARR, T_SPLITR, T_NODE> {
            OfPrimitive(T_NODE left, T_NODE right) {
                super(left, right);
            }

            @Override
            public void forEach(T_CONS consumer) {
                ((Node.OfPrimitive)this.left).forEach(consumer);
                ((Node.OfPrimitive)this.right).forEach(consumer);
            }

            @Override
            public void copyInto(T_ARR array, int offset) {
                ((Node.OfPrimitive)this.left).copyInto(array, offset);
                ((Node.OfPrimitive)this.right).copyInto(array, offset + (int)((Node.OfPrimitive)this.left).count());
            }

            @Override
            public T_ARR asPrimitiveArray() {
                long size = this.count();
                if (size >= 0x7FFFFFF7L) {
                    throw new IllegalArgumentException(Nodes.BAD_SIZE);
                }
                Object array = this.newArray((int)size);
                this.copyInto(array, 0);
                return array;
            }

            @Override
            public E[] asArray(IntFunction<E[]> generator) {
                return java8.util.stream.Nodes$OfPrimitive.asArray(this, generator);
            }

            public String toString() {
                if (this.count() < 32L) {
                    return String.format("%s[%s.%s]", this.getClass().getName(), this.left, this.right);
                }
                return String.format("%s[size=%d]", this.getClass().getName(), this.count());
            }
        }
    }

    private static abstract class AbstractConcNode<T, T_NODE extends Node<T>>
    implements Node<T> {
        protected final T_NODE left;
        protected final T_NODE right;
        private final long size;

        AbstractConcNode(T_NODE left, T_NODE right) {
            this.left = left;
            this.right = right;
            this.size = left.count() + right.count();
        }

        @Override
        public int getChildCount() {
            return 2;
        }

        @Override
        public StreamShape getShape() {
            return Nodes.getShape();
        }

        public T_NODE getChild(int i) {
            if (i == 0) {
                return this.left;
            }
            if (i == 1) {
                return this.right;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public long count() {
            return this.size;
        }
    }

    private static final class CollectionNode<T>
    implements Node<T> {
        private final Collection<T> c;

        CollectionNode(Collection<T> c) {
            this.c = c;
        }

        @Override
        public Spliterator<T> spliterator() {
            return Spliterators.spliterator(this.c);
        }

        @Override
        public StreamShape getShape() {
            return Nodes.getShape();
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node<T> getChild(int i) {
            return Nodes.getChild();
        }

        @Override
        public Node<T> truncate(long from, long to, IntFunction<T[]> generator) {
            return Nodes.truncate(this, from, to, generator);
        }

        @Override
        public void copyInto(T[] array, int offset) {
            for (T t : this.c) {
                array[offset++] = t;
            }
        }

        @Override
        public T[] asArray(IntFunction<T[]> generator) {
            return this.c.toArray(generator.apply(this.c.size()));
        }

        @Override
        public long count() {
            return this.c.size();
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            Objects.requireNonNull(consumer);
            for (T t : this.c) {
                consumer.accept(t);
            }
        }

        public String toString() {
            return String.format("CollectionNode[%d][%s]", this.c.size(), this.c);
        }
    }

    private static class ArrayNode<T>
    implements Node<T> {
        final T[] array;
        int curSize;

        ArrayNode(long size, IntFunction<T[]> generator) {
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            this.array = generator.apply((int)size);
            this.curSize = 0;
        }

        ArrayNode(T[] array) {
            this.array = array;
            this.curSize = array.length;
        }

        @Override
        public Spliterator<T> spliterator() {
            return J8Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public StreamShape getShape() {
            return Nodes.getShape();
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node<T> getChild(int i) {
            return Nodes.getChild();
        }

        @Override
        public Node<T> truncate(long from, long to, IntFunction<T[]> generator) {
            return Nodes.truncate(this, from, to, generator);
        }

        @Override
        public void copyInto(T[] dest, int destOffset) {
            System.arraycopy(this.array, 0, dest, destOffset, this.curSize);
        }

        @Override
        public T[] asArray(IntFunction<T[]> generator) {
            if (this.array.length == this.curSize) {
                return this.array;
            }
            throw new IllegalStateException();
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            for (int i = 0; i < this.curSize; ++i) {
                consumer.accept(this.array[i]);
            }
        }

        public String toString() {
            return String.format("ArrayNode[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static abstract class EmptyNode<T, T_ARR, T_CONS>
    implements Node<T> {
        EmptyNode() {
        }

        @Override
        public T[] asArray(IntFunction<T[]> generator) {
            return generator.apply(0);
        }

        public void copyInto(T_ARR array, int offset) {
        }

        @Override
        public long count() {
            return 0L;
        }

        @Override
        public StreamShape getShape() {
            return Nodes.getShape();
        }

        @Override
        public int getChildCount() {
            return Nodes.getChildCount();
        }

        @Override
        public Node<T> getChild(int i) {
            return Nodes.getChild();
        }

        @Override
        public Node<T> truncate(long from, long to, IntFunction<T[]> generator) {
            return Nodes.truncate(this, from, to, generator);
        }

        public void forEach(T_CONS consumer) {
        }

        private static final class OfDouble
        extends EmptyNode<Double, double[], DoubleConsumer>
        implements Node.OfDouble {
            OfDouble() {
            }

            @Override
            public void forEach(Consumer<? super Double> consumer) {
                java8.util.stream.Nodes$OfDouble.forEach(this, consumer);
            }

            @Override
            public Node.OfDouble getChild(int i) {
                return (Node.OfDouble)OfPrimitive.getChild();
            }

            @Override
            public Node.OfDouble truncate(long from, long to, IntFunction<Double[]> generator) {
                return java8.util.stream.Nodes$OfDouble.truncate(this, from, to, generator);
            }

            @Override
            public Spliterator.OfDouble spliterator() {
                return Spliterators.emptyDoubleSpliterator();
            }

            @Override
            public void copyInto(Double[] boxed, int offset) {
                java8.util.stream.Nodes$OfDouble.copyInto(this, boxed, offset);
            }

            @Override
            public double[] asPrimitiveArray() {
                return EMPTY_DOUBLE_ARRAY;
            }

            @Override
            public double[] newArray(int count) {
                return java8.util.stream.Nodes$OfDouble.newArray(this, count);
            }
        }

        private static final class OfLong
        extends EmptyNode<Long, long[], LongConsumer>
        implements Node.OfLong {
            OfLong() {
            }

            @Override
            public void forEach(Consumer<? super Long> consumer) {
                java8.util.stream.Nodes$OfLong.forEach(this, consumer);
            }

            @Override
            public Spliterator.OfLong spliterator() {
                return Spliterators.emptyLongSpliterator();
            }

            @Override
            public Node.OfLong getChild(int i) {
                return (Node.OfLong)OfPrimitive.getChild();
            }

            @Override
            public Node.OfLong truncate(long from, long to, IntFunction<Long[]> generator) {
                return java8.util.stream.Nodes$OfLong.truncate(this, from, to, generator);
            }

            @Override
            public long[] asPrimitiveArray() {
                return EMPTY_LONG_ARRAY;
            }

            @Override
            public void copyInto(Long[] boxed, int offset) {
                java8.util.stream.Nodes$OfLong.copyInto(this, boxed, offset);
            }

            @Override
            public long[] newArray(int count) {
                return java8.util.stream.Nodes$OfLong.newArray(this, count);
            }
        }

        private static final class OfInt
        extends EmptyNode<Integer, int[], IntConsumer>
        implements Node.OfInt {
            OfInt() {
            }

            @Override
            public void forEach(Consumer<? super Integer> consumer) {
                java8.util.stream.Nodes$OfInt.forEach(this, consumer);
            }

            @Override
            public Spliterator.OfInt spliterator() {
                return Spliterators.emptyIntSpliterator();
            }

            @Override
            public Node.OfInt getChild(int i) {
                return (Node.OfInt)OfPrimitive.getChild();
            }

            @Override
            public Node.OfInt truncate(long from, long to, IntFunction<Integer[]> generator) {
                return java8.util.stream.Nodes$OfInt.truncate(this, from, to, generator);
            }

            @Override
            public int[] asPrimitiveArray() {
                return EMPTY_INT_ARRAY;
            }

            @Override
            public void copyInto(Integer[] boxed, int offset) {
                java8.util.stream.Nodes$OfInt.copyInto(this, boxed, offset);
            }

            @Override
            public int[] newArray(int count) {
                return java8.util.stream.Nodes$OfInt.newArray(this, count);
            }
        }

        private static class OfRef<T>
        extends EmptyNode<T, T[], Consumer<? super T>> {
            private OfRef() {
            }

            @Override
            public Spliterator<T> spliterator() {
                return Spliterators.emptySpliterator();
            }
        }
    }

    static final class OfInt {
        static Node.OfInt truncate(Node.OfInt this_, long from, long to, IntFunction<Integer[]> generator) {
            if (from == 0L && to == this_.count()) {
                return this_;
            }
            long size = to - from;
            Spliterator.OfInt spliterator = (Spliterator.OfInt)this_.spliterator();
            Node.Builder.OfInt nodeBuilder = Nodes.intBuilder(size);
            nodeBuilder.begin(size);
            int i = 0;
            while ((long)i < from && spliterator.tryAdvance(Nodes$OfInt$$Lambda$1.lambdaFactory$())) {
                ++i;
            }
            if (to == this_.count()) {
                spliterator.forEachRemaining(nodeBuilder);
            } else {
                i = 0;
                while ((long)i < size && spliterator.tryAdvance(nodeBuilder)) {
                    ++i;
                }
            }
            nodeBuilder.end();
            return nodeBuilder.build();
        }

        static void forEach(Node.OfInt this_, Consumer<? super Integer> consumer) {
            if (consumer instanceof IntConsumer) {
                this_.forEach((IntConsumer)((Object)consumer));
            } else {
                ((Spliterator.OfInt)this_.spliterator()).forEachRemaining(consumer);
            }
        }

        static void copyInto(Node.OfInt this_, Integer[] boxed, int offset) {
            int[] array = (int[])this_.asPrimitiveArray();
            for (int i = 0; i < array.length; ++i) {
                boxed[offset + i] = array[i];
            }
        }

        static int[] newArray(Node.OfInt this_, int count) {
            return new int[count];
        }

        static StreamShape getShape() {
            return StreamShape.INT_VALUE;
        }

        private OfInt() {
        }

        static /* synthetic */ void lambda$truncate$106(int e) {
        }
    }

    static final class OfLong {
        static Node.OfLong truncate(Node.OfLong this_, long from, long to, IntFunction<Long[]> generator) {
            if (from == 0L && to == this_.count()) {
                return this_;
            }
            long size = to - from;
            Spliterator.OfLong spliterator = (Spliterator.OfLong)this_.spliterator();
            Node.Builder.OfLong nodeBuilder = Nodes.longBuilder(size);
            nodeBuilder.begin(size);
            int i = 0;
            while ((long)i < from && spliterator.tryAdvance(Nodes$OfLong$$Lambda$1.lambdaFactory$())) {
                ++i;
            }
            if (to == this_.count()) {
                spliterator.forEachRemaining(nodeBuilder);
            } else {
                i = 0;
                while ((long)i < size && spliterator.tryAdvance(nodeBuilder)) {
                    ++i;
                }
            }
            nodeBuilder.end();
            return nodeBuilder.build();
        }

        static void forEach(Node.OfLong this_, Consumer<? super Long> consumer) {
            if (consumer instanceof LongConsumer) {
                this_.forEach((LongConsumer)((Object)consumer));
            } else {
                ((Spliterator.OfLong)this_.spliterator()).forEachRemaining(consumer);
            }
        }

        static void copyInto(Node.OfLong this_, Long[] boxed, int offset) {
            long[] array = (long[])this_.asPrimitiveArray();
            for (int i = 0; i < array.length; ++i) {
                boxed[offset + i] = array[i];
            }
        }

        static long[] newArray(Node.OfLong this_, int count) {
            return new long[count];
        }

        static StreamShape getShape() {
            return StreamShape.LONG_VALUE;
        }

        private OfLong() {
        }

        static /* synthetic */ void lambda$truncate$105(long e) {
        }
    }

    static final class OfDouble {
        static Node.OfDouble truncate(Node.OfDouble this_, long from, long to, IntFunction<Double[]> generator) {
            if (from == 0L && to == this_.count()) {
                return this_;
            }
            long size = to - from;
            Spliterator.OfDouble spliterator = (Spliterator.OfDouble)this_.spliterator();
            Node.Builder.OfDouble nodeBuilder = Nodes.doubleBuilder(size);
            nodeBuilder.begin(size);
            int i = 0;
            while ((long)i < from && spliterator.tryAdvance(Nodes$OfDouble$$Lambda$1.lambdaFactory$())) {
                ++i;
            }
            if (to == this_.count()) {
                spliterator.forEachRemaining(nodeBuilder);
            } else {
                i = 0;
                while ((long)i < size && spliterator.tryAdvance(nodeBuilder)) {
                    ++i;
                }
            }
            nodeBuilder.end();
            return nodeBuilder.build();
        }

        static void forEach(Node.OfDouble this_, Consumer<? super Double> consumer) {
            if (consumer instanceof DoubleConsumer) {
                this_.forEach((DoubleConsumer)((Object)consumer));
            } else {
                ((Spliterator.OfDouble)this_.spliterator()).forEachRemaining(consumer);
            }
        }

        static void copyInto(Node.OfDouble this_, Double[] boxed, int offset) {
            double[] array = (double[])this_.asPrimitiveArray();
            for (int i = 0; i < array.length; ++i) {
                boxed[offset + i] = array[i];
            }
        }

        static double[] newArray(Node.OfDouble this_, int count) {
            return new double[count];
        }

        static StreamShape getShape() {
            return StreamShape.DOUBLE_VALUE;
        }

        private OfDouble() {
        }

        static /* synthetic */ void lambda$truncate$104(double e) {
        }
    }

    static final class OfPrimitive {
        static <T, T_CONS, T_ARR, T_NODE extends Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>> T_NODE getChild() {
            throw new IndexOutOfBoundsException();
        }

        static <T, T_CONS, T_ARR, T_NODE extends Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>> T[] asArray(Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE> this_, IntFunction<T[]> generator) {
            long size = this_.count();
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            T[] boxed = generator.apply((int)this_.count());
            this_.copyInto(boxed, 0);
            return boxed;
        }

        private OfPrimitive() {
        }
    }
}

