/*
 * Created on Sep 23, 2005 
 */
package net.sourceforge.wife.swift.parser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.Validate;

public class SwiftBlock {
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(SwiftBlock.class);
    protected String id;
    protected final Map fields = new Hashtable();
    protected String onlyValue;
    
    /**
     * Gets the id.
     * 
     * @return Returns the id.
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the id
     *
     * @param id The id to set.
     */
    public void setId(String id) {
        this.id = id;
    }

    public void addField(String name, String value) {
        log.debug("Adding field "+name+" with value "+value);
        Validate.notNull(name, "name is null");
        Validate.notNull(value, "value is null");
        if (fields.containsKey(name)) {
            log.debug("Key "+name+" alredy contained, creating list");
            Object o = fields.get(name);
            if (o instanceof List) {
                List l = (List)o;
                l.add(value.trim());
                log.debug("list: "+l);
            } else {
                List l = new ArrayList(2);
                l.add(o);
                l.add(value.trim());
                fields.put(name, l);
            }
        } else {
            fields.put(name, value.trim());
        }
        log.debug("fields: "+fields);
    }

    public String getOnlyValue() {
        return onlyValue;
    }

    public void setOnlyValue(String onlyValue) {
        this.onlyValue = onlyValue;
    }

    public boolean containsKey(Object key) {
        return fields.containsKey(key);
    }

    public Object get(Object key) {
        return fields.get(key);
    }

    public boolean isEmpty() {
        return fields.isEmpty();
    }

    public int size() {
        return fields.size();
    }
    
    protected String onlyValueSubstring(int i, int j) {
        if (onlyValue==null)
            throw new IllegalStateException("Attempting to access information on onlyValue, but it is null");
        return onlyValue.substring(i, j);
    }

    /**
     * Gets a map with all fields and values in block.
     * This method is only usfull for multi-field blocks.
     * The map can be freely modified since it is a copy of the original values
     * @return
     */
    public Map getFields() {
        Map ret = new Hashtable(this.fields.size());
        ret.putAll(this.fields);
        return ret;
    }

    public void setData(SwiftBlock block) {
        this.onlyValue = block.getOnlyValue();
        this.fields.clear();
        this.fields.putAll(block.getFields());
        this.id = block.getId();
    }

    public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[SwiftBlock:");
            buffer.append(" log: ");
            buffer.append(log);
            buffer.append(" id: ");
            buffer.append(id);
            buffer.append(" fields: ");
            buffer.append(fields);
            buffer.append(" onlyValue: ");
            buffer.append(onlyValue);
            buffer.append("]");
            return buffer.toString();
        }
}
