/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import net.sourceforge.wurfl.core.CapabilitiesHolder;
import net.sourceforge.wurfl.core.CapabilitiesLoader;
import net.sourceforge.wurfl.core.CapabilityNotDefinedException;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCapabilitiesHolder
implements CapabilitiesHolder,
Serializable {
    private static final long serialVersionUID = 100L;
    private static final Log log;
    private transient CapabilitiesLoader capabilitiesLoader;
    private Map capabilities;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultCapabilitiesHolder(CapabilitiesLoader capabilitiesLoader) {
        this.capabilitiesLoader = capabilitiesLoader;
    }

    public String getCapabilityValue(String capabilityName) throws CapabilityNotDefinedException {
        String value = (String)this.getAllCapabilities().get(capabilityName);
        if (log.isTraceEnabled()) {
            StrBuilder msgBuilder = new StrBuilder();
            msgBuilder.append("Get capability: ").append(capabilityName).append(" = ").append(value);
            log.trace((Object)msgBuilder.toString());
        }
        if (value == null) {
            throw new CapabilityNotDefinedException(capabilityName);
        }
        return value;
    }

    public Map getAllCapabilities() {
        if (this.capabilities == null) {
            if (this.capabilitiesLoader == null) {
                throw new IllegalStateException("The device must be initialized before serialization");
            }
            log.debug((Object)"Initializing capabilities");
            this.capabilities = this.capabilitiesLoader.loadCapabilities();
        }
        if (!$assertionsDisabled && this.capabilities == null) {
            throw new AssertionError();
        }
        return this.capabilities;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.capabilities == null) {
            this.capabilities = this.capabilitiesLoader.loadCapabilities();
        }
        out.defaultWriteObject();
    }

    static {
        $assertionsDisabled = !DefaultCapabilitiesHolder.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)DefaultCapabilitiesHolder.class);
    }
}

