/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.wurfl.core.CapabilitiesLoader;
import net.sourceforge.wurfl.core.resource.DeviceNotInModelException;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.WURFLModel;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCapabilitiesLoader
implements CapabilitiesLoader {
    private WURFLModel model;
    private ModelDevice modelDevice;
    private static final Log log = LogFactory.getLog((Class)DefaultCapabilitiesLoader.class);

    public DefaultCapabilitiesLoader(ModelDevice root, WURFLModel model) {
        this.model = model;
        this.modelDevice = root;
    }

    public Map loadCapabilities() {
        HashMap capabilities;
        block3: {
            capabilities = new HashMap(this.model.getAllCapabilities().size());
            try {
                List hierarchy = this.model.getDeviceHierarchy(this.modelDevice);
                Iterator iterator = hierarchy.iterator();
                while (iterator.hasNext()) {
                    ModelDevice device = (ModelDevice)iterator.next();
                    capabilities.putAll(device.getCapabilities());
                }
            }
            catch (DeviceNotInModelException e) {
                if (!log.isErrorEnabled()) break block3;
                StrBuilder logBuilder = new StrBuilder();
                logBuilder.append("Device: ").append(this.modelDevice.getID()).append(" is not in model. ").append("Capabilities will not loaded.");
                log.error((Object)logBuilder.toString());
            }
        }
        return capabilities;
    }
}

