/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import javax.servlet.http.HttpServletRequest;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.core.WURFLManager;
import net.sourceforge.wurfl.core.WURFLService;
import net.sourceforge.wurfl.core.request.DefaultWURFLRequestFactory;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.request.WURFLRequestFactory;
import org.apache.commons.lang.Validate;

public class DefaultWURFLManager
implements WURFLManager {
    private WURFLService service;
    private WURFLRequestFactory requestFactory;

    public DefaultWURFLManager(WURFLService service, WURFLRequestFactory requestFactory) {
        Validate.notNull((Object)service, (String)"The service must be not null");
        Validate.notNull((Object)requestFactory, (String)"The requestFactory must be not null");
        this.service = service;
        this.requestFactory = requestFactory;
    }

    public DefaultWURFLManager(WURFLService service) {
        this(service, new DefaultWURFLRequestFactory());
    }

    public Device getDeviceForRequest(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"The request must be not null");
        WURFLRequest wurflRequest = this.requestFactory.createRequest(request);
        return this.getDeviceForRequest(wurflRequest);
    }

    public Device getDeviceForRequest(WURFLRequest request) {
        Validate.notNull((Object)request, (String)"The request must be not null");
        return this.service.getDeviceForRequest(request);
    }

    public Device getDeviceForRequest(String userAgent) {
        Validate.notNull((Object)userAgent, (String)"The userAgent must be not null");
        WURFLRequest wurflRequest = this.requestFactory.createRequest(userAgent);
        return this.getDeviceForRequest(wurflRequest);
    }
}

