/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.classifiers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentSkipListMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.commons.collections.set.UnmodifiableSortedSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class FilteredDevices {
    private SortedMap data = new ConcurrentSkipListMap();

    public SortedSet getUserAgents() {
        return UnmodifiableSortedSet.decorate((SortedSet)((SortedSet)this.data.keySet()));
    }

    public Set getDevices() {
        return UnmodifiableSet.decorate(new HashSet(this.data.values()));
    }

    public String getDevice(String userAgent) {
        Validate.notEmpty((String)userAgent, (String)"The userAgent is empty");
        return (String)this.data.get(userAgent);
    }

    public void putDevice(String userAgent, String deviceId) {
        Validate.notEmpty((String)userAgent, (String)"The userAgent is empty");
        Validate.notEmpty((String)deviceId, (String)"The deviceId is empty");
        this.data.put(userAgent, deviceId);
    }

    public boolean containsDevice(String deviceId) {
        Validate.notEmpty((String)deviceId, (String)"The deviceId is empty");
        return this.data.values().contains(deviceId);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getDevices()).toString();
    }
}

