/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.matchers.AbstractMatcher;
import net.sourceforge.wurfl.core.utils.StringUtils;

public class CatchAllMatcher
extends AbstractMatcher {
    private static final int MOZILLA_LD_TOLLERANCE = 4;

    public CatchAllMatcher(Handler handler) {
        super(handler);
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        if (userAgent.startsWith("Mozilla")) {
            if (userAgent.startsWith("Mozilla/4")) {
                return StringUtils.ldMatch(this.getMozillaData(userAgentsSet, "Mozilla/4"), userAgent, 4);
            }
            if (userAgent.startsWith("Mozilla/5")) {
                return StringUtils.ldMatch(this.getMozillaData(userAgentsSet, "Mozilla/5"), userAgent, 4);
            }
            return StringUtils.ldMatch(this.getMozillaData(userAgentsSet, "Mozilla"), userAgent, 4);
        }
        return super.lookForMatchingUserAgent(userAgentsSet, userAgent);
    }

    private SortedSet getMozillaData(SortedSet userAgentsSet, String starting) {
        TreeSet<String> set = new TreeSet<String>();
        Iterator iterator = userAgentsSet.iterator();
        while (iterator.hasNext()) {
            String userAgent = (String)iterator.next();
            if (userAgent == null || !userAgent.startsWith(starting)) continue;
            set.add(userAgent);
        }
        return set;
    }
}

