/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.resource;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ModelDevice
implements Serializable {
    private static final long serialVersionUID = 10L;
    private String userAgent;
    private String id;
    private String fallBack;
    private boolean actualDeviceRoot;
    private Map capabilities = UnmodifiableMap.decorate(new HashMap());
    private Map groupsByCapability = UnmodifiableMap.decorate(new HashMap());
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ModelDevice() {
    }

    public ModelDevice(String userAgent, String id, String fallBack, boolean actualDeviceRoot, Map capabilities, Map groupsByCapability) {
        Validate.notEmpty((String)id, (String)"The id must be not null");
        Validate.notEmpty((String)fallBack, (String)"The fallBack must be not null");
        Validate.notEmpty((String)userAgent, (String)"The userAgent must be not null");
        Validate.notNull((Object)capabilities, (String)"The capabilities must be not null");
        Validate.notNull((Object)groupsByCapability, (String)"The groupsByCapability must be not null");
        Validate.noNullElements(capabilities.values(), (String)"The capabilities can not contain null value");
        Validate.noNullElements(groupsByCapability.values(), (String)"The capabilities can not contain null value");
        Validate.allElementsOfType(capabilities.values(), (Class)String.class, (String)"The capabilities must be a <String,String> map");
        Validate.allElementsOfType(capabilities.keySet(), (Class)String.class, (String)"The capabilities must be a <String,String> map");
        Validate.allElementsOfType(groupsByCapability.values(), (Class)String.class, (String)"The capabilities must be a <String,String> map");
        Validate.allElementsOfType(groupsByCapability.keySet(), (Class)String.class, (String)"The capabilities must be a <String,String> map");
        Validate.isTrue((boolean)((Object)capabilities.keySet()).equals(groupsByCapability.keySet()), (String)"The capabilities and groups must be same Set");
        this.userAgent = userAgent;
        this.id = id;
        this.fallBack = fallBack;
        this.actualDeviceRoot = actualDeviceRoot;
        this.capabilities = UnmodifiableMap.decorate((Map)capabilities);
        this.groupsByCapability = UnmodifiableMap.decorate((Map)groupsByCapability);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getID() {
        return this.id;
    }

    public String getFallBack() {
        return this.fallBack;
    }

    public boolean isActualDeviceRoot() {
        return this.actualDeviceRoot;
    }

    public Map getCapabilities() {
        return this.capabilities;
    }

    public Map getGroupsByCapability() {
        return this.groupsByCapability;
    }

    public boolean defineCapability(String name) {
        return this.capabilities.containsKey(name);
    }

    public String getCapability(String name) {
        if (!$assertionsDisabled && !this.defineCapability(name)) {
            throw new AssertionError((Object)(this.id + " do not define " + name));
        }
        return (String)this.capabilities.get(name);
    }

    public boolean defineGroup(String group) {
        return this.groupsByCapability.containsValue(group);
    }

    public Set getGroups() {
        return new HashSet(this.groupsByCapability.values());
    }

    public String getGroupForCapability(String capability) {
        if (!$assertionsDisabled && !this.defineCapability(capability)) {
            throw new AssertionError();
        }
        return (String)this.groupsByCapability.get(capability);
    }

    public Set getCapabilitiesNamesForGroup(String group) {
        if (!$assertionsDisabled && !this.defineGroup(group)) {
            throw new AssertionError();
        }
        HashSet groupCapabilities = new HashSet();
        Iterator gIt = this.groupsByCapability.entrySet().iterator();
        while (gIt.hasNext()) {
            Map.Entry entry = gIt.next();
            String defineGroup = (String)entry.getValue();
            if (!defineGroup.equals(group)) continue;
            groupCapabilities.add(entry.getKey());
        }
        return groupCapabilities;
    }

    public Map getCapabilitiesForGroup(String group) {
        HashMap groupCapabilities = new HashMap();
        Set capabilitiesNames = this.getCapabilitiesNamesForGroup(group);
        Iterator cnIt = capabilitiesNames.iterator();
        while (cnIt.hasNext()) {
            String name = (String)cnIt.next();
            groupCapabilities.put(name, this.capabilities.get(name));
        }
        return groupCapabilities;
    }

    public int hashCode() {
        HashCodeBuilder hb = new HashCodeBuilder(11, 45);
        hb.append(this.getClass()).append((Object)this.id);
        return hb.toHashCode();
    }

    public boolean equals(Object obj) {
        EqualsBuilder eb = new EqualsBuilder();
        eb.appendSuper(this.getClass().isInstance(obj));
        if (eb.isEquals()) {
            ModelDevice other = (ModelDevice)obj;
            eb.append((Object)this.id, (Object)other.id);
        }
        return eb.isEquals();
    }

    public String toString() {
        ToStringBuilder tb = new ToStringBuilder((Object)this);
        tb.append((Object)this.id);
        return tb.toString();
    }

    static {
        $assertionsDisabled = !ModelDevice.class.desiredAssertionStatus();
    }

    public static final class Builder {
        private ModelDevice device = new ModelDevice();

        public Builder(String id, String userAgent, String fallbakId) {
            this.device.id = id;
            this.device.userAgent = userAgent;
            this.device.fallBack = fallbakId;
        }

        public Builder setActualDeviceRoot(boolean actualDeviceRoot) {
            this.device.actualDeviceRoot = actualDeviceRoot;
            return this;
        }

        public Builder setCapabilities(Map capabilities) {
            this.device.capabilities = capabilities;
            return this;
        }

        public Builder setCapabilitiesByGroup(Map capabilitiesByGroup) {
            this.device.groupsByCapability = capabilitiesByGroup;
            return this;
        }

        public ModelDevice build() {
            return this.device;
        }
    }
}

