/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.text.StrBuilder;

public final class UserAgentUtils {
    public static final Pattern stripQuotePattern = Pattern.compile("\"");
    public static final Pattern nameSpacePattern = Pattern.compile("ns=(\\d*)");

    public static String getUserAgent(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"The HttpServletRequest is null");
        String userAgent = "";
        userAgent = request.getParameter("UA") != null ? "" + request.getParameter("UA") : (request.getHeader("x-device-user-agent") != null ? "" + request.getHeader("x-device-user-agent") : "" + request.getHeader("User-Agent"));
        return userAgent;
    }

    public static String getUaProfile(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"The HttpServletRequest is null");
        String headerName = null;
        String uaProfile = null;
        if (request.getHeader("x-wap-profile") != null) {
            headerName = "x-wap-profile";
        } else if (request.getHeader("Profile") != null) {
            headerName = "Profile";
        } else if (request.getHeader("wap-profile") != null) {
            headerName = "wap-profile";
        } else if (request.getHeader("Opt") != null) {
            String optHeader = request.getHeader("Opt");
            String namespaceNumber = null;
            if (optHeader != null && optHeader.indexOf("ns=") != -1) {
                Matcher matcher = nameSpacePattern.matcher(optHeader);
                try {
                    namespaceNumber = matcher.group(1);
                    StrBuilder sb = new StrBuilder(namespaceNumber);
                    sb.append("-Profile");
                    headerName = sb.toString();
                }
                catch (Exception e) {
                    headerName = null;
                }
            }
        }
        if (headerName != null && headerName.trim().length() > 0) {
            uaProfile = request.getHeader(headerName);
        }
        if (uaProfile != null && uaProfile.trim().length() > 0) {
            stripQuotePattern.matcher(uaProfile).replaceAll("");
        }
        return uaProfile;
    }

    public static boolean isXhtmlRequester(HttpServletRequest httpRequest) {
        Validate.notNull((Object)httpRequest, (String)"HttpRequest is null");
        String acceptHeader = httpRequest.getHeader("accept");
        return acceptHeader != null && (acceptHeader.indexOf("application/vnd.wap.xhtml+xml") != -1 || acceptHeader.indexOf("application/xhtml+xml") != -1 || acceptHeader.indexOf("application/text+html") != -1);
    }

    public static boolean isMobileBrowser(String userAgent) {
        Validate.notNull((Object)userAgent, (String)"userAgent is null");
        return StringUtils.contains((String)userAgent, (String)"Tablet");
    }
}

