/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.wurfl.core.CapabilityNotDefinedException;
import net.sourceforge.wurfl.core.DefaultDeviceProvider;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.core.DeviceNotDefinedException;
import net.sourceforge.wurfl.core.DeviceProvider;
import net.sourceforge.wurfl.core.GroupNotDefinedException;
import net.sourceforge.wurfl.core.resource.DeviceNotInModelException;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.WURFLModel;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WURFLUtils {
    private WURFLModel model;
    private DeviceProvider deviceProvider;
    private static final Log logger = LogFactory.getLog((Class)WURFLUtils.class);

    public WURFLUtils(WURFLModel model) {
        this(model, new DefaultDeviceProvider(model));
    }

    public WURFLUtils(WURFLModel model, DeviceProvider deviceProvider) {
        this.model = model;
        this.deviceProvider = deviceProvider;
    }

    public String getVersion() {
        return this.model.getVersion();
    }

    public boolean isDeviceDefined(String id) {
        Validate.notEmpty((String)id, (String)"deviceId must be not null");
        return this.model.isDeviceDefined(id);
    }

    public ModelDevice getModelDeviceById(String id) throws DeviceNotDefinedException {
        Validate.notEmpty((String)id, (String)"The id must be not null Set");
        return this.model.getDeviceById(id);
    }

    public Set getModelDevices(Set ids) throws DeviceNotDefinedException {
        Validate.notNull((Object)ids, (String)"The ids must be not null Set");
        Validate.noNullElements((Collection)ids, (String)"The ids must not containing null elements");
        Validate.allElementsOfType((Collection)ids, (Class)String.class, (String)"The ids must containing right devices id");
        return this.model.getDevices(ids);
    }

    public Set getAllDevicesId() {
        return this.model.getAllDevicesId();
    }

    public Set getAllModelDevices() {
        return this.model.getAllDevices();
    }

    public List getModelDeviceHierarchy(ModelDevice root) throws DeviceNotInModelException {
        Validate.notNull((Object)root, (String)"The root ModelDevice must be not null");
        return this.model.getDeviceHierarchy(root);
    }

    public ModelDevice getModelDeviceFallback(ModelDevice target) throws DeviceNotInModelException {
        Validate.notNull((Object)target, (String)"The target ModelDevice must be not null");
        return this.model.getDeviceFallback(target);
    }

    public ModelDevice getModelDeviceAncestor(ModelDevice target) throws DeviceNotInModelException {
        Validate.notNull((Object)target, (String)"The root ModelDevice must be not null");
        return this.model.getDeviceAncestor(target);
    }

    public boolean isCapabilityDefined(String capability) {
        Validate.notEmpty((String)capability, (String)"The capabilityName must be not null");
        return this.model.isCapabilityDefined(capability);
    }

    public Set getAllCapabilities() {
        return this.model.getAllCapabilities();
    }

    public String getGroupByCapability(String capability) throws CapabilityNotDefinedException {
        Validate.notEmpty((String)capability, (String)"The capabilityName must be not null");
        return this.model.getGroupByCapability(capability);
    }

    public ModelDevice getModelDeviceWhereCapabilityIsDefined(ModelDevice target, String capability) throws CapabilityNotDefinedException, DeviceNotInModelException {
        Validate.notNull((Object)target, (String)"The rootDevice must be not null Set");
        Validate.notEmpty((String)capability, (String)"The capabilityName must be not null");
        return this.model.getDeviceWhereCapabilityIsDefined(target, capability);
    }

    public boolean isGroupDefined(String group) {
        Validate.notEmpty((String)group, (String)"The groupName must be not null");
        return this.model.isGroupDefined(group);
    }

    public Set getAllGroups() {
        return this.model.getAllGroups();
    }

    public Set getCapabilitiesForGroup(String group) throws GroupNotDefinedException {
        Validate.notEmpty((String)group, (String)"The groupName must be not null");
        return this.model.getCapabilitiesForGroup(group);
    }

    public Device getDeviceById(String id) throws DeviceNotDefinedException {
        return this.deviceProvider.getDevice(id);
    }

    public Set getAllDevices() {
        Set ids = this.getAllDevicesId();
        HashSet<Device> devices = new HashSet<Device>(ids.size());
        Iterator idsIt = ids.iterator();
        while (idsIt.hasNext()) {
            String id = (String)idsIt.next();
            Device device = this.getDeviceById(id);
            devices.add(device);
        }
        return devices;
    }
}

