/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.handlers.matchers.AbstractMatcher;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;

public class KDDIMatcher
extends AbstractMatcher {
    public KDDIMatcher(Handler handler) {
        super(handler);
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        if (userAgent.startsWith("KDDI/")) {
            int tollerance = StringUtils.secondSlash(userAgent);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying RIS(SS) UA: " + userAgent));
            }
            return StringUtils.risMatch(userAgentsSet, userAgent, tollerance);
        }
        return super.lookForMatchingUserAgent(userAgentsSet, userAgent);
    }

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        return "opwv_v62_generic";
    }
}

