/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.resource;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.wurfl.core.CapabilityNotDefinedException;
import net.sourceforge.wurfl.core.DeviceNotDefinedException;
import net.sourceforge.wurfl.core.GroupNotDefinedException;
import net.sourceforge.wurfl.core.resource.DeviceNotInModelException;
import net.sourceforge.wurfl.core.resource.GenericNotDefinedException;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.ModelDevices;
import net.sourceforge.wurfl.core.resource.OrphanHierarchyException;
import net.sourceforge.wurfl.core.resource.ResourceData;
import net.sourceforge.wurfl.core.resource.WURFLConsistencyVerifier;
import net.sourceforge.wurfl.core.resource.WURFLModel;
import net.sourceforge.wurfl.core.resource.WURFLPatchingManager;
import net.sourceforge.wurfl.core.resource.WURFLResource;
import net.sourceforge.wurfl.core.resource.WURFLResources;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultWURFLModel
implements WURFLModel {
    private Map devicesById;
    private String version;
    private static final Log log = LogFactory.getLog((Class)DefaultWURFLModel.class);

    public DefaultWURFLModel(WURFLResource root) {
        this(root, new WURFLResources());
    }

    public DefaultWURFLModel(WURFLResource root, WURFLResources patches) {
        Validate.notNull((Object)root, (String)"The root resource must be not null.");
        ResourceData rootData = root.getData();
        this.version = rootData.getInfo();
        ModelDevices rootDevices = rootData.getDevices();
        ModelDevices tempDevices = new ModelDevices(rootDevices);
        if (log.isDebugEnabled()) {
            log.debug((Object)(tempDevices.size() + " devices found in " + rootData.getInfo()));
        }
        if (log.isDebugEnabled()) {
            WURFLConsistencyVerifier.verify(tempDevices);
        }
        for (int patchIndex = 0; patches != null && patchIndex < patches.size(); ++patchIndex) {
            WURFLResource patchResource = patches.get(patchIndex);
            ResourceData patchData = patchResource.getData();
            ModelDevices patchDevices = patchData.getDevices();
            if (log.isDebugEnabled()) {
                log.debug((Object)(patchDevices.size() + " devices found in " + patchData.getInfo()));
            }
            StrBuilder versionBuilder = new StrBuilder();
            versionBuilder.append(StringUtils.defaultString((String)this.version)).append("; ").append(patchData.getInfo());
            tempDevices = WURFLPatchingManager.patchDevices(tempDevices, patchDevices);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Verifing device after patch: " + patchData.getInfo()));
                WURFLConsistencyVerifier.verify(tempDevices);
            }
            this.version = versionBuilder.toString();
        }
        log.debug((Object)"Verifing building devicesById");
        WURFLConsistencyVerifier.verify(tempDevices);
        this.devicesById = new ConcurrentHashMap(tempDevices.getDevicesById());
        if (log.isInfoEnabled()) {
            log.info((Object)("WURFLModel version: " + this.version + "; devices: " + this.devicesById.size()));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public ModelDevice getDeviceById(String id) throws DeviceNotDefinedException {
        Validate.notEmpty((String)id, (String)"The id must be not null");
        ModelDevice modelDevice = (ModelDevice)this.devicesById.get(id);
        if (modelDevice == null) {
            throw new DeviceNotDefinedException(id);
        }
        return (ModelDevice)this.devicesById.get(id);
    }

    public Set getDevices(Set devicesIds) throws DeviceNotDefinedException {
        Validate.notNull((Object)devicesIds, (String)"The devicesIds must be not null Set");
        Validate.noNullElements((Collection)devicesIds, (String)"The devicesIds must not containing null elements");
        Validate.allElementsOfType((Collection)devicesIds, (Class)String.class, (String)"The devicesIds must containing right devicesById id");
        HashSet<ModelDevice> resultDevices = new HashSet<ModelDevice>();
        Iterator it = devicesIds.iterator();
        while (it.hasNext()) {
            resultDevices.add(this.getDeviceById((String)it.next()));
        }
        return resultDevices;
    }

    public Set getAllDevices() {
        HashSet returningDevices = new HashSet();
        returningDevices.addAll(this.devicesById.values());
        return returningDevices;
    }

    public Set getAllDevicesId() {
        HashSet returningIds = new HashSet();
        returningIds.addAll(this.devicesById.keySet());
        return returningIds;
    }

    public List getDeviceHierarchy(ModelDevice device) throws DeviceNotInModelException {
        Validate.notNull((Object)device, (String)"The device must be not null");
        LinkedList<ModelDevice> hierarchy = new LinkedList<ModelDevice>();
        ModelDevice looper = device;
        while (!"generic".equals(looper.getID())) {
            hierarchy.addFirst(looper);
            looper = this.getDeviceFallback(looper);
        }
        hierarchy.addFirst(looper);
        return hierarchy;
    }

    public ModelDevice getDeviceFallback(ModelDevice device) throws DeviceNotInModelException {
        Validate.notNull((Object)device, (String)"The device must be not null");
        ModelDevice fallback = null;
        try {
            fallback = this.getDeviceById(device.getFallBack());
        }
        catch (DeviceNotDefinedException e) {
            throw new DeviceNotInModelException(device);
        }
        return fallback;
    }

    public ModelDevice getDeviceAncestor(ModelDevice device) throws DeviceNotInModelException {
        Validate.notNull((Object)device, (String)"The device must be not null");
        ModelDevice ancestor = device;
        ModelDevice generic = this.getGenericDevice();
        List hierarchy = this.getDeviceHierarchy(device);
        ReverseListIterator hit = new ReverseListIterator(hierarchy);
        while (hit.hasNext() && !ancestor.isActualDeviceRoot() && !generic.equals(ancestor)) {
            ancestor = (ModelDevice)hit.next();
        }
        if (!ancestor.isActualDeviceRoot() && !generic.equals(ancestor)) {
            throw new RuntimeException("Hierarchy is invalid");
        }
        return ancestor;
    }

    public boolean isDeviceDefined(String deviceId) {
        Validate.notEmpty((String)deviceId, (String)"The deviceId must be not null");
        return this.devicesById.containsKey(deviceId);
    }

    public int size() {
        return this.devicesById.size();
    }

    public Set getAllGroups() {
        ModelDevice generic = this.getGenericDevice();
        return generic.getGroups();
    }

    public boolean isGroupDefined(String groupId) {
        Validate.notEmpty((String)groupId, (String)"The groupId must be not null");
        ModelDevice generic = this.getGenericDevice();
        return generic.defineGroup(groupId);
    }

    public String getGroupByCapability(String capabilityName) throws CapabilityNotDefinedException {
        Validate.notEmpty((String)capabilityName, (String)"The capabilityName must be not null");
        ModelDevice generic = this.getGenericDevice();
        if (!generic.defineCapability(capabilityName)) {
            throw new CapabilityNotDefinedException(capabilityName);
        }
        return generic.getGroupForCapability(capabilityName);
    }

    public Set getAllCapabilities() {
        ModelDevice generic = this.getGenericDevice();
        return new HashSet(generic.getCapabilities().keySet());
    }

    public boolean isCapabilityDefined(String capability) {
        Validate.notEmpty((String)capability, (String)"The capability must be not null");
        ModelDevice generic = this.getGenericDevice();
        return generic.defineCapability(capability);
    }

    public Set getCapabilitiesForGroup(String groupId) throws GroupNotDefinedException {
        Validate.notEmpty((String)groupId, (String)"The groupId must be not null");
        ModelDevice generic = this.getGenericDevice();
        if (!generic.defineGroup(groupId)) {
            throw new GroupNotDefinedException(groupId);
        }
        return generic.getCapabilitiesNamesForGroup(groupId);
    }

    public ModelDevice getDeviceWhereCapabilityIsDefined(ModelDevice rootDevice, String name) throws DeviceNotInModelException, CapabilityNotDefinedException {
        Validate.notNull((Object)rootDevice, (String)"The rootDevice must be not null");
        Validate.notEmpty((String)name, (String)"The name must be not null");
        List hierarchy = this.getDeviceHierarchy(rootDevice);
        ReverseListIterator hIt = new ReverseListIterator(hierarchy);
        while (hIt.hasNext()) {
            ModelDevice looper = (ModelDevice)hIt.next();
            if (looper.defineCapability(name)) {
                return looper;
            }
            if (!"generic".equals(looper.getID())) continue;
            throw new CapabilityNotDefinedException(name);
        }
        throw new RuntimeException(new OrphanHierarchyException(hierarchy));
    }

    protected ModelDevice getGenericDevice() {
        ModelDevice generic = (ModelDevice)this.devicesById.get("generic");
        if (generic == null && this.devicesById.size() > 0) {
            throw new RuntimeException(new GenericNotDefinedException());
        }
        return generic;
    }

    public String toString() {
        ToStringBuilder tb = new ToStringBuilder((Object)this);
        tb.append((Object)this.version);
        return tb.toString();
    }
}

