/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.resource;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ModelDevices
implements Serializable {
    private static final long serialVersionUID = 10L;
    private Map devicesById = new ConcurrentHashMap();

    public ModelDevices() {
    }

    public ModelDevices(ModelDevices devices) {
        this.devicesById.putAll(devices.devicesById);
    }

    public ModelDevices(Map devices) {
        Validate.notNull((Object)devices);
        Validate.noNullElements(devices.values());
        Validate.allElementsOfType(devices.keySet(), (Class)String.class);
        Validate.allElementsOfType(devices.values(), (Class)ModelDevice.class);
        this.devicesById.putAll(devices);
    }

    public ModelDevices(Collection devices) {
        Validate.notNull((Object)devices);
        Validate.noNullElements((Collection)devices);
        Validate.allElementsOfType((Collection)devices, (Class)ModelDevice.class);
        Iterator it = devices.iterator();
        while (it.hasNext()) {
            ModelDevice device = (ModelDevice)it.next();
            this.devicesById.put(device.getID(), device);
        }
    }

    public ModelDevices(ModelDevice[] devices) {
        this(Arrays.asList(devices));
    }

    public int size() {
        return this.devicesById.size();
    }

    public boolean contains(ModelDevice device) {
        return this.devicesById.containsValue(device);
    }

    public boolean containsId(String id) {
        return this.devicesById.containsKey(id);
    }

    public Set getDevices() {
        return new HashSet(this.devicesById.values());
    }

    public Map getDevicesById() {
        return UnmodifiableMap.decorate((Map)this.devicesById);
    }

    public Iterator iterator() {
        return IteratorUtils.unmodifiableIterator(this.devicesById.values().iterator());
    }

    public ModelDevice getById(String id) {
        return (ModelDevice)this.devicesById.get(id);
    }

    public void add(ModelDevice device) {
        this.devicesById.put(device.getID(), device);
    }

    public void addAll(Collection devices) {
        Validate.notNull((Object)devices);
        Validate.noNullElements((Collection)devices);
        Validate.allElementsOfType((Collection)devices, (Class)ModelDevice.class);
        Iterator it = devices.iterator();
        while (it.hasNext()) {
            ModelDevice device = (ModelDevice)it.next();
            this.devicesById.put(device.getID(), device);
        }
    }

    public void addAll(ModelDevices devices) {
        this.devicesById.putAll(devices.devicesById);
    }

    public void remove(ModelDevice device) {
        this.devicesById.remove(device.getID());
    }

    public void removeAll(Collection devices) {
        Iterator it = devices.iterator();
        while (it.hasNext()) {
            ModelDevice device = (ModelDevice)it.next();
            this.devicesById.remove(device.getID());
        }
    }

    public void removeAll(ModelDevices devices) {
        Iterator it = devices.iterator();
        while (it.hasNext()) {
            ModelDevice device = (ModelDevice)it.next();
            this.devicesById.remove(device.getID());
        }
    }

    public void clear() {
        this.devicesById.clear();
    }

    public int hashCode() {
        HashCodeBuilder hb = new HashCodeBuilder();
        hb.append(this.getClass()).append((Object)this.devicesById);
        return hb.toHashCode();
    }

    public boolean equals(Object obj) {
        EqualsBuilder eb = new EqualsBuilder();
        eb.appendSuper(this.getClass().isInstance(obj));
        if (eb.isEquals()) {
            ModelDevices other = (ModelDevices)obj;
            eb.append((Object)this.devicesById, (Object)other.devicesById);
        }
        return eb.isEquals();
    }
}

