/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.resource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.ModelDevices;
import net.sourceforge.wurfl.core.resource.UserAgentOverrideException;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WURFLPatchingManager {
    private static final Log log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ModelDevices patchDevices(ModelDevices devices, ModelDevices patchingDevices) {
        ModelDevices patchedDevices = new ModelDevices(devices);
        Iterator patchingDevicesIterator = patchingDevices.iterator();
        while (patchingDevicesIterator.hasNext()) {
            ModelDevice patchedDevice = null;
            ModelDevice patchingDevice = (ModelDevice)patchingDevicesIterator.next();
            if (devices.containsId(patchingDevice.getID())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Patching device: " + patchingDevice.getID()));
                }
                ModelDevice existDevice = devices.getById(patchingDevice.getID());
                patchedDevice = WURFLPatchingManager.patchDevice(existDevice, patchingDevice);
                patchedDevices.remove(existDevice);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding device: " + patchingDevice.getID()));
                }
                patchedDevice = patchingDevice;
            }
            if (!$assertionsDisabled && patchedDevice == null) {
                throw new AssertionError((Object)"patchedDevice is null");
            }
            patchedDevices.add(patchedDevice);
        }
        return patchedDevices;
    }

    private static ModelDevice patchDevice(ModelDevice device, ModelDevice patchingDevice) {
        ModelDevice patchedDevice = null;
        HashMap patchedCapabilities = new HashMap(device.getCapabilities());
        patchedCapabilities.putAll(patchingDevice.getCapabilities());
        if (log.isTraceEnabled()) {
            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("Merged ").append(device.getID()).append(" capabilities: ").append((Object)device.getCapabilities()).append(" + ").append((Object)patchingDevice.getCapabilities()).append(" = ").append(patchedCapabilities);
            log.trace((Object)logBuilder.toString());
        }
        Map deviceCapabilitiesByGroup = device.getGroupsByCapability();
        Map patchingCapabilitiesByGroup = patchingDevice.getGroupsByCapability();
        HashMap patchedCapabilitiesByGroup = new HashMap();
        patchedCapabilitiesByGroup.putAll(deviceCapabilitiesByGroup);
        patchedCapabilitiesByGroup.putAll(patchingCapabilitiesByGroup);
        if (log.isTraceEnabled()) {
            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("Merged ").append(device.getID()).append(" capabilitiesByGroup: ").append((Object)deviceCapabilitiesByGroup).append(" + ").append((Object)patchingCapabilitiesByGroup).append(" = ").append(patchedCapabilitiesByGroup);
            log.trace((Object)logBuilder.toString());
        }
        if (!patchingDevice.getUserAgent().equals(device.getUserAgent())) {
            UserAgentOverrideException e = new UserAgentOverrideException(patchingDevice, patchingDevice.getUserAgent(), device.getUserAgent());
            throw new UserAgentOverrideException(device, patchingDevice.getUserAgent(), device.getUserAgent());
        }
        patchedDevice = new ModelDevice.Builder(device.getID(), device.getUserAgent(), patchingDevice.getFallBack()).setActualDeviceRoot(patchingDevice.isActualDeviceRoot()).setCapabilitiesByGroup(patchedCapabilitiesByGroup).setCapabilities(patchedCapabilities).build();
        return patchedDevice;
    }

    static {
        $assertionsDisabled = !WURFLPatchingManager.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)WURFLPatchingManager.class);
    }
}

