/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.ModelDevices;
import net.sourceforge.wurfl.core.resource.ResourceData;
import net.sourceforge.wurfl.core.resource.WURFLParsingException;
import net.sourceforge.wurfl.core.resource.WURFLResource;
import net.sourceforge.wurfl.core.resource.WURFLResourceException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLResource
implements WURFLResource {
    private static final Log log;
    private URI uri;
    private InputStream stream;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XMLResource(String path) {
        Validate.notEmpty((String)path, (String)"The path must be not empty");
        try {
            this.uri = XMLResource.createURI(path);
        }
        catch (URISyntaxException e) {
            throw new WURFLResourceException((WURFLResource)this, (Throwable)e);
        }
    }

    public XMLResource(File file) {
        Validate.notNull((Object)file, (String)"The file must be not null");
        this.uri = file.toURI();
    }

    public XMLResource(URI uri) {
        Validate.notNull((Object)uri, (String)"The URI must be not null");
        this.uri = uri;
    }

    public XMLResource(InputStream stream) {
        Validate.notNull((Object)stream, (String)"The stream must be not null");
        this.stream = stream;
    }

    public ResourceData getData() {
        if (this.stream == null) {
            if (this.uri != null) {
                this.stream = this.openInputStream(this.uri);
            } else {
                throw new WURFLResourceException((WURFLResource)this, "The resource can not be read, the stream is null");
            }
        }
        ResourceData data = this.readData(this.stream);
        if (this.stream.markSupported()) {
            try {
                this.stream.reset();
            }
            catch (IOException e) {
                this.releaseStream();
            }
        } else {
            this.releaseStream();
        }
        return data;
    }

    public String getInfo() {
        String info = null;
        info = this.uri != null ? this.uri.toString() : "Stream resource";
        return info;
    }

    public void release() {
        if (this.stream != null) {
            this.releaseStream();
        }
        this.uri = null;
    }

    public boolean isReloadable() {
        boolean isStreamResettable = this.stream != null && this.stream.markSupported();
        return isStreamResettable || this.uri != null;
    }

    public static URI createURI(String path) throws URISyntaxException {
        if (!$assertionsDisabled && !StringUtils.isNotBlank((String)path)) {
            throw new AssertionError((Object)"The path must be not blank");
        }
        URI createdURI = null;
        StrBuilder workingPathBuilder = new StrBuilder();
        workingPathBuilder.append(path);
        workingPathBuilder.replaceAll(" ", "%20");
        if (SystemUtils.IS_OS_WINDOWS && StringUtils.contains((String)path, (String)"\\")) {
            log.debug((Object)"Encoding windows URI");
            workingPathBuilder.replaceAll("\\\\", "/");
        }
        if (!workingPathBuilder.contains(':')) {
            workingPathBuilder.insert(0, "file://");
        }
        createdURI = URI.create(workingPathBuilder.toString());
        log.debug((Object)("Created URI: " + createdURI + " from path: " + path));
        return createdURI;
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace((String)location, (String)" ", (String)"%20"));
    }

    protected InputStream openInputStream(URI uri) {
        InputStream input = null;
        try {
            URL url;
            URLConnection connection;
            if (uri.getScheme().equals("classpath")) {
                StrBuilder pathBuilder = new StrBuilder();
                pathBuilder.append(uri.toString());
                pathBuilder.replaceFirst("classpath:", "");
                uri = URI.create(this.getClass().getResource(pathBuilder.toString()).toString());
            }
            if (StringUtils.equals((String)"application/zip", (String)(connection = (url = uri.toURL()).openConnection()).getContentType())) {
                ZipFile zipFile = new ZipFile(new File(uri));
                ZipEntry zipEntry = zipFile.entries().nextElement();
                input = zipFile.getInputStream(zipEntry);
            } else {
                input = uri.getPath().endsWith("gz") ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error opening stream URI:" + uri.toString()));
            throw new WURFLResourceException((WURFLResource)this, (Throwable)e);
        }
        log.debug((Object)("Opened stream from URI: " + uri));
        return input;
    }

    protected ResourceData readData(InputStream input) {
        WURFLSAXHandler handler = new WURFLSAXHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new WURFLResourceException((WURFLResource)this, (Throwable)e);
        }
        String name = this.getInfo();
        String version = handler.getVer();
        boolean patch = handler.isPatch();
        ModelDevices devices = handler.getDevices();
        ResourceData data = new ResourceData(name, version, patch, devices);
        log.debug((Object)("Readed data: " + data));
        return data;
    }

    private void releaseStream() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            log.warn((Object)"Error closing stream");
        }
        this.stream = null;
    }

    static {
        $assertionsDisabled = !XMLResource.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)XMLResource.class);
    }

    static class WURFLSAXHandler
    extends DefaultHandler {
        private static final String ELEM_WURFL = "wurfl";
        private static final String ELEM_WURFL_PATCH = "wurfl_patch";
        private static final String ELEM_DEVICE = "device";
        private static final String ELEM_DEVICES = "devices";
        private static final String ELEM_GROUP = "group";
        private static final String ELEM_CAPABILITY = "capability";
        private static final String ELEM_VERSION = "version";
        private static final String ELEM_VER = "ver";
        private static final String ATTR_DEVICE_ID = "id";
        private static final String ATTR_DEVICE_FALLBACK = "fall_back";
        private static final String ATTR_DEVICE_USERAGENT = "user_agent";
        private static final String ATTR_DEVICE_ACTUALDEVICEROOT = "actual_device_root";
        private static final String ATTR_GROUP_ID = "id";
        private static final String ATTR_CAPABILITY_NAME = "name";
        private static final String ATTR_CAPABILITY_VALUE = "value";
        private String userAgent;
        private String deviceID;
        private String fallBack;
        private boolean actualDeviceRoot;
        private String groupID;
        private String capabilityName;
        private String capabilityValue;
        private Set userAgents;
        private Set devicesId;
        private Map capabilities;
        private Map capabilitiesByGroup;
        private ModelDevices devices;
        private String ver;
        private boolean insideVer = false;
        private boolean patch = false;
        private boolean root = false;

        WURFLSAXHandler() {
        }

        public String getVer() {
            return this.ver;
        }

        public ModelDevices getDevices() {
            return this.devices;
        }

        public boolean isPatch() {
            return this.patch;
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.userAgents = new HashSet();
            this.devicesId = new HashSet();
            this.devices = new ModelDevices();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (ELEM_DEVICE.equals(name)) {
                this.deviceStartElement(attributes);
            } else if (ELEM_GROUP.equals(name)) {
                this.startGroupElement(attributes);
            } else if (ELEM_CAPABILITY.equals(name)) {
                this.startCapabilityElement(attributes);
            } else if (ELEM_VER.equals(name)) {
                this.startVerElement();
            } else if (ELEM_WURFL_PATCH.equals(name)) {
                this.startWurflPatchElement();
            } else if (ELEM_WURFL.equals(name)) {
                this.startWurflElement();
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (ELEM_GROUP.equals(name)) {
                this.endGroupElement();
            } else if (ELEM_DEVICE.equals(name)) {
                this.endDeviceElement();
            } else if (ELEM_VER.equals(name)) {
                this.endVerElement();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.insideVer) {
                this.charsVer(ch, start, length);
            }
        }

        private void startWurflElement() {
            if (this.patch || this.root) {
                throw new WURFLParsingException("Root element already defined: wurfl");
            }
            this.root = true;
        }

        private void startWurflPatchElement() {
            if (this.patch || this.root) {
                throw new WURFLParsingException("Root element already defined: wurfl_patch");
            }
            this.patch = true;
        }

        private void startVerElement() {
            this.insideVer = true;
        }

        public void charsVer(char[] ch, int start, int length) {
            StrBuilder verBuilder = new StrBuilder();
            verBuilder.append(ch, start, length);
            this.ver = verBuilder.toString();
        }

        private void endVerElement() {
            this.insideVer = false;
        }

        private void deviceStartElement(Attributes attributes) {
            this.userAgent = attributes.getValue(ATTR_DEVICE_USERAGENT);
            this.deviceID = attributes.getValue("id");
            this.fallBack = attributes.getValue(ATTR_DEVICE_FALLBACK);
            this.actualDeviceRoot = Boolean.valueOf(attributes.getValue(ATTR_DEVICE_ACTUALDEVICEROOT));
            if (StringUtils.isEmpty((String)this.deviceID)) {
                throw new WURFLParsingException("device id is not a valid");
            }
            if (!"generic".equals(this.deviceID) && StringUtils.isEmpty((String)this.userAgent)) {
                StringBuffer msg = new StringBuffer();
                msg.append("Device with id ").append(this.deviceID).append(" has an invalid user agent");
                throw new WURFLParsingException(msg.toString());
            }
            if (this.devicesId.contains(this.deviceID)) {
                throw new WURFLParsingException("device id " + this.deviceID + " already defined!!!");
            }
            if (this.userAgents.contains(this.userAgent)) {
                throw new WURFLParsingException("user agent [" + this.userAgent + "] already defined");
            }
            this.userAgents.add(this.userAgent);
            this.devicesId.add(this.deviceID);
            this.capabilities = new HashMap();
            this.capabilitiesByGroup = new HashMap();
        }

        private void endDeviceElement() {
            ModelDevice device = new ModelDevice.Builder(this.deviceID, this.userAgent, this.fallBack).setActualDeviceRoot(this.actualDeviceRoot).setCapabilities(this.capabilities).setCapabilitiesByGroup(this.capabilitiesByGroup).build();
            this.devices.add(device);
        }

        private void startCapabilityElement(Attributes attributes) {
            this.capabilityName = attributes.getValue(ATTR_CAPABILITY_NAME);
            this.capabilityValue = attributes.getValue(ATTR_CAPABILITY_VALUE);
            if (StringUtils.isEmpty((String)this.capabilityName) || null == this.capabilityValue) {
                throw new WURFLParsingException("device with id " + this.deviceID + " has capability with name or value not valid");
            }
            if (this.capabilities.containsKey(this.capabilityName)) {
                throw new WURFLParsingException("The devices with id " + this.deviceID + " define more " + this.capabilityName);
            }
            String internCapabilityName = this.capabilityName.intern();
            String internGroupId = this.groupID.intern();
            this.capabilities.put(internCapabilityName, this.capabilityValue);
            this.capabilitiesByGroup.put(internCapabilityName, internGroupId);
        }

        private void startGroupElement(Attributes attributes) {
            this.groupID = attributes.getValue("id");
        }

        private void endGroupElement() {
        }
    }
}

