/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.classifiers;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.Filter;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseFilter
implements Filter {
    private final FilteredDevices filteredDevices;
    private final Handler handler;
    private static final Log log = LogFactory.getLog((Class)BaseFilter.class);

    public BaseFilter(Handler handler) {
        this.handler = handler;
        this.filteredDevices = new FilteredDevices();
    }

    public boolean canHandle(String userAgent) {
        return this.handler.canHandle(userAgent);
    }

    public void filter(String userAgent, String deviceID) {
        if (log.isTraceEnabled()) {
            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("Putting Device: ").append(deviceID).append(" into filter");
            log.trace((Object)logBuilder.toString());
        }
        this.filteredDevices.putDevice(userAgent, deviceID);
    }

    public FilteredDevices getFilteredDevices() {
        return this.filteredDevices;
    }
}

