/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.handlers.matchers.Matcher;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMatcher
implements Matcher {
    private final Handler handler;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Log undetected = LogFactory.getLog((String)"net.sourceforge.wurfl.core.UNDETECTED_WURFL_DEVICES");
    protected final Log detected = LogFactory.getLog((String)"net.sourceforge.wurfl.core.DETECTED_WURFL_DEVICES");
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractMatcher(Handler handler) {
        this.handler = handler;
    }

    public boolean canHandle(WURFLRequest request) {
        return this.handler.canHandle(request.getUserAgent());
    }

    public final String match(WURFLRequest request, FilteredDevices filteredDevices) {
        String deviceID;
        String userAgent = this.handler.normalize(request.getUserAgent());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying Direct Match on UA: " + userAgent));
        }
        if ((deviceID = filteredDevices.getDevice(userAgent)) != null) {
            return deviceID;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying Conclusive Match on UA: " + userAgent));
        }
        if (!this.isNullOrGeneric(deviceID = this.applyConclusiveMatch(request, filteredDevices))) {
            return deviceID;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying Recovery Match on UA: " + userAgent));
        }
        if (!this.isNullOrGeneric(deviceID = this.applyRecoveryMatch(request, filteredDevices))) {
            return deviceID;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying CatchAll Recovery Match on UA: " + userAgent));
        }
        deviceID = this.applyCatchAllRecoveryMatch(request, filteredDevices);
        if (!$assertionsDisabled && deviceID == null) {
            throw new AssertionError();
        }
        return deviceID;
    }

    protected String applyConclusiveMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Matching UA: " + request.getUserAgent() + " against devices: " + filteredDevices.getUserAgents()));
        }
        String match = this.lookForMatchingUserAgent(filteredDevices.getUserAgents(), request.getUserAgent());
        if (this.undetected.isDebugEnabled() && match == null) {
            this.undetected.debug((Object)(request.getUserAgent() + ":" + request.getUserAgentProfile()));
        }
        String deviceID = "generic";
        if (null != match) {
            if (this.detected.isDebugEnabled()) {
                this.detected.debug((Object)(request.getUserAgent() + ":" + request.getUserAgentProfile() + ":" + match));
            }
            deviceID = filteredDevices.getDevice(match);
        }
        if (deviceID == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("filteredDevices do not contain UA: " + match + " return generic"));
            }
            deviceID = "generic";
        }
        return deviceID;
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        int tollerance = StringUtils.firstSlash(userAgent);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying RIS(FS) UA: " + userAgent));
        }
        return StringUtils.risMatch(userAgentsSet, userAgent, tollerance);
    }

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        return "generic";
    }

    protected String applyCatchAllRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        String userAgent = request.getUserAgent();
        if (userAgent.indexOf("UP.Browser/7.2") != -1) {
            return "opwv_v72_generic";
        }
        if (userAgent.indexOf("UP.Browser/7") != -1) {
            return "opwv_v7_generic";
        }
        if (userAgent.indexOf("UP.Browser/6.2") != -1) {
            return "opwv_v62_generic";
        }
        if (userAgent.indexOf("UP.Browser/6") != -1) {
            return "opwv_v6_generic";
        }
        if (userAgent.indexOf("UP.Browser/5") != -1) {
            return "upgui_generic";
        }
        if (userAgent.indexOf("UP.Browser/4") != -1) {
            return "uptext_generic";
        }
        if (userAgent.indexOf("UP.Browser/3") != -1) {
            return "uptext_generic";
        }
        if (userAgent.indexOf("Series60") != -1) {
            return "nokia_generic_series60";
        }
        if (userAgent.indexOf("NetFront/3.0") != -1 || userAgent.indexOf("ACS-NF/3.0") != -1) {
            return "netfront_ver3";
        }
        if (userAgent.indexOf("NetFront/3.1") != -1 || userAgent.indexOf("ACS-NF/3.1") != -1) {
            return "netfront_ver3_1";
        }
        if (userAgent.indexOf("NetFront/3.2") != -1 || userAgent.indexOf("ACS-NF/3.2") != -1) {
            return "netfront_ver3_2";
        }
        if (userAgent.indexOf("NetFront/3.3") != -1 || userAgent.indexOf("ACS-NF/3.3") != -1) {
            return "netfront_ver3_3";
        }
        if (userAgent.indexOf("NetFront/3.4") != -1) {
            return "netfront_ver3_4";
        }
        if (userAgent.indexOf("NetFront/3.5") != -1) {
            return "netfront_ver3_5";
        }
        if (userAgent.indexOf("Windows CE") != -1) {
            return "ms_mobile_browser_ver1";
        }
        if (userAgent.indexOf("Mozilla/4.0") != -1) {
            return "generic_web_browser";
        }
        if (userAgent.indexOf("Mozilla/5.0") != -1) {
            return "generic_web_browser";
        }
        if (userAgent.indexOf("Mozilla/6.0") != -1) {
            return "generic_web_browser";
        }
        if (userAgent.indexOf("Mozilla/") != -1) {
            return "generic_xhtml";
        }
        if (userAgent.indexOf("ObigoInternetBrowser/Q03C") != -1 || userAgent.indexOf("AU-MIC/2") != -1 || userAgent.indexOf("AU-MIC-") != -1 || userAgent.indexOf("AU-OBIGO/") != -1 || userAgent.indexOf("Obigo/Q03") != -1 || userAgent.indexOf("Obigo/Q04") != -1 || userAgent.indexOf("ObigoInternetBrowser/2") != -1 || userAgent.indexOf("Teleca Q03B1") != -1) {
            return "generic_xhtml";
        }
        if (userAgent.indexOf("Opera Mini/1") != -1) {
            return "opera_mini_ver1";
        }
        if (userAgent.indexOf("Opera Mini/2") != -1) {
            return "opera_mini_ver2";
        }
        if (userAgent.indexOf("Opera Mini/3") != -1) {
            return "opera_mini_ver3";
        }
        if (userAgent.indexOf("Opera Mini/4") != -1) {
            return "opera_mini_ver4";
        }
        if (userAgent.startsWith("DoCoMo") || userAgent.startsWith("KDDI")) {
            return "docomo_generic_jap_ver1";
        }
        return "generic";
    }

    private boolean isNullOrGeneric(String deviceID) {
        return deviceID == null || "generic".equals(deviceID);
    }

    static {
        $assertionsDisabled = !AbstractMatcher.class.desiredAssertionStatus();
    }
}

