/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.handlers.matchers.Matcher;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MatcherChain {
    private final List matchers = new ArrayList();
    private static final Log log = LogFactory.getLog((Class)MatcherChain.class);

    public void add(Matcher matcher) {
        this.matchers.add(matcher);
    }

    public List getMatchers() {
        return Collections.unmodifiableList(this.matchers);
    }

    public String match(WURFLRequest request, FilteredDevices filteredDevices) {
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            Matcher matcher = (Matcher)iterator.next();
            if (!matcher.canHandle(request)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matcher: " + matcher + " handle request: " + request));
            }
            String matchedDeviceId = matcher.match(request, filteredDevices);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request: " + request + " match device: " + matchedDeviceId));
            }
            return matchedDeviceId;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("No any matcher can handle the request: " + request + ", returning generic device."));
        }
        return "generic";
    }
}

