/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.handlers.matchers.AbstractMatcher;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;

public class MotorolaMatcher
extends AbstractMatcher {
    private static final int MOTOROLA_TOLLERANCE = 5;

    public MotorolaMatcher(Handler handler) {
        super(handler);
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        if (userAgent.startsWith("Mot-") || userAgent.startsWith("MOT-") || userAgent.startsWith("Motorola")) {
            return super.lookForMatchingUserAgent(userAgentsSet, userAgent);
        }
        return StringUtils.ldMatch(userAgentsSet, userAgent, 5);
    }

    protected String applyCatchAllRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        String userAgent = request.getUserAgent();
        if (userAgent.indexOf("MIB/2.2") != -1 || userAgent.indexOf("MIB/BER2.2") != -1) {
            return "mot_mib22_generic";
        }
        return "generic";
    }
}

