/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.handlers.matchers.AbstractMatcher;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import org.apache.commons.lang.StringUtils;

public class NokiaMatcher
extends AbstractMatcher {
    public NokiaMatcher(Handler handler) {
        super(handler);
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        int tollerance = net.sourceforge.wurfl.core.utils.StringUtils.indexOfOrLength(userAgent, "/", userAgent.indexOf("Nokia"));
        String match = net.sourceforge.wurfl.core.utils.StringUtils.risMatch(userAgentsSet, userAgent, tollerance);
        return match;
    }

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        String userAgent = request.getUserAgent();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying Nokia Recovery Match on User-Agent: " + userAgent));
        }
        if (StringUtils.contains((String)userAgent, (String)"Series60")) {
            return "nokia_generic_series60";
        }
        if (StringUtils.contains((String)userAgent, (String)"Series80")) {
            return "nokia_generic_series80";
        }
        return "generic";
    }
}

