/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.matchers.AbstractMatcher;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;

public class SamsungMatcher
extends AbstractMatcher {
    public SamsungMatcher(Handler handler) {
        super(handler);
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        String match = null;
        if (userAgent.startsWith("SEC-") || userAgent.startsWith("SAMSUNG-") || userAgent.startsWith("SCH")) {
            match = super.lookForMatchingUserAgent(userAgentsSet, userAgent);
        } else if (userAgent.startsWith("Samsung") || userAgent.startsWith("SPH") || userAgent.startsWith("SGH")) {
            int tollerance = net.sourceforge.wurfl.core.utils.StringUtils.firstSpace(userAgent);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying RIS(FP) UA: " + userAgent));
            }
            match = net.sourceforge.wurfl.core.utils.StringUtils.risMatch(userAgentsSet, userAgent, tollerance);
        } else if (userAgent.startsWith("SAMSUNG/")) {
            int tollerance = net.sourceforge.wurfl.core.utils.StringUtils.secondSlash(userAgent);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying RIS(SS) UA: " + userAgent));
            }
            match = net.sourceforge.wurfl.core.utils.StringUtils.risMatch(userAgentsSet, userAgent, tollerance);
        } else if (StringUtils.contains((String)userAgent, (String)"Samsung/SGH-L870")) {
            int tollerance = net.sourceforge.wurfl.core.utils.StringUtils.ordinalIndexOfOrLength(userAgent, "/", 5);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying RIS('/',5) UA: " + userAgent));
            }
            match = net.sourceforge.wurfl.core.utils.StringUtils.risMatch(userAgentsSet, userAgent, tollerance);
        } else if (this.logger.isWarnEnabled()) {
            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("The User-Agent: '").append(userAgent).append("' is not handled by Samsung matcher.");
            this.logger.warn((Object)logBuilder.toString());
        }
        return match;
    }
}

