/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.request;

import javax.servlet.http.HttpServletRequest;
import net.sourceforge.wurfl.core.request.DefaultUserAgentNormalizerFactory;
import net.sourceforge.wurfl.core.request.DefaultUserAgentResolver;
import net.sourceforge.wurfl.core.request.DefaultWURFLRequest;
import net.sourceforge.wurfl.core.request.UserAgentResolver;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.request.WURFLRequestFactory;
import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;
import net.sourceforge.wurfl.core.utils.UserAgentUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultWURFLRequestFactory
implements WURFLRequestFactory {
    private static final Log log = LogFactory.getLog((Class)DefaultWURFLRequestFactory.class);
    private final UserAgentNormalizer userAgentNormalizer;
    private final UserAgentResolver userAgentResolver;

    public DefaultWURFLRequestFactory() {
        this(new DefaultUserAgentResolver(), new DefaultUserAgentNormalizerFactory().create());
    }

    public DefaultWURFLRequestFactory(UserAgentResolver userAgentResolver, UserAgentNormalizer userAgentNormalizer) {
        Validate.notNull((Object)userAgentResolver, (String)"userAgentResolver is null");
        Validate.notNull((Object)userAgentResolver, (String)"userAgentResolver is null");
        this.userAgentResolver = userAgentResolver;
        this.userAgentNormalizer = userAgentNormalizer;
    }

    public DefaultWURFLRequestFactory(UserAgentNormalizer userAgentNormalizer) {
        this(new DefaultUserAgentResolver(), userAgentNormalizer);
    }

    public DefaultWURFLRequestFactory(UserAgentResolver userAgentResolver) {
        this(userAgentResolver, new DefaultUserAgentNormalizerFactory().create());
    }

    public WURFLRequest createRequest(HttpServletRequest sourceRequest) {
        Validate.notNull((Object)sourceRequest, (String)"The sourceRequest must be not null");
        String userAgent = StringUtils.trimToEmpty((String)this.userAgentResolver.resolve(sourceRequest));
        if (StringUtils.isNotEmpty((String)userAgent)) {
            userAgent = this.userAgentNormalizer.normalize(userAgent);
        }
        String uaProf = UserAgentUtils.getUaProfile(sourceRequest);
        DefaultWURFLRequest request = new DefaultWURFLRequest(userAgent, uaProf);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created DefaultWURFLRequest: " + request));
        }
        return request;
    }

    public WURFLRequest createRequest(String userAgent) {
        if (StringUtils.isNotEmpty((String)(userAgent = StringUtils.trimToEmpty((String)userAgent)))) {
            userAgent = this.userAgentNormalizer.normalize(userAgent);
        }
        return new DefaultWURFLRequest(userAgent, null);
    }
}

