/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.wurfl.core.resource.WURFLResource;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class WURFLResources {
    private final List resources = new ArrayList();

    public WURFLResources() {
    }

    public WURFLResources(WURFLResource[] resources) {
        Validate.notNull((Object)resources, (String)"The resources is null");
        this.resources.addAll(Arrays.asList(resources));
    }

    public WURFLResources(Collection resources) {
        Validate.notNull((Object)resources, (String)"The resources is null");
        Validate.noNullElements((Collection)resources, (String)"The resources contains null value");
        Validate.allElementsOfType((Collection)resources, (Class)WURFLResource.class, (String)"The resources contains value not instaceof WURFLResource");
        this.resources.addAll(resources);
    }

    public int size() {
        return this.resources.size();
    }

    public WURFLResource get(int index) {
        return (WURFLResource)this.resources.get(index);
    }

    public int indexOf(WURFLResource resource) {
        Validate.notNull((Object)resource, (String)"The resource is null");
        return this.resources.indexOf(resource);
    }

    public void release() {
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            WURFLResource resource = (WURFLResource)iterator.next();
            resource.release();
        }
    }

    public void add(WURFLResource resource) {
        Validate.notNull((Object)resource, (String)"The resource must be not null");
        this.resources.add(resource);
    }

    public void remove(WURFLResource resource) {
        Validate.notNull((Object)resource, (String)"The resource must be not null");
        this.resources.remove(resource);
    }

    public Iterator iterator() {
        return this.resources.iterator();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.resources).toString();
    }

    public boolean equals(Object obj) {
        EqualsBuilder eb = new EqualsBuilder();
        eb.appendSuper(this.getClass().isInstance(obj));
        if (eb.isEquals()) {
            WURFLResources other = (WURFLResources)obj;
            eb.append((Object)this.resources, (Object)other.resources);
        }
        return eb.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hb = new HashCodeBuilder(53, 79);
        hb.append(this.getClass()).append((Object)this.resources);
        return hb.toHashCode();
    }
}

